/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class AddScheduleProviderSupport
extends SpecialWizardSupport {
    String providerEntity;

    protected void reset() {
        this.providerEntity = this.getEntityData()[0].getModelEntity().getName();
    }

    public String[] getActionNames(int stepId) {
        if (this.getStepId() < this.getEntityData().length - 1) {
            if (this.getStepId() == 0) {
                return new String[]{NEXT, CANCEL};
            }
            return new String[]{BACK, NEXT, CANCEL};
        }
        if (this.getEntityData().length > 0) {
            return new String[]{BACK, FINISH, CANCEL};
        }
        return new String[]{FINISH, CANCEL, HELP};
    }

    public boolean isActionEnabled(String name) {
        return !FINISH.equals(name) || this.getStepId() >= this.getEntityData().length - 1;
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setFinished(true);
        } else if (BACK.equals(name)) {
            if (this.getStepId() == 0) {
                return;
            }
            this.setStepId(this.getStepId() - 1);
        } else if (NEXT.equals(name)) {
            if (this.getStepId() >= this.getEntityData().length - 1) {
                return;
            }
            this.setStepId(this.getStepId() + 1);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    protected void execute() throws XModelException {
        Properties p1;
        Properties p0 = this.extractStepData(0);
        XModelObject provider = XModelObjectLoaderUtil.createValidObject((XModel)this.getTarget().getModel(), (String)this.providerEntity, (Properties)p0);
        String scheduleEntity = this.getScheduleEntity(provider, p1 = this.extractStepData(1));
        if (scheduleEntity != null) {
            XModelObject bus = XModelObjectLoaderUtil.createValidObject((XModel)this.getTarget().getModel(), (String)scheduleEntity, (Properties)p1);
            provider.addChild(bus);
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)this.getTarget(), (XModelObject)provider, (int)FindObjectHelper.EVERY_WHERE);
    }

    private String getScheduleEntity(XModelObject provider, Properties p1) {
        String scheduleKind = p1.getProperty("schedule kind");
        XChild[] cs = provider.getModelEntity().getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i].getName().indexOf(scheduleKind) >= 0) {
                return cs[i].getName();
            }
            ++i;
        }
        return null;
    }

    public boolean canBeProcessedByStandardWizard() {
        return true;
    }
}

