/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util.xpl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.jboss.tools.test.util.xpl.DisplayHelper;

public class EditorTestHelper {
    public static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String COMPILATION_UNIT_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    public static final String RESOURCE_PERSPECTIVE_ID = "org.eclipse.ui.resourcePerspective";
    public static final String JAVA_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";
    public static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    public static final String PACKAGE_EXPLORER_VIEW_ID = "org.eclipse.jdt.ui.PackageExplorer";
    public static final String NAVIGATOR_VIEW_ID = "org.eclipse.ui.views.ResourceNavigator";
    public static final String INTRO_VIEW_ID = "org.eclipse.ui.internal.introview";

    public static void closeEditor(IEditorPart editor) {
        IWorkbenchPage page;
        IWorkbenchPartSite site;
        if (editor != null && (site = editor.getSite()) != null && (page = site.getPage()) != null) {
            page.closeEditor(editor, false);
        }
    }

    public static void closeAllEditors() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] editorReferences = pages[j].getEditorReferences();
                int k = 0;
                while (k < editorReferences.length) {
                    EditorTestHelper.closeEditor(editorReferences[k].getEditor(false));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void runEventQueue() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        if (window != null) {
            EditorTestHelper.runEventQueue(window.getShell());
        }
    }

    public static void runEventQueue(IWorkbenchPart part) {
        EditorTestHelper.runEventQueue(part.getSite().getShell());
    }

    public static void runEventQueue(Shell shell) {
        EditorTestHelper.runEventQueue(shell.getDisplay());
    }

    public static void runEventQueue(Display display) {
        while (display.readAndDispatch()) {
        }
    }

    public static void runEventQueue(long millis) {
        EditorTestHelper.runEventQueue(EditorTestHelper.getActiveDisplay(), millis);
    }

    public static void runEventQueue(IWorkbenchPart part, long millis) {
        EditorTestHelper.runEventQueue(part.getSite().getShell(), millis);
    }

    public static void runEventQueue(Shell shell, long millis) {
        EditorTestHelper.runEventQueue(shell.getDisplay(), millis);
    }

    public static void runEventQueue(Display display, long minTime) {
        if (display != null) {
            DisplayHelper.sleep(display, minTime);
        } else {
            EditorTestHelper.sleep((int)minTime);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static void forceFocus() {
        Shell shell;
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] wbWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (wbWindows.length == 0) {
                return;
            }
            window = wbWindows[0];
        }
        if ((shell = window.getShell()) != null && !shell.isDisposed()) {
            shell.forceActive();
            shell.forceFocus();
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getActivePage() : null;
    }

    public static Display getActiveDisplay() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getShell().getDisplay() : null;
    }

    public static void joinBackgroundActivities() throws CoreException {
        Logger.global.entering("EditorTestHelper", "joinBackgroundActivities");
        Logger.global.finer("join builder");
        EditorTestHelper.joinJobs(0L, 10000L, 500L);
        Logger.global.exiting("EditorTestHelper", "joinBackgroundActivities");
    }

    public static boolean joinJobs(long minTime, long maxTime, long intervalTime) {
        Logger.global.entering("EditorTestHelper", "joinJobs");
        EditorTestHelper.runEventQueue(minTime);
        DisplayHelper helper = new DisplayHelper(){

            @Override
            public boolean condition() {
                return EditorTestHelper.allJobsQuiet();
            }
        };
        boolean quiet = helper.waitForCondition(EditorTestHelper.getActiveDisplay(), maxTime > 0L ? maxTime : Long.MAX_VALUE, intervalTime);
        EditorTestHelper.runEventQueue(minTime);
        Logger.global.exiting("EditorTestHelper", "joinJobs", quiet);
        return quiet;
    }

    public static void sleep(int intervalTime) {
        try {
            Thread.sleep(intervalTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean allJobsQuiet() {
        IJobManager jobManager = Job.getJobManager();
        Job[] jobs = jobManager.find(null);
        int i = 0;
        while (i < jobs.length) {
            int state;
            Job job = jobs[i];
            if (!("Usage Data Event consumer".equals(job.getName()) || "Flush Cache Job".equals(job.getName()) || (state = job.getState()) != 4 && state != 2)) {
                Logger.global.finest(job.getName());
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isViewShown(String viewId) {
        return EditorTestHelper.getActivePage().findViewReference(viewId) != null;
    }

    public static boolean showView(String viewId, boolean show) throws PartInitException {
        boolean shown;
        IWorkbenchPage activePage = EditorTestHelper.getActivePage();
        IViewReference view = activePage.findViewReference(viewId);
        boolean bl = shown = view != null;
        if (shown != show) {
            if (show) {
                activePage.showView(viewId);
            } else {
                activePage.hideView(view);
            }
        }
        return shown;
    }

    public static void bringToTop() {
        EditorTestHelper.getActiveWorkbenchWindow().getShell().forceActive();
    }

    public static String showPerspective(String perspective) throws WorkbenchException {
        String shownPerspective = EditorTestHelper.getActivePage().getPerspective().getId();
        if (!perspective.equals(shownPerspective)) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            workbench.showPerspective(perspective, activeWindow);
        }
        return shownPerspective;
    }

    public static IFile[] findFiles(IResource resource) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        EditorTestHelper.findFiles(resource, files);
        return files.toArray(new IFile[files.size()]);
    }

    private static void findFiles(IResource resource, List<IFile> files) throws CoreException {
        if (resource instanceof IFile) {
            files.add((IFile)resource);
            return;
        }
        if (resource instanceof IContainer) {
            IResource[] resources = ((IContainer)resource).members();
            int i = 0;
            while (i < resources.length) {
                EditorTestHelper.findFiles(resources[i], files);
                ++i;
            }
        }
    }
}

