/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.jboss.tools.test.util.TestDescription;
import org.jboss.tools.test.util.XMLEntityResolver;
import org.jboss.tools.test.util.XMLUtilities;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class TestDescriptionFactory {
    IFile file = null;
    Set<TestDescription> testDescriptions = null;
    Map<String, ArrayList<TestDescription>> testDescriptionsMap = new HashMap<String, ArrayList<TestDescription>>();

    public TestDescriptionFactory(IFile file) {
        this.file = file;
    }

    public Set<TestDescription> getTestDescriptions() {
        if (this.testDescriptions != null) {
            return this.testDescriptions;
        }
        this.testDescriptions = new HashSet<TestDescription>();
        if (this.file == null || !this.file.exists()) {
            return null;
        }
        Element tests = XMLUtilities.getElement(this.file.getLocation().toFile(), (EntityResolver)XMLEntityResolver.getInstance());
        if (tests == null) {
            return null;
        }
        Element[] ts = XMLUtilities.getChildren(tests, "test");
        int i = 0;
        while (i < ts.length) {
            TestDescription t = new TestDescription(ts[i]);
            this.testDescriptions.add(t);
            ++i;
        }
        return this.testDescriptions;
    }

    public ArrayList<TestDescription> getTestDescriptions(String name) {
        this.getTestDescriptions();
        if (this.testDescriptions == null) {
            return null;
        }
        ArrayList<TestDescription> set = this.testDescriptionsMap.get(name);
        if (set == null) {
            set = new ArrayList();
            this.testDescriptionsMap.put(name, set);
            for (TestDescription t : this.testDescriptions) {
                if (!name.equals(t.getName())) continue;
                set.add(t);
            }
        }
        return set;
    }
}

