/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.jboss.tools.test.util.Debug;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.tests.ImportProvider;
import org.osgi.framework.Bundle;

public class ResourcesUtils {
    private static final long IMPORT_DELAY = 200L;

    public static IProject importProject(Bundle bundle, String templLocation, IProgressMonitor monitor) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        return ResourcesUtils.importProject(bundle, templLocation, new Path(templLocation).lastSegment(), monitor);
    }

    public static IProject importProject(Bundle bundle, String templLocation, String projectName, IProgressMonitor monitor) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        return ResourcesUtils.importProject(bundle, templLocation, projectName, monitor, false);
    }

    public static IProject importProject(Bundle bundle, String templLocation, String projectName, IProgressMonitor monitor, boolean skipWaitForIdle) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        String tplPrjLcStr = FileLocator.resolve((URL)bundle.getEntry(templLocation)).getFile();
        String protocol = FileLocator.resolve((URL)bundle.getEntry(templLocation)).getProtocol();
        IProject importedPrj = ResourcesUtils.importProjectIntoWorkspace(tplPrjLcStr, projectName, protocol, skipWaitForIdle);
        return importedPrj;
    }

    public static IProject importProject(Bundle bundle, String templLocation) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        return ResourcesUtils.importProject(bundle, templLocation, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IProject createEclipseProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IProject newProjectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectName);
        newProjectHandle.create(description, (IProgressMonitor)new NullProgressMonitor());
        newProjectHandle.open(monitor);
        return newProjectHandle;
    }

    public static IProject createEclipseProject(Bundle bundle, String templateLocation, IProgressMonitor monitor) throws CoreException, IOException {
        IPath tplPrjDescr = new Path(templateLocation).append(".project");
        IProjectDescription descr = ResourcesPlugin.getWorkspace().loadProjectDescription(tplPrjDescr);
        descr.setLocation(null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(descr.getName());
        project.create(descr, monitor);
        project.open(128, monitor);
        return project;
    }

    public static IProject createEclipseProject(String name) throws CoreException, IOException {
        String descriptionText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>{0}</name></projectDescription>";
        IProjectDescription descr = ResourcesPlugin.getWorkspace().loadProjectDescription((InputStream)new StringBufferInputStream(MessageFormat.format(descriptionText, name)));
        descr.setLocation(null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(descr.getName());
        NullProgressMonitor nullProgress = new NullProgressMonitor();
        if (!project.exists()) {
            project.create(descr, (IProgressMonitor)nullProgress);
        }
        project.open(128, (IProgressMonitor)nullProgress);
        return project;
    }

    public static IProject createEclipseProject(Bundle bundle, String templateLocation) throws CoreException, IOException {
        return ResourcesUtils.createEclipseProject(bundle, templateLocation, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IProject createEclipseProject(String bundle, String templateLocation, IProgressMonitor monitor) throws CoreException, IOException {
        return ResourcesUtils.createEclipseProject(Platform.getBundle((String)bundle), templateLocation, monitor);
    }

    public static boolean findLineInFile(IFile file, String pattern) throws CoreException, IOException {
        InputStream content = null;
        InputStreamReader isr = null;
        boolean patternIsFound = false;
        try {
            String line;
            content = file.getContents(true);
            isr = new InputStreamReader(content);
            LineNumberReader contentReader = new LineNumberReader(isr);
            do {
                if ((line = contentReader.readLine()) == null || patternIsFound) continue;
                patternIsFound = line.trim().matches(pattern);
            } while (line != null && !patternIsFound);
        }
        catch (Throwable throwable) {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (isr != null) {
            try {
                isr.close();
            }
            catch (IOException iOException) {}
        }
        if (content != null) {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
        return patternIsFound;
    }

    public static IProject importProject(String bundleName, String templatePath, IProgressMonitor monitor) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return null;
        }
        return ResourcesUtils.importProject(bundle, templatePath, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
    }

    public static IProject importProject(String bundleName, String templatePath) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            return null;
        }
        return ResourcesUtils.importProject(bundle, templatePath, null);
    }

    public static void deleteProject(String projectName) throws CoreException {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName);
        if (member != null) {
            try {
                member.getProject().delete(true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean setBuildAutomatically(boolean state) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        boolean oldAutoBuilding = description.isAutoBuilding();
        if (state != oldAutoBuilding) {
            description.setAutoBuilding(state);
            workspace.setDescription(description);
        }
        return oldAutoBuilding;
    }

    public static IProject importProjectIntoWorkspace(String path, String projectName) {
        return ResourcesUtils.importProjectIntoWorkspace(path, projectName, "file");
    }

    public static IProject importProjectIntoWorkspace(String path, String projectName, String protocol) {
        return ResourcesUtils.importProjectIntoWorkspace(path, projectName, protocol, false);
    }

    public static IProject importProjectIntoWorkspace(String path, String projectName, String protocol, boolean skipWaitForIdle) {
        IProject project = null;
        try {
            boolean state = ResourcesUtils.setBuildAutomatically(false);
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!project.exists()) {
                project.create(null);
            }
            project.open(null);
            IOverwriteQuery overwrite = new IOverwriteQuery(){

                public String queryOverwrite(String pathString) {
                    return "ALL";
                }
            };
            if (Debug.DEBUG_IMPORT_OPERATION) {
                System.out.println("[ResourceUtils]:Target Import Location: " + project.getFullPath());
                System.out.println("[ResourceUtils]:Full path to source: " + path);
                System.out.println("[ResourceUtils]:Protocol: " + protocol);
            }
            ImportOperation importOp = null;
            if ("jar".equals(protocol)) {
                String pathToZip = path.substring(0, path.indexOf("!"));
                String zipEntryName = path.substring(path.indexOf("!") + 2, path.length());
                pathToZip = pathToZip.substring("file:".length());
                if (Debug.DEBUG_IMPORT_OPERATION) {
                    System.out.println("[ResourceUtils]:pathToZip: " + pathToZip);
                    System.out.println("[ResourceUtils]:zipEntryName: " + zipEntryName);
                }
                ZipFile zipFile = new ZipFile(pathToZip);
                ZipFileStructureProvider zipStrProvider = new ZipFileStructureProvider(zipFile);
                ZipEntry source = ResourcesUtils.getZipEntry(zipStrProvider, zipEntryName);
                importOp = new ImportOperation(project.getFullPath(), (Object)source, (IImportStructureProvider)zipStrProvider, overwrite);
                importOp.setFilesToImport(zipStrProvider.getChildren((Object)source));
            } else {
                ImportProvider importProvider = new ImportProvider();
                ArrayList<String> unimportedFiles = new ArrayList<String>();
                unimportedFiles.add(".svn");
                importProvider.setUnimportedFiles(unimportedFiles);
                importOp = new ImportOperation(project.getFullPath(), (Object)new File(path), (IImportStructureProvider)importProvider, overwrite);
            }
            importOp.setCreateContainerStructure(false);
            importOp.run(null);
            project.build(10, null);
            ResourcesUtils.setBuildAutomatically(state);
            if (!skipWaitForIdle) {
                JobUtils.waitForIdle(200L);
            }
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return project;
    }

    private static ZipEntry getZipEntry(ZipFileStructureProvider zipStrProvider, String zipEntryName) {
        String[] entries = zipEntryName.split("/");
        ZipEntry parent = zipStrProvider.getRoot();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            List children = zipStrProvider.getChildren((Object)parent);
            for (Object object : children) {
                String name;
                ZipEntry current = (ZipEntry)object;
                String string2 = name = parent == zipStrProvider.getRoot() ? String.valueOf(string) + "/" : String.valueOf(parent.getName()) + string + "/";
                if (!name.equals(current.getName())) continue;
                parent = current;
                break;
            }
            ++n2;
        }
        return parent;
    }

    public static IProject importProject(String bundleName, String projectPath, String name, Object object) throws IOException, CoreException, InvocationTargetException, InterruptedException {
        return ResourcesUtils.importProject(Platform.getBundle((String)bundleName), projectPath, name, null);
    }
}

