/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.seam.configurators;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetInstallDataModelProvider;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.project.registry.MavenProjectManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.maven.core.MavenUtil;
import org.jboss.tools.maven.core.internal.project.facet.MavenFacetInstallDataModelProvider;
import org.jboss.tools.maven.seam.MavenSeamActivator;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;
import org.osgi.service.prefs.BackingStoreException;

public class SeamProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String JBOSS_SEAM_ARTIFACT_PREFIX = "jboss-seam";
    private static final String ORG_JBOSS_SEAM_GROUP_ID = "org.jboss.seam";
    private static final String JBOSS_SEAM_ARTIFACT_ID = "jboss-seam";
    protected static final IProjectFacet dynamicWebFacet;
    protected static final IProjectFacet javaFacet;
    protected static final IProjectFacet jsfFacet;
    protected static final IProjectFacet earFacet;
    protected static final IProjectFacet ejbFacet;
    protected static final IProjectFacet m2Facet;
    protected static final IProjectFacetVersion m2Version;
    private static final IProjectFacet seamFacet;
    private static final IProjectFacet portletFacet;
    private static final IProjectFacet jsfportletFacet;
    private static final IProjectFacet seamPortletFacet;
    private static final IProjectFacetVersion seamPortletVersion;

    static {
        seamFacet = ProjectFacetsManager.getProjectFacet((String)"jst.seam");
        javaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.java");
        dynamicWebFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        m2Facet = ProjectFacetsManager.getProjectFacet((String)"jboss.m2");
        m2Version = m2Facet.getVersion("1.0");
        ejbFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        if (ProjectFacetsManager.isProjectFacetDefined((String)"jboss.portlet")) {
            portletFacet = ProjectFacetsManager.getProjectFacet((String)"jboss.portlet");
            jsfportletFacet = ProjectFacetsManager.getProjectFacet((String)"jboss.jsfportlet");
            seamPortletFacet = ProjectFacetsManager.getProjectFacet((String)"jboss.seamportlet");
            seamPortletVersion = seamPortletFacet.getVersion("1.0");
        } else {
            portletFacet = null;
            jsfportletFacet = null;
            seamPortletFacet = null;
            seamPortletVersion = null;
        }
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    private boolean isSeamSettingChangedByUser(IProject project) {
        IEclipsePreferences projectPreferences = SeamCorePlugin.getSeamPreferences((IProject)project);
        boolean seamSettingsChangedByUser = projectPreferences.getBoolean("seam.settings.changed.by.user", false);
        return seamSettingsChangedByUser;
    }

    private boolean isSeamConfigurable(MavenProject mavenProject) {
        boolean configureCDI;
        String cdiActivation = mavenProject.getProperties().getProperty("m2e.seam.activation");
        if (cdiActivation == null) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            configureCDI = store.getBoolean("configureSeam");
        } else {
            configureCDI = Boolean.valueOf(cdiActivation);
        }
        return configureCDI;
    }

    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.isSeamConfigurable(mavenProject)) {
            return;
        }
        if (this.isSeamSettingChangedByUser(project)) {
            return;
        }
        IProject rootSeamProject = SeamWizardUtils.getRootSeamProject((IProject)project);
        if (rootSeamProject != null && this.isSeamSettingChangedByUser(rootSeamProject)) {
            return;
        }
        this.clearMarkers(project);
        String packaging = mavenProject.getPackaging();
        String seamVersion = this.getSeamVersion(mavenProject);
        if (seamVersion != null) {
            IFacetedProject fproj;
            IProject[] earProjects = EarUtilities.getReferencingEARProjects((IProject)project);
            String deploying = packaging;
            if (earProjects.length > 0) {
                deploying = "ear";
            }
            if ((fproj = ProjectFacetsManager.create((IProject)project)) == null) {
                return;
            }
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            IProjectFacetVersion seamFacetVersion = this.getSeamFacetVersion(seamVersion);
            if ("war".equals(packaging)) {
                IDataModel model = this.createSeamDataModel(deploying, seamVersion, project);
                if (!fproj.hasProjectFacet(jsfFacet)) {
                    MavenUtil.refreshParent((MavenProject)mavenProject);
                }
                this.installWarFacets(fproj, model, seamFacetVersion, monitor);
            } else if ("ear".equals(packaging)) {
                this.installEarFacets(fproj, seamFacetVersion, monitor);
                this.installM2Facet(fproj, monitor);
                IProject webProject = this.getReferencingSeamWebProject(project);
                if (webProject != null) {
                    IProject ejbProject;
                    IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)webProject);
                    String deployingType = prefs.get("seam.project.deployment.type", null);
                    if (deployingType == null || deployingType.equals("war")) {
                        prefs.put("seam.project.deployment.type", "ear");
                        this.storeSettings(webProject);
                    }
                    if ((ejbProject = this.getReferencingSeamEJBProject(project)) != null) {
                        prefs.put("seam.ejb.project", ejbProject.getName());
                        IJavaProject javaProject = JavaCore.create((IProject)ejbProject);
                        boolean configureSeamArtifacts = store.getBoolean("configureSeamArtifacts");
                        if (configureSeamArtifacts) {
                            int i;
                            if (javaProject != null && javaProject.isOpen()) {
                                try {
                                    IClasspathEntry[] entries = javaProject.getRawClasspath();
                                    i = 0;
                                    while (i < entries.length) {
                                        IClasspathEntry entry = entries[i];
                                        if (entry.getEntryKind() == 3) {
                                            String sourceFolder = entry.getPath().toString();
                                            prefs.put("action.sources", sourceFolder);
                                            prefs.put("model.sources", sourceFolder);
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                catch (JavaModelException e) {
                                    MavenSeamActivator.log(e);
                                }
                            }
                            IPackageFragment[] packageFragments = javaProject.getPackageFragments();
                            i = 0;
                            while (i < packageFragments.length) {
                                IPackageFragment pf = packageFragments[i];
                                if (!(pf == null || pf.getKind() != 1 || pf.isDefaultPackage() || pf.hasSubpackages() && !pf.hasChildren())) {
                                    String packageName = pf.getElementName();
                                    prefs.put("action.package", packageName);
                                    prefs.put("model.package", packageName);
                                }
                                ++i;
                            }
                        }
                    }
                    this.storeSettings(webProject);
                }
            } else if ("ejb".equals(packaging)) {
                this.installM2Facet(fproj, monitor);
                this.installEjbFacets(fproj, seamFacetVersion, monitor);
                this.addSeamSupport(project, earProjects);
                this.storeSettings(project);
            }
        }
    }

    private String getViewFolder(IProject project) {
        IVirtualFolder webRootFolder;
        IVirtualComponent com = ComponentCore.createComponent((IProject)project);
        String viewFolder = null;
        if (com != null && (webRootFolder = com.getRootFolder().getFolder((IPath)new Path("/"))) != null) {
            viewFolder = webRootFolder.getUnderlyingFolder().getFullPath().toString();
        }
        return viewFolder;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IProject project;
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade != null && this.isWTPProject(project = facade.getProject())) {
            MavenProject mavenProject = facade.getMavenProject(monitor);
            this.configureInternal(mavenProject, project, monitor);
        }
        super.mavenProjectChanged(event, monitor);
    }

    private boolean isWTPProject(IProject project) {
        return ModuleCoreNature.getModuleCoreNature((IProject)project) != null;
    }

    private void installM2Facet(IFacetedProject fproj, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(m2Facet)) {
            IDataModel config = (IDataModel)new MavenFacetInstallDataModelProvider().create();
            config.setBooleanProperty("mavenProjectExists", true);
            fproj.installProjectFacet(m2Version, (Object)config, monitor);
        }
    }

    private IProjectFacetVersion getSeamFacetVersion(String seamVersion) throws CoreException {
        String version = seamVersion.substring(0, 3);
        IProjectFacetVersion facetVersion = null;
        try {
            facetVersion = seamFacet.getVersion(version);
        }
        catch (Exception e) {
            MavenSeamActivator.log(e, "Seam version " + version + " is not supported, using latest supported facet version instead");
            facetVersion = seamFacet.getLatestVersion();
        }
        return facetVersion;
    }

    private void installEarFacets(IFacetedProject fproj, IProjectFacetVersion seamFv, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(earFacet)) {
            IProjectFacetVersion earVersion = this.findTargetFacetVersion(seamFv, earFacet);
            fproj.installProjectFacet(earVersion, null, monitor);
        }
    }

    private void installEjbFacets(IFacetedProject fproj, IProjectFacetVersion seamFv, IProgressMonitor monitor) throws CoreException {
        if (!fproj.hasProjectFacet(javaFacet)) {
            IProjectFacetVersion javaVersion = this.findTargetFacetVersion(seamFv, javaFacet);
            fproj.installProjectFacet(javaVersion, null, monitor);
        }
        if (!fproj.hasProjectFacet(ejbFacet)) {
            IProjectFacetVersion ejbVersion = this.findTargetFacetVersion(seamFv, ejbFacet);
            fproj.installProjectFacet(ejbVersion, null, monitor);
        }
    }

    private void installWarFacets(IFacetedProject fproj, IDataModel model, IProjectFacetVersion seamFacetVersion, IProgressMonitor monitor) throws CoreException {
        boolean hasConflicts = false;
        for (IProjectFacetVersion fv : fproj.getProjectFacets()) {
            if (!seamFacetVersion.conflictsWith(fv)) continue;
            this.addErrorMarker(fproj.getProject(), seamFacetVersion + " can not be installed as it conflicts with " + fv);
            hasConflicts = true;
        }
        if (hasConflicts) {
            return;
        }
        if (!fproj.hasProjectFacet(javaFacet)) {
            IProjectFacetVersion javaVersion = this.findTargetFacetVersion(seamFacetVersion, javaFacet);
            fproj.installProjectFacet(javaVersion, null, monitor);
        }
        if (!fproj.hasProjectFacet(dynamicWebFacet)) {
            IProjectFacetVersion dynamicWebVersion = this.findTargetFacetVersion(seamFacetVersion, dynamicWebFacet);
            fproj.installProjectFacet(dynamicWebVersion, null, monitor);
        }
        IProjectFacetVersion jsfVersion = this.findTargetFacetVersion(seamFacetVersion, jsfFacet);
        this.installJSFFacet(fproj, jsfVersion, monitor);
        this.installM2Facet(fproj, monitor);
        if (!fproj.hasProjectFacet(seamFacet)) {
            fproj.installProjectFacet(seamFacetVersion, (Object)model, monitor);
        } else {
            String deploying = model.getStringProperty("seam.project.deployment.type");
            if (deploying != null && deploying.equals("war")) {
                IPreferenceStore store = MavenSeamActivator.getDefault().getPreferenceStore();
                boolean configureSeamArtifacts = store.getBoolean("configureSeamArtifacts");
                if (!configureSeamArtifacts) {
                    return;
                }
                IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)fproj.getProject());
                this.setModelProperty(model, prefs, "action.sources");
                this.setModelProperty(model, prefs, "model.sources");
                this.setModelProperty(model, prefs, "action.package");
                this.setModelProperty(model, prefs, "model.package");
                this.setModelProperty(model, prefs, "seam.project.web.root.folder");
            }
        }
        if (portletFacet == null) {
            return;
        }
        IPreferenceStore store = MavenSeamActivator.getDefault().getPreferenceStore();
        boolean configureSeamPortlet = store.getBoolean("configureSeamPortlet");
        if (!configureSeamPortlet) {
            return;
        }
        if (fproj.hasProjectFacet(seamFacet) && fproj.hasProjectFacet(portletFacet) && fproj.hasProjectFacet(jsfportletFacet) && !fproj.hasProjectFacet(seamPortletFacet)) {
            fproj.installProjectFacet(seamPortletVersion, null, monitor);
        }
    }

    private void clearMarkers(IProject project) throws CoreException {
        this.markerManager.deleteMarkers((IResource)project, "org.jbosstools.maven.configuration.seam");
    }

    private IProjectFacetVersion findTargetFacetVersion(IProjectFacetVersion seamFv, IProjectFacet targetFacet) throws CoreException {
        if (seamFv != null) {
            for (IProjectFacetVersion jsfFv : targetFacet.getSortedVersions(true)) {
                if (seamFv.conflictsWith(jsfFv)) continue;
                return jsfFv;
            }
        }
        return null;
    }

    private void setModelProperty(IDataModel model, IEclipsePreferences prefs, String property) {
        String value = model.getStringProperty(property);
        if (value != null && value.trim().length() > 0) {
            prefs.put(property, value);
        }
    }

    private void installJSFFacet(IFacetedProject fproj, IProjectFacetVersion jsfVersion, IProgressMonitor monitor) throws CoreException {
        if (jsfFacet != null && !fproj.hasProjectFacet(jsfFacet)) {
            IDataModel model = this.createJSFDataModel(fproj, jsfVersion);
            model.setBooleanProperty("IJSFFacetInstallDataModelProperties.CONFIGURE_SERVLET", false);
            fproj.installProjectFacet(jsfVersion, (Object)model, monitor);
        }
    }

    private void storeSettings(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences prefs = projectScope.getNode("org.jboss.tools.seam.core");
        String version = prefs.get("seam.project.settings.version", null);
        if (version == null) {
            prefs.put("seam.project.settings.version", "1.1");
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            MavenSeamActivator.log(e);
        }
    }

    private void addSeamSupport(IProject project, IProject[] earProjects) {
        if (project == null) {
            return;
        }
        try {
            SeamUtil.enableSeamSupport((IProject)project);
            int i = 0;
            while (i < earProjects.length) {
                IProject earProject;
                IProject webProject;
                IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)project);
                String seamParentProject = prefs.get("seam.parent.project", null);
                if (seamParentProject == null && (webProject = this.getReferencingSeamWebProject(earProject = earProjects[i])) != null) {
                    prefs.put("seam.parent.project", webProject.getName());
                    break;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MavenSeamActivator.log(e);
        }
    }

    private IProject getReferencingSeamWebProject(IProject earProject) throws CoreException {
        Criteria criteria = new Criteria(){

            @Override
            public boolean applies(IProject project) {
                return project != null && JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
            }
        };
        return this.getReferencingSeamProject(earProject, criteria);
    }

    private IProject getReferencingSeamEJBProject(IProject earProject) throws CoreException {
        Criteria criteria = new Criteria(){

            @Override
            public boolean applies(IProject project) {
                return project != null && JavaEEProjectUtilities.isEJBProject((IProject)project);
            }
        };
        return this.getReferencingSeamProject(earProject, criteria);
    }

    private IProject getReferencingSeamProject(IProject earProject, Criteria criteria) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
        if (component != null) {
            IVirtualReference[] references = component.getReferences();
            int i = 0;
            while (i < references.length) {
                String version;
                MavenProject mavenProject;
                MavenProjectManager projectManager;
                IMavenProjectFacade facade;
                IFile pom;
                IVirtualComponent refComponent = references[i].getReferencedComponent();
                IProject refProject = refComponent.getProject();
                if (criteria.applies(refProject) && refProject.hasNature("org.eclipse.m2e.core.maven2Nature") && (pom = refProject.getFile("pom.xml")).exists() && (facade = (projectManager = MavenPluginActivator.getDefault().getMavenProjectManager()).create(pom, true, null)) != null && (mavenProject = facade.getMavenProject(null)) != null && (version = this.getSeamVersion(mavenProject)) != null) {
                    return refProject;
                }
                ++i;
            }
        }
        return null;
    }

    private String getSeamVersion(MavenProject mavenProject) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        ScopeArtifactFilter filter = new ScopeArtifactFilter("test");
        for (Artifact artifact : mavenProject.getArtifacts()) {
            if (!filter.include(artifact) || !artifact.isResolved()) continue;
            artifacts.add(artifact);
        }
        Artifact seamArtifact = null;
        for (Artifact artifact : artifacts) {
            String groupId = artifact.getGroupId();
            if (!ORG_JBOSS_SEAM_GROUP_ID.equals(groupId)) continue;
            String artifactId = artifact.getArtifactId();
            if (artifactId != null && "jboss-seam".equals(artifactId)) {
                return artifact.getVersion();
            }
            if (artifactId == null || !artifactId.startsWith("jboss-seam")) continue;
            seamArtifact = artifact;
        }
        if (seamArtifact != null) {
            return seamArtifact.getVersion();
        }
        return null;
    }

    private IDataModel createSeamDataModel(String deployType, String seamVersion, IProject project) {
        IDataModel config = (IDataModel)new SeamFacetInstallDataModelProvider().create();
        String seamRuntimeName = this.getSeamRuntimeName(seamVersion);
        if (seamRuntimeName != null) {
            config.setStringProperty("seam.runtime.name", seamRuntimeName);
        }
        config.setBooleanProperty("database.exists", true);
        config.setBooleanProperty("database.drop", false);
        config.setStringProperty("seam.project.deployment.type", deployType);
        config.setBooleanProperty("configure.default.seam.runtime", false);
        config.setBooleanProperty("configure.war.project", false);
        config.setBooleanProperty("seam.project.already.exists", true);
        IPreferenceStore store = MavenSeamActivator.getDefault().getPreferenceStore();
        boolean configureSeamArtifacts = store.getBoolean("configureSeamArtifacts");
        if (!configureSeamArtifacts) {
            return config;
        }
        String viewFolder = this.getViewFolder(project);
        if (viewFolder != null) {
            config.setStringProperty("seam.project.web.root.folder", viewFolder);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IPath> sourcePaths = new ArrayList<IPath>();
        if (javaProject != null && javaProject.isOpen()) {
            try {
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 3) {
                        sourcePaths.add(entry.getPath());
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                MavenSeamActivator.log(e);
            }
            if (sourcePaths.size() > 0) {
                IPath actionSourceFolder = null;
                IPath modelSourceFolder = null;
                for (IPath sourcePath : sourcePaths) {
                    if (sourcePath.toString().contains("hot")) {
                        actionSourceFolder = sourcePath;
                        continue;
                    }
                    modelSourceFolder = sourcePath;
                }
                if (actionSourceFolder == null) {
                    actionSourceFolder = modelSourceFolder;
                }
                if (modelSourceFolder == null) {
                    modelSourceFolder = actionSourceFolder;
                }
                String modelSourceFolderStr = modelSourceFolder.toString();
                config.setStringProperty("model.sources", modelSourceFolderStr);
                String actionSourceFolderStr = actionSourceFolder.toString();
                config.setStringProperty("action.sources", actionSourceFolderStr);
            }
            try {
                IPackageFragment[] packageFragments = javaProject.getPackageFragments();
                int i = 0;
                while (i < packageFragments.length) {
                    IPackageFragment pf = packageFragments[i];
                    if (pf != null && pf.getKind() == 1 && !pf.isDefaultPackage()) {
                        String packageName = pf.getElementName();
                        config.setStringProperty("action.package", packageName);
                        config.setStringProperty("model.package", packageName);
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                MavenSeamActivator.log(e);
            }
        }
        return config;
    }

    private String getSeamRuntimeName(String seamVersionStr) {
        if (seamVersionStr == null) {
            return null;
        }
        IPreferenceStore store = MavenSeamActivator.getDefault().getPreferenceStore();
        boolean configureSeamRuntime = store.getBoolean("configureSeamRuntime");
        if (!configureSeamRuntime) {
            return null;
        }
        String seamRuntime5 = null;
        String seamRuntime3 = null;
        SeamRuntime[] seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
        int i = 0;
        while (i < seamRuntimes.length) {
            String fullVersion;
            SeamRuntime seamRuntime = seamRuntimes[i];
            String seamHomeDir = seamRuntime.getHomeDir();
            if (seamHomeDir != null && new File(seamHomeDir).exists() && (fullVersion = SeamUtil.getSeamVersionFromManifest((String)seamRuntime.getHomeDir())) != null) {
                if (fullVersion == seamVersionStr) {
                    return seamRuntime.getName();
                }
                if (seamRuntime5 == null) {
                    String fullVersion5 = fullVersion.substring(0, 5);
                    String seamVersion5 = seamVersionStr.substring(0, 5);
                    if (seamVersion5.equals(fullVersion5)) {
                        seamRuntime5 = seamRuntime.getName();
                    }
                }
                if (seamRuntime5 == null && seamRuntime3 == null) {
                    String fullVersion3 = fullVersion.substring(0, 3);
                    String seamVersion3 = seamVersionStr.substring(0, 3);
                    if (seamVersion3.equals(fullVersion3)) {
                        seamRuntime3 = seamRuntime.getName();
                    }
                }
            }
            ++i;
        }
        if (seamRuntime5 != null) {
            return seamRuntime5;
        }
        SeamVersion seamVersion = SeamVersion.parseFromString((String)seamVersionStr.substring(0, 3));
        SeamRuntime defaultRuntime = SeamRuntimeManager.getInstance().getDefaultRuntime(seamVersion);
        if (defaultRuntime != null) {
            return defaultRuntime.getName();
        }
        return seamRuntime3;
    }

    private void addErrorMarker(IProject project, String message) {
        this.markerManager.addMarker((IResource)project, "org.jbosstools.maven.configuration.seam", message, -1, 2);
    }

    private IDataModel createJSFDataModel(IFacetedProject fproj, IProjectFacetVersion facetVersion) {
        IDataModel config = (IDataModel)new JSFFacetInstallDataModelProvider().create();
        LibraryInstallDelegate libraryDelegate = new LibraryInstallDelegate((IFacetedProjectBase)fproj, facetVersion);
        ILibraryProvider provider = LibraryProviderFramework.getProvider((String)"jsf-no-op-library-provider");
        libraryDelegate.setLibraryProvider(provider);
        config.setProperty("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE", (Object)libraryDelegate);
        config.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME", (Object)"");
        config.setProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS", (Object)new String[0]);
        return config;
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean configureSeam = store.getBoolean("configureSeam");
        if (!configureSeam) {
            return false;
        }
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)newFacade.getProject());
            if (fproj == null || !fproj.hasProjectFacet(seamFacet)) {
                return false;
            }
        }
        catch (CoreException e) {
            MavenSeamActivator.log(e);
        }
        return super.hasConfigurationChanged(newFacade, oldProjectConfiguration, key, monitor);
    }

    private static interface Criteria {
        public boolean applies(IProject var1);
    }
}

