/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.seam;

import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.Parent;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.jboss.tools.maven.core.xpl.ProjectUpdater;

public class ParentAdder
extends ProjectUpdater {
    private static final PomFactory POM_FACTORY = PomFactory.eINSTANCE;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private String relativePath;

    public ParentAdder(String groupId, String artifactId, String version, String relativePath) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.relativePath = relativePath;
    }

    public void update(Model model) {
        Parent parent = model.getParent();
        if (parent == null) {
            parent = POM_FACTORY.createParent();
            parent.setArtifactId(this.artifactId);
            parent.setGroupId(this.groupId);
            parent.setVersion(this.version);
            if (this.relativePath != null) {
                parent.setRelativePath(this.relativePath);
            }
            model.setParent(parent);
        }
        if (this.groupId != null && this.groupId.equals(model.getGroupId())) {
            model.setGroupId(null);
        }
        if (this.version != null && this.version.equals(model.getVersion())) {
            model.setVersion(null);
        }
    }
}

