/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Dictionary;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.management.event.CamelContextStoppingEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;

public class OsgiCamelContextPublisher
extends EventNotifierSupport {
    public static final String CONTEXT_SYMBOLIC_NAME_PROPERTY = "camel.context.symbolicname";
    public static final String CONTEXT_VERSION_PROPERTY = "camel.context.version";
    public static final String CONTEXT_NAME_PROPERTY = "camel.context.name";
    private final BundleContext bundleContext;
    private final Map<CamelContext, ServiceRegistration> registrations = new ConcurrentHashMap<CamelContext, ServiceRegistration>();

    public OsgiCamelContextPublisher(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void notify(EventObject event) throws Exception {
        CamelContext context;
        ServiceRegistration reg;
        if (event instanceof CamelContextStartedEvent) {
            CamelContext context2 = ((CamelContextStartedEvent)event).getContext();
            this.registerCamelContext(context2);
        } else if (event instanceof CamelContextStoppingEvent && (reg = this.registrations.remove(context = ((CamelContextStoppingEvent)event).getContext())) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistering CamelContext [{}] from OSGi registry", (Object)context.getName());
            }
            try {
                reg.unregister();
            }
            catch (Exception e) {
                this.log.warn("Error unregistering CamelContext [{}] from OSGi registry. This exception will be ignored.", (Object)context.getName(), (Object)e);
            }
        }
    }

    public boolean isEnabled(EventObject event) {
        return event instanceof CamelContextStartedEvent || event instanceof CamelContextStoppingEvent;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        this.registrations.clear();
    }

    public ServiceRegistration registerCamelContext(CamelContext camelContext) throws InvalidSyntaxException {
        String symbolicName = this.bundleContext.getBundle().getSymbolicName();
        Version bundleVersion = OsgiCamelContextPublisher.getBundleVersion(this.bundleContext.getBundle());
        ServiceReference[] refs = this.bundleContext.getServiceReferences(CamelContext.class.getName(), "(&(camel.context.symbolicname=" + symbolicName + ")(" + CONTEXT_VERSION_PROPERTY + "=" + bundleVersion + "))");
        if (refs == null) {
            ServiceRegistration reg;
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(CONTEXT_SYMBOLIC_NAME_PROPERTY, symbolicName);
            ((Dictionary)props).put(CONTEXT_VERSION_PROPERTY, (String)bundleVersion);
            ((Dictionary)props).put(CONTEXT_NAME_PROPERTY, camelContext.getName());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering CamelContext [{}] of in OSGi registry", (Object)camelContext.getName());
            }
            if ((reg = this.bundleContext.registerService(CamelContext.class.getName(), (Object)camelContext, props)) != null) {
                this.registrations.put(camelContext, reg);
            }
            return reg;
        }
        return null;
    }

    public static Version getBundleVersion(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
    }
}

