/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.util;

import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

public class VMInstallUtil {
    public static IVMInstall findVMInstall(String type, String id) {
        if (type != null && id != null) {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)type);
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int i = 0;
            while (i < vmInstalls.length) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static IVMInstall findVMInstall(IExecutionEnvironment environment) {
        if (environment != null) {
            IVMInstall[] installs = environment.getCompatibleVMs();
            if (environment.getDefaultVM() != null) {
                return environment.getDefaultVM();
            }
            int i = 0;
            while (i < installs.length) {
                IVMInstall install = installs[i];
                if (environment.isStrictlyCompatible(install)) {
                    return install;
                }
                ++i;
            }
            IVMInstall workspaceDefault = JavaRuntime.getDefaultVMInstall();
            if (installs != null && workspaceDefault != null) {
                int i2 = 0;
                while (i2 < installs.length) {
                    if (workspaceDefault.equals(installs[i2])) {
                        return workspaceDefault;
                    }
                    ++i2;
                }
            }
            if (installs != null && installs.length > 0 && installs[0] != null) {
                return installs[0];
            }
        }
        IVMInstall i = environment == null ? null : environment.getDefaultVM();
        return i == null ? JavaRuntime.getDefaultVMInstall() : i;
    }
}

