/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.HasName;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.providers.DefaultConnectionProvider;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IJvmFacade;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.ui.JvmMonitorPreferences;
import org.jboss.tools.jmx.local.internal.Activator;
import org.jboss.tools.jmx.local.internal.ProcessInformationStore;
import org.jboss.tools.jmx.ui.ImageProvider;

public class JvmConnectionWrapper
implements IConnectionWrapper,
HasName,
ImageProvider,
IAdaptable,
IJvmFacade {
    private static final String MAVEN_PREFIX = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final String ECLIPSE_MAVEN_PROCESS_PREFIX = "-DECLIPSE_PROCESS_NAME='";
    private static final String ECLIPSE_MAVEN_PROCESS_POSTFIX = "'";
    private static final String KARAF_HOME_PREFIX = " -Dkaraf.home=";
    private static final String KARAF_HOME_POSTFIX = " ";
    protected static final Map<String, String> vmAliasMap = new HashMap<String, String>();
    protected static final Map<String, String> karafSubTypeMap = new HashMap<String, String>();
    private IActiveJvm activeJvm;
    private String name;
    private Root root;
    private Image image;
    private List<Runnable> afterLoadRunnables = new ArrayList<Runnable>();
    private IProgressMonitor progressMonitor;
    private JvmConnectionWrapperLabelProvider[] jvmConnectionLabelProviders = new JvmConnectionWrapperLabelProvider[]{new CamelContextLabelProvider(), new MavenLabelProvider(), new KarafLabelProvider(), new JavaProcessLabelProvider()};

    static {
        vmAliasMap.put("com.intellij.rt.execution.application.AppMain", "idea");
        vmAliasMap.put("org.apache.karaf.main.Main", "karaf");
        vmAliasMap.put("org.eclipse.equinox.launcher.Main", "equinox");
        vmAliasMap.put("org.jetbrains.idea.maven.server.RemoteMavenServer", "idea maven server");
        vmAliasMap.put("idea maven server", "");
        vmAliasMap.put("scala.tools.nsc.MainGenericRunner", "scala repl");
        karafSubTypeMap.put("default", "Apache Karaf");
        karafSubTypeMap.put("esb-version.jar", "JBoss Fuse");
        karafSubTypeMap.put("fabric-version.jar", "Fabric8");
        karafSubTypeMap.put("mq-version.jar", "JBoss A-MQ");
        karafSubTypeMap.put("servicemix-version.jar", "Apache ServiceMix");
    }

    public JvmConnectionWrapper(IActiveJvm vm) {
        this.activeJvm = vm;
        this.progressMonitor = null;
    }

    public String toString() {
        return this.getName();
    }

    public IActiveJvm getActiveJvm() {
        return this.activeJvm;
    }

    public void setActiveJvm(IActiveJvm activeJvm) {
        if (this.activeJvm != activeJvm) {
            IActiveJvm oldJvm = this.activeJvm;
            this.activeJvm = activeJvm;
            if (oldJvm != null) {
                try {
                    oldJvm.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public Object getAdapter(Class adapter) {
        ITabbedPropertySheetPageContributor contributor = new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.jboss.tools.jmx.jvmmonitor.ui.JvmExplorer";
            }
        };
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage(contributor);
        }
        if (adapter == ITabbedPropertySheetPageContributor.class) {
            return contributor;
        }
        return null;
    }

    protected void addOnLoadRunnable(Runnable runnable) {
        this.afterLoadRunnables.add(runnable);
    }

    public MBeanServerConnection getConnection() {
        return this.activeJvm.getMBeanServer().getConnection();
    }

    public synchronized void connect() throws IOException {
        if (!this.activeJvm.isConnected() && this.activeJvm.isConnectionSupported()) {
            int updatePeriod = JvmMonitorPreferences.getJvmUpdatePeriod();
            try {
                this.activeJvm.connect(updatePeriod);
            }
            catch (JvmCoreException e) {
                e.printStackTrace();
            }
            this.fireConnectionChanged();
        }
    }

    public synchronized void disconnect() throws IOException {
        this.root = null;
        this.activeJvm.disconnect();
        this.fireConnectionChanged();
    }

    public boolean isConnected() {
        return this.activeJvm.isConnected();
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadRoot() {
        if (this.isConnected() && this.root == null) {
            try {
                if (this.progressMonitor == null) {
                    this.progressMonitor = new NullProgressMonitor();
                }
                this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this, (IProgressMonitor)this.progressMonitor);
                for (Runnable task : this.afterLoadRunnables) {
                    task.run();
                }
                this.afterLoadRunnables.clear();
            }
            catch (Throwable e) {
                Activator.pluginLog().logWarning("Failed to load JMX tree for " + this + ". " + e, e);
            }
            this.progressMonitor = null;
        }
    }

    public void run(IJMXRunnable runnable) throws JMXException {
        try {
            runnable.run(this.getConnection());
        }
        catch (Exception ce) {
            Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRunningJMXCode, (Throwable)ce);
            throw new JMXException((IStatus)s);
        }
    }

    public boolean canControl() {
        return true;
    }

    protected void fireConnectionChanged() {
        DefaultConnectionProvider provider = (DefaultConnectionProvider)this.getProvider();
        provider.fireChanged((IConnectionWrapper)this);
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.jboss.tools.jmx.core.providers.DefaultConnectionProvider");
    }

    private static boolean isKaraf(IActiveJvm jvm) {
        String displayName = jvm.getMainClass();
        return JvmConnectionWrapper.equal("org.apache.karaf.main.Main", displayName);
    }

    private static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    private static boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    private JvmConnectionWrapperLabelProvider findProvider(IActiveJvm jvm) {
        int i = 0;
        while (i < this.jvmConnectionLabelProviders.length) {
            if (this.jvmConnectionLabelProviders[i].accepts(jvm)) {
                return this.jvmConnectionLabelProviders[i];
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        if (this.name == null) {
            String displayName;
            JvmConnectionWrapperLabelProvider provider = this.findProvider(this.activeJvm);
            if (provider != null) {
                displayName = provider.getDisplayString(this.activeJvm);
            } else {
                displayName = this.activeJvm.getMainClass();
                displayName = JvmConnectionWrapper.getNameFromAliasMap(displayName);
            }
            this.name = displayName = String.valueOf(displayName) + " [" + this.activeJvm.getPid() + "]";
        }
        return this.name;
    }

    private static String getKarafHomeFolder(IActiveJvm jvm) {
        int end;
        int start;
        String pInfo;
        String karafHomeFolder = null;
        if (!jvm.isRemote() && (pInfo = ProcessInformationStore.getDefault().queryProcessInformation(jvm.getPid())) != null && (start = pInfo.indexOf(KARAF_HOME_PREFIX)) != -1 && (end = pInfo.indexOf(KARAF_HOME_POSTFIX, start + KARAF_HOME_PREFIX.length() + 1)) != -1) {
            karafHomeFolder = pInfo.substring(start + KARAF_HOME_PREFIX.length(), end);
        }
        return karafHomeFolder;
    }

    private static String getKarafSubtype(String karafHomeFolder) {
        File[] jars;
        File libFolder;
        String karafSubType = null;
        if (karafHomeFolder != null && (libFolder = new File(String.format("%s%slib%s", karafHomeFolder, File.separator, File.separator))).exists() && libFolder.isDirectory() && (jars = libFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().toLowerCase().endsWith("-version.jar");
            }
        })) != null && jars.length == 1) {
            File f = jars[0];
            karafSubType = karafSubTypeMap.containsKey(f.getName()) ? karafSubTypeMap.get(f.getName()) : karafSubTypeMap.get("default");
        }
        return karafSubType;
    }

    private static String getNameFromAliasMap(String displayName) {
        Set<Map.Entry<String, String>> entrySet = vmAliasMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            if (!displayName.startsWith(key)) continue;
            return String.valueOf(entry.getValue()) + displayName.substring(key.length());
        }
        return displayName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Image getImage() {
        if (this.image == null) {
            Image ret = null;
            JvmConnectionWrapperLabelProvider provider = this.findProvider(this.activeJvm);
            if (provider != null) {
                ret = provider.getImage(this.activeJvm);
            }
            if (ret == null) {
                ret = Activator.getDefault().getSharedImages().image("image/container.gif");
            }
            this.image = ret;
        }
        return this.image;
    }

    public Properties getAgentProperties() {
        return new Properties();
    }

    public Map<String, String> getSystemProperties() {
        return System.getenv();
    }

    public void loadRoot(IProgressMonitor monitor) throws CoreException {
        this.progressMonitor = monitor;
        this.loadRoot();
    }

    public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
    }

    private static class CamelContextLabelProvider
    extends JvmConnectionWrapperLabelProvider {
        private CamelContextLabelProvider() {
        }

        @Override
        public boolean accepts(IActiveJvm jvm) {
            return jvm.getMainClass().endsWith("org.apache.camel:camel-maven-plugin:run");
        }

        @Override
        public Image getImage(IActiveJvm jvm) {
            return Activator.getDefault().getSharedImages().image("image/camel.png");
        }

        @Override
        public String getDisplayString(IActiveJvm jvm) {
            return "Local Camel Context";
        }
    }

    private static class JavaProcessLabelProvider
    extends JvmConnectionWrapperLabelProvider {
        private JavaProcessLabelProvider() {
        }

        @Override
        public boolean accepts(IActiveJvm jvm) {
            return true;
        }

        @Override
        public Image getImage(IActiveJvm jvm) {
            return Activator.getDefault().getSharedImages().image("image/container.gif");
        }

        @Override
        public String getDisplayString(IActiveJvm jvm) {
            if (JvmConnectionWrapper.isBlank(jvm.getMainClass())) {
                return "Java Process";
            }
            String main = jvm.getMainClass();
            String alias = vmAliasMap.get(main);
            return alias == null ? main : alias;
        }
    }

    private static abstract class JvmConnectionWrapperLabelProvider {
        private JvmConnectionWrapperLabelProvider() {
        }

        public abstract boolean accepts(IActiveJvm var1);

        public abstract Image getImage(IActiveJvm var1);

        public abstract String getDisplayString(IActiveJvm var1);
    }

    private static class KarafLabelProvider
    extends JvmConnectionWrapperLabelProvider {
        private KarafLabelProvider() {
        }

        @Override
        public boolean accepts(IActiveJvm jvm) {
            return JvmConnectionWrapper.isKaraf(jvm);
        }

        @Override
        public Image getImage(IActiveJvm jvm) {
            String karafHomeFolder = JvmConnectionWrapper.getKarafHomeFolder(jvm);
            String karafSubType = JvmConnectionWrapper.getKarafSubtype(karafHomeFolder);
            Image i = null;
            if (karafSubType != null) {
                i = karafSubType.toLowerCase().contains("esb") ? Activator.getDefault().getSharedImages().image("image/fuse_server.png") : (karafSubType.toLowerCase().contains("fabric") ? Activator.getDefault().getSharedImages().image("image/fabric.png") : (karafSubType.toLowerCase().contains("mq") ? Activator.getDefault().getSharedImages().image("image/mq_server.png") : (karafSubType.toLowerCase().contains("servicemix") ? Activator.getDefault().getSharedImages().image("image/smx_server.png") : Activator.getDefault().getSharedImages().image("image/container.png"))));
            }
            return i;
        }

        @Override
        public String getDisplayString(IActiveJvm jvm) {
            String karafHomeFolder = JvmConnectionWrapper.getKarafHomeFolder(jvm);
            String karafSubType = JvmConnectionWrapper.getKarafSubtype(karafHomeFolder);
            String displayName = jvm.getMainClass();
            displayName = karafSubType == null ? JvmConnectionWrapper.getNameFromAliasMap(displayName) : karafSubType;
            return displayName;
        }
    }

    private static class MavenLabelProvider
    extends JvmConnectionWrapperLabelProvider {
        private MavenLabelProvider() {
        }

        @Override
        public boolean accepts(IActiveJvm jvm) {
            return jvm.getMainClass().startsWith(JvmConnectionWrapper.MAVEN_PREFIX);
        }

        @Override
        public Image getImage(IActiveJvm jvm) {
            return Activator.getDefault().getSharedImages().image("image/container.gif");
        }

        @Override
        public String getDisplayString(IActiveJvm jvm) {
            int start;
            String pInfo;
            String displayName = "maven" + jvm.getMainClass().substring(JvmConnectionWrapper.MAVEN_PREFIX.length());
            if (!jvm.isRemote() && (pInfo = ProcessInformationStore.getDefault().queryProcessInformation(jvm.getPid())) != null && (start = pInfo.indexOf(JvmConnectionWrapper.ECLIPSE_MAVEN_PROCESS_PREFIX)) != -1) {
                int end = pInfo.indexOf(JvmConnectionWrapper.ECLIPSE_MAVEN_PROCESS_POSTFIX, start + JvmConnectionWrapper.ECLIPSE_MAVEN_PROCESS_PREFIX.length() + 1);
                displayName = end != -1 ? pInfo.substring(start + JvmConnectionWrapper.ECLIPSE_MAVEN_PROCESS_PREFIX.length(), end) : pInfo.substring(start + JvmConnectionWrapper.ECLIPSE_MAVEN_PROCESS_PREFIX.length());
            }
            return displayName;
        }
    }
}

