/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import tern.eclipse.ide.core.ITernServerType;
import tern.eclipse.ide.core.ITernServerTypeManager;
import tern.eclipse.ide.internal.core.TernServerType;
import tern.eclipse.ide.internal.core.Trace;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.server.TernDef;
import tern.server.TernPlugin;
import tern.utils.TernModuleHelper;

public class TernServerTypeManager
implements ITernServerTypeManager,
IRegistryChangeListener {
    private static final String EXTENSION_TERN_SERVER_TYPES = "ternServerTypes";
    private static final TernServerTypeManager INSTANCE = new TernServerTypeManager();
    private List<ITernServerType> ternServerTypes;
    private boolean registryListenerIntialized = false;
    private final ITernModule[] modules;

    public static TernServerTypeManager getManager() {
        return INSTANCE;
    }

    public TernServerTypeManager() {
        ArrayList modules = new ArrayList();
        Collections.addAll(modules, this.getTernDefs());
        Collections.addAll(modules, this.getTernPlugins());
        this.modules = modules.toArray(ITernModule.EMPTY_MODULE);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.core", EXTENSION_TERN_SERVER_TYPES);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernServerTypeDelta(delta);
                ++n2;
            }
        }
    }

    @Override
    public ITernServerType[] getTernServerTypes() {
        if (this.ternServerTypes == null) {
            this.loadTernServerTypes();
        }
        ITernServerType[] st = new ITernServerType[this.ternServerTypes.size()];
        this.ternServerTypes.toArray(st);
        return st;
    }

    @Override
    public ITernServerType findTernServerType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (this.ternServerTypes == null) {
            this.loadTernServerTypes();
        }
        for (ITernServerType serverType : this.ternServerTypes) {
            if (!id.equals(serverType.getId())) continue;
            return serverType;
        }
        return null;
    }

    private synchronized void loadTernServerTypes() {
        if (this.ternServerTypes != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternServerTypes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.core", EXTENSION_TERN_SERVER_TYPES);
        ArrayList<ITernServerType> list = new ArrayList<ITernServerType>(cf.length);
        this.addTernServerTypes(cf, list);
        this.addRegistryListenerIfNeeded();
        this.ternServerTypes = list;
        Trace.trace((byte)7, "-<- Done loading .ternServerTypes extension point -<-");
    }

    private synchronized void addTernServerTypes(IConfigurationElement[] cf, List<ITernServerType> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                list.add(new TernServerType(ce));
                Trace.trace((byte)7, "  Loaded serverType: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load serverType: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    protected void handleTernServerTypeDelta(IExtensionDelta delta) {
        if (this.ternServerTypes == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<ITernServerType> list = new ArrayList<ITernServerType>(this.ternServerTypes);
        if (delta.getKind() == 1) {
            this.addTernServerTypes(cf, list);
        } else {
            int size = list.size();
            TernServerType[] st = new TernServerType[size];
            list.toArray(st);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (st[i].getId().equals(cf[j].getAttribute("id"))) {
                        st[i].dispose();
                        list.remove(st[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.ternServerTypes = list;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.core");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        if (this.ternServerTypes == null) {
            return;
        }
        ArrayList<ITernServerType> types = new ArrayList<ITernServerType>(this.ternServerTypes);
        for (ITernServerType type : types) {
            type.dispose();
            this.ternServerTypes.remove(type);
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    @Override
    public void refresh() {
        if (this.ternServerTypes == null) {
            return;
        }
        for (ITernServerType type : this.ternServerTypes) {
            type.dispose();
        }
    }

    @Override
    public ITernModule[] getTernModules() {
        return this.modules;
    }

    @Override
    public ITernModule[] getTernModulesGroupByType() {
        ArrayList groupedModules = new ArrayList();
        TernModuleHelper.groupByType((ITernModule[])this.modules, groupedModules);
        return groupedModules.toArray(ITernModule.EMPTY_MODULE);
    }

    @Override
    public ITernPlugin[] getTernPlugins() {
        return TernPlugin.values();
    }

    @Override
    public ITernPlugin findTernPlugin(String name) {
        return TernPlugin.getTernPlugin((String)name);
    }

    @Override
    public ITernDef[] getTernDefs() {
        return TernDef.values();
    }

    @Override
    public ITernDef findTernDef(String name) {
        return TernDef.getTernDef((String)name);
    }

    @Override
    public ITernModule findTernModule(String name) {
        ITernPlugin plugin = this.findTernPlugin(name);
        if (plugin != null) {
            return plugin;
        }
        return this.findTernDef(name);
    }
}

