/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core;

import com.eclipsesource.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import tern.TernProject;
import tern.eclipse.ide.core.IDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.core.Trace;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernModule;
import tern.utils.StringUtils;
import tern.utils.TernModuleHelper;

public class TernNatureAdaptersManager
implements IRegistryChangeListener {
    private static final String EXTENSION_TERN_NATURE_ADAPTERS = "ternNatureAdapters";
    private static final TernNatureAdaptersManager INSTANCE = new TernNatureAdaptersManager();
    private Map<String, List<DefaultModule>> ternNatureAdapters;
    private boolean registryListenerIntialized = false;

    public static TernNatureAdaptersManager getManager() {
        return INSTANCE;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("tern.eclipse.ide.core", EXTENSION_TERN_NATURE_ADAPTERS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleTernNatureAdapterDelta(delta);
                ++n2;
            }
        }
    }

    private synchronized void loadTernNatureAdapters() {
        if (this.ternNatureAdapters != null) {
            return;
        }
        Trace.trace((byte)7, "->- Loading .ternNatureAdapters extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("tern.eclipse.ide.core", EXTENSION_TERN_NATURE_ADAPTERS);
        HashMap<String, List<DefaultModule>> map = new HashMap<String, List<DefaultModule>>(cf.length);
        this.addTernNatureAdapters(cf, map);
        this.addRegistryListenerIfNeeded();
        this.ternNatureAdapters = map;
        Trace.trace((byte)7, "-<- Done loading .ternNatureAdapters extension point -<-");
    }

    private synchronized void addTernNatureAdapters(IConfigurationElement[] cf, Map<String, List<DefaultModule>> map) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                map.put(ce.getAttribute("id"), this.getDefaultModules(ce));
                Trace.trace((byte)7, "  Loaded project describer: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load project describers: " + ce.getAttribute("id"), t);
            }
            ++n2;
        }
    }

    private List<DefaultModule> getDefaultModules(IConfigurationElement ce) {
        ArrayList<DefaultModule> defaultModules = new ArrayList<DefaultModule>();
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren("defaultModules");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dmce = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = dmce.getChildren("module");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement mce = iConfigurationElementArray2[n4];
                String module = mce.getAttribute("name");
                if (module != null && !module.trim().isEmpty()) {
                    String name = module.trim();
                    boolean withDependencies = StringUtils.asBoolean((String)mce.getAttribute("withDependencies"), (boolean)false);
                    JsonObject options = this.getOptions(mce.getAttribute("options"));
                    defaultModules.add(new DefaultModule(name, withDependencies, options));
                }
                ++n4;
            }
            ++n2;
        }
        return defaultModules;
    }

    private JsonObject getOptions(String options) {
        if (!StringUtils.isEmpty((String)options)) {
            try {
                return JsonObject.readFrom((String)options);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    protected void handleTernNatureAdapterDelta(IExtensionDelta delta) {
        if (this.ternNatureAdapters == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        HashMap<String, List<DefaultModule>> map = new HashMap<String, List<DefaultModule>>(this.ternNatureAdapters);
        if (delta.getKind() == 1) {
            this.addTernNatureAdapters(cf, map);
        }
        this.ternNatureAdapters = map;
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "tern.eclipse.ide.core");
        this.registryListenerIntialized = true;
    }

    public void initialize() {
    }

    public void destroy() {
        if (this.ternNatureAdapters == null) {
            return;
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasTernNature(IProject project) {
        if (!project.isAccessible()) return false;
        try {
            String adaptToNature;
            if (project.hasNature("tern.eclipse.ide.core.ternnature")) {
                return true;
            }
            Map<String, List<DefaultModule>> ternNatureAdapters = this.getTernNatureAdapters();
            Iterator<String> iterator = ternNatureAdapters.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!project.hasNature(adaptToNature = iterator.next()));
            return true;
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error tern nature", e);
        }
        return false;
    }

    private Map<String, List<DefaultModule>> getTernNatureAdapters() {
        if (this.ternNatureAdapters == null) {
            this.loadTernNatureAdapters();
        }
        return this.ternNatureAdapters;
    }

    public void addDefaultModules(IDETernProject project) throws CoreException {
        Map<String, List<DefaultModule>> ternNatureAdapters = this.getTernNatureAdapters();
        for (String natureId : ternNatureAdapters.keySet()) {
            if (!project.getProject().hasNature(natureId)) continue;
            List<DefaultModule> defaultModules = ternNatureAdapters.get(natureId);
            for (DefaultModule defaultModule : defaultModules) {
                TernModuleMetadata metadata;
                ITernModule module = TernCorePlugin.getTernServerTypeManager().findTernModule(defaultModule.getName());
                if (module == null) continue;
                JsonObject options = defaultModule.getOptions();
                TernModuleHelper.update((ITernModule)module, (JsonObject)options, (TernProject)project);
                if (!defaultModule.isWithDependencies() || (metadata = module.getMetadata()) == null) continue;
                Collection dependencies = metadata.getDependencies();
                for (String dependency : dependencies) {
                    ITernModule dependencyModule = TernCorePlugin.getTernServerTypeManager().findTernModule(dependency);
                    if (dependencyModule == null) continue;
                    TernModuleHelper.update((ITernModule)dependencyModule, null, (TernProject)project);
                }
            }
        }
    }

    private static class DefaultModule {
        private final String name;
        private final boolean withDependencies;
        private final JsonObject options;

        public DefaultModule(String name, boolean withDependencies, JsonObject options) {
            this.name = name;
            this.withDependencies = withDependencies;
            this.options = options;
        }

        public String getName() {
            return this.name;
        }

        public boolean isWithDependencies() {
            return this.withDependencies;
        }

        public JsonObject getOptions() {
            return this.options;
        }
    }
}

