/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.core.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class FileUtils {
    public static final String JS_EXTENSION = "js";
    public static final String HTM_EXTENSION = "htm";
    public static final String HTML_EXTENSION = "html";
    public static final String JSP_EXTENSION = "jsp";
    public static final String PHP_EXTENSION = "php";
    public static final String JSON_EXTENSION = "json";

    public static boolean isJSFile(IResource resource) {
        return JS_EXTENSION.equals(resource.getFileExtension());
    }

    public static boolean isHTMLFile(IResource resource) {
        return HTM_EXTENSION.equals(resource.getFileExtension()) || HTML_EXTENSION.equals(resource.getFileExtension());
    }

    public static boolean isJSPFile(IResource resource) {
        return JSP_EXTENSION.equals(resource.getFileExtension());
    }

    public static boolean isPHPFile(IResource resource) {
        return PHP_EXTENSION.equals(resource.getFileExtension());
    }

    public static String getLineSeparator(IProject project) {
        if (Platform.isRunning()) {
            IScopeContext[] scopeContext;
            String lineSeparator = null;
            if (project != null) {
                scopeContext = new IScopeContext[]{new ProjectScope(project)};
                lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
                if (lineSeparator != null) {
                    return lineSeparator;
                }
            }
            scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        return System.getProperty("line.separator");
    }
}

