/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.core;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.w3c.dom.Node;
import tern.TernException;
import tern.TernFileManager;
import tern.TernProject;
import tern.angular.protocol.completions.TernAngularCompletionsQuery;
import tern.eclipse.ide.core.IDETernFileManager;
import tern.eclipse.ide.core.ITernConsoleConnector;
import tern.eclipse.ide.core.ITernServerType;
import tern.eclipse.ide.core.TernNature;
import tern.eclipse.ide.core.scriptpath.ITernScriptPath;
import tern.eclipse.ide.core.utils.FileUtils;
import tern.eclipse.ide.internal.core.TernConsoleConnectorManager;
import tern.eclipse.ide.internal.core.TernNatureAdaptersManager;
import tern.eclipse.ide.internal.core.Trace;
import tern.eclipse.ide.internal.core.preferences.TernCorePreferencesSupport;
import tern.eclipse.ide.internal.core.scriptpath.DOMElementsScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.FolderScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.JSFileScriptPath;
import tern.eclipse.ide.internal.core.scriptpath.ProjectScriptPath;
import tern.server.IResponseHandler;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.TernServerAdapter;
import tern.server.protocol.JsonHelper;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernFile;
import tern.server.protocol.TernQuery;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.type.ITernTypeCollector;

public class IDETernProject
extends TernProject<IFile> {
    private static final int MAX_FILES = 20;
    private static final String PATH_JSON_FIELD = "path";
    private static final String TYPE_JSON_FIELD = "type";
    private static final String SCRIPT_PATHS_JSON_FIELD = "scriptPaths";
    private static final String IDE_JSON_FIELD = "ide";
    private static final long serialVersionUID = 1L;
    private static final QualifiedName TERN_PROJECT = new QualifiedName("tern.eclipse.ide.core.sessionprops", "TernProject");
    private final IProject project;
    private ITernServer ternServer;
    private final List<ITernScriptPath> scriptPaths;
    private final Object lock = new Object();
    private final Map<String, Object> data;
    private final List<ITernServerListener> listeners;

    IDETernProject(IProject project) throws CoreException {
        super(project.getLocation().toFile());
        this.project = project;
        super.setFileManager((TernFileManager)new IDETernFileManager(this.getProject()));
        project.setSessionProperty(TERN_PROJECT, (Object)this);
        this.scriptPaths = new ArrayList<ITernScriptPath>();
        this.data = new HashMap<String, Object>();
        this.listeners = new ArrayList<ITernServerListener>();
        this.ensureNatureIsConfigured();
    }

    public static IDETernProject getTernProject(IProject project) throws CoreException {
        if (!IDETernProject.hasTernNature(project)) {
            throw new CoreException((IStatus)new Status(4, "tern.eclipse.ide.core", "The project " + project.getName() + " is not a tern project."));
        }
        IDETernProject ternProject = (IDETernProject)((Object)project.getSessionProperty(TERN_PROJECT));
        if (ternProject == null) {
            ternProject = new IDETernProject(project);
            try {
                ternProject.load();
            }
            catch (IOException e) {
                Trace.trace((byte)3, "Error while loading tern project", e);
            }
        }
        return ternProject;
    }

    public IProject getProject() {
        return this.project;
    }

    private ITernServer getTernServer() {
        if (this.isTernServerDisposed()) {
            try {
                ITernServerType type = TernCorePreferencesSupport.getInstance().getServerType();
                this.ternServer = type.createServer(this);
                this.ternServer.addServerListener((ITernServerListener)new TernServerAdapter(){

                    public void onStop(ITernServer server) {
                        IDETernProject.this.getFileManager().cleanIndexedFiles();
                    }
                });
                this.copyListeners();
                this.configureConsole();
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error while creating tern server", e);
            }
        }
        return this.ternServer;
    }

    public boolean isTernServerDisposed() {
        return this.ternServer == null || this.ternServer.isDisposed();
    }

    public static boolean hasTernNature(IProject project) {
        return TernNatureAdaptersManager.getManager().hasTernNature(project);
    }

    public void load() throws IOException {
        super.load();
        this.loadIDEInfos();
        this.initAdaptedNaturesInfos();
    }

    private void loadIDEInfos() {
        JsonArray jsonScripts;
        this.scriptPaths.clear();
        JsonObject ide = (JsonObject)super.get(IDE_JSON_FIELD);
        if (ide != null && (jsonScripts = (JsonArray)ide.get(SCRIPT_PATHS_JSON_FIELD)) != null) {
            JsonObject jsonScript = null;
            String type = null;
            String path = null;
            for (Object object : jsonScripts) {
                IResource resource;
                jsonScript = (JsonObject)object;
                type = JsonHelper.getString((JsonObject)jsonScript, (String)TYPE_JSON_FIELD);
                path = JsonHelper.getString((JsonObject)jsonScript, (String)PATH_JSON_FIELD);
                if (type == null || path == null) continue;
                ITernScriptPath.ScriptPathsType pathType = ITernScriptPath.ScriptPathsType.getType(type);
                if (pathType == null) {
                    pathType = ITernScriptPath.ScriptPathsType.FILE;
                }
                if (pathType == null || (resource = this.getResource(path, pathType)) == null || !resource.exists()) continue;
                this.scriptPaths.add(this.createScriptPath(resource, pathType));
            }
        }
    }

    private void initAdaptedNaturesInfos() {
        try {
            TernNatureAdaptersManager.getManager().addDefaultModules(this);
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while configuring default tern project modules", e);
            return;
        }
        try {
            this.saveIfNeeded();
        }
        catch (IOException e) {
            Trace.trace((byte)3, "Error while saving tern project", e);
        }
    }

    private IResource getResource(String path, ITernScriptPath.ScriptPathsType pathType) {
        switch (pathType) {
            case FILE: {
                return this.getProject().getFile(path);
            }
            case FOLDER: {
                return this.getProject().getFolder(path);
            }
            case PROJECT: {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(path);
            }
        }
        throw new UnsupportedOperationException("Cannot retrieve resource from the type=" + (Object)((Object)pathType) + " of the path=" + path);
    }

    public void save() throws IOException {
        this.saveIDEInfos();
        super.save();
        if (this.ternServer != null) {
            this.ternServer.dispose();
            this.ternServer = null;
        }
    }

    private void saveIDEInfos() {
        JsonObject ide = new JsonObject();
        if (this.scriptPaths.size() > 0) {
            JsonArray jsonScripts = new JsonArray();
            for (ITernScriptPath scriptPath : this.scriptPaths) {
                JsonObject jsonScript = new JsonObject();
                jsonScript.add(TYPE_JSON_FIELD, scriptPath.getType().name());
                jsonScript.add(PATH_JSON_FIELD, scriptPath.getPath());
                jsonScripts.add((JsonValue)jsonScript);
            }
            ide.add(SCRIPT_PATHS_JSON_FIELD, (JsonValue)jsonScripts);
        }
        super.set(IDE_JSON_FIELD, (JsonValue)ide);
    }

    public Collection<ITernScriptPath> getScriptPaths() {
        return this.scriptPaths;
    }

    public ITernScriptPath createScriptPath(IResource resource, ITernScriptPath.ScriptPathsType type) {
        switch (type) {
            case FOLDER: {
                return new FolderScriptPath((IFolder)resource);
            }
            case FILE: {
                IFile file = (IFile)resource;
                if (FileUtils.isJSFile((IResource)file)) {
                    return new JSFileScriptPath(file);
                }
                return new DOMElementsScriptPath(file);
            }
            case PROJECT: {
                return new ProjectScriptPath((IProject)resource, this.getProject());
            }
        }
        throw new UnsupportedOperationException("Cannot create script path for the given type " + (Object)((Object)type));
    }

    public void setScriptPaths(List<ITernScriptPath> scriptPaths) {
        this.scriptPaths.clear();
        this.scriptPaths.addAll(scriptPaths);
    }

    public boolean equals(Object value) {
        if (value instanceof IDETernProject) {
            return ((IDETernProject)((Object)value)).getProject().equals((Object)this.getProject());
        }
        return super.equals(value);
    }

    public ITernScriptPath getScriptPath(String path) {
        for (ITernScriptPath scriptPath : this.scriptPaths) {
            if (!scriptPath.getPath().equals(path)) continue;
            return scriptPath;
        }
        return null;
    }

    public boolean isTraceOnConsole() {
        return TernCorePreferencesSupport.getInstance().isTraceOnConsole(this.project);
    }

    public void configureConsole() {
        ITernConsoleConnector connector;
        if (this.ternServer != null && (connector = TernConsoleConnectorManager.getManager().getConnector(this.ternServer)) != null) {
            if (this.isTraceOnConsole()) {
                connector.connectToConsole(this.ternServer, this);
            } else {
                connector.disconnectToConsole(this.ternServer, this);
            }
        }
    }

    public void request(TernAngularCompletionsQuery query, JsonArray names, ITernCompletionCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, null);
        TernDoc doc = new TernDoc((TernQuery)query);
        this.request(doc, collector);
    }

    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, ITernCompletionCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, scriptPath);
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    public void request(TernQuery query, JsonArray names, Node domNode, IFile domFile, ITernCompletionCollector collector) throws IOException, TernException {
        this.synchFiles(names, domNode, domFile, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    public void request(TernQuery query, IFile file, IDocument document, int startOffset, ITernCompletionCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernCompletionCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, ITernDefinitionCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, scriptPath);
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    public void request(TernQuery query, JsonArray names, Node domNode, IFile domFile, ITernDefinitionCollector collector) throws IOException, TernException {
        this.synchFiles(names, domNode, domFile, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    public void request(TernQuery query, IFile file, IDocument document, ITernDefinitionCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernDefinitionCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    public void request(TernQuery query, IFile file, IDocument document, ITernLintCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        String name = this.getFileManager().getFileName((Object)file);
        query.setFile(name);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernLintCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFiles(TernDoc doc, JsonArray names, ITernScriptPath scriptPath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            for (ITernScriptPath currentScriptPath : this.scriptPaths) {
                currentScriptPath.updateFiles(this.getFileManager(), doc, this.getNames(names, currentScriptPath, scriptPath));
            }
            this.synchFiles(doc);
        }
    }

    private JsonArray getNames(JsonArray names, ITernScriptPath currentScriptPath, ITernScriptPath scriptPath) {
        if (names != null) {
            if (scriptPath == null || currentScriptPath.equals(scriptPath)) {
                return names;
            }
            return null;
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchFiles(IFile file, IDocument document, TernDoc doc) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.syncFiles(doc, null, null);
            if (file != null && file.exists()) {
                String name = this.getFileManager().getFileName((Object)file);
                String text = document.get();
                doc.addFile(name, text, null);
                TernQuery query = doc.getQuery();
                if (query != null) {
                    query.setFile(name);
                }
            }
            this.synchFiles(doc);
        }
    }

    private void updateFragmentAround(TernDoc doc, String name, IDocument document, int start, int end) {
        FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(document);
        try {
            long s = System.currentTimeMillis();
            IRegion region = adapter.find(end, "\\bfunction\\b", false, false, false, true);
            System.err.println(region);
            System.err.println(System.currentTimeMillis() - s);
            if (region != null) {
                String text = document.get(region.getOffset(), end - region.getOffset());
                int n = document.getLineOfOffset(region.getOffset());
                System.err.println(n);
                doc.addFile(name, text, Integer.valueOf(n));
                doc.getQuery().setEnd(Integer.valueOf(JsonHelper.getInteger((JsonObject)doc.getQuery(), (String)"end") - region.getOffset()));
            } else {
                String text = document.get();
                doc.addFile(name, text, null);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void synchFiles(TernDoc doc) {
        if (doc.hasFiles()) {
            JsonArray files = doc.getFiles();
            if (files.size() > 20) {
                TernDoc newDoc = new TernDoc();
                int i = 0;
                while (i < files.size()) {
                    newDoc.addFile((TernFile)files.get(i));
                    if (i > 0 && i % 20 == 0) {
                        this.request(newDoc);
                        newDoc.cleanFiles();
                    }
                    ++i;
                }
                if (newDoc.hasFiles()) {
                    this.request(newDoc);
                }
            } else {
                this.request(doc);
            }
            doc.cleanFiles();
        }
    }

    public void request(TernDoc doc) {
        ITernServer server = this.getTernServer();
        server.request(doc, new IResponseHandler(){

            public void onSuccess(Object data, String dataAsJsonString) {
            }

            public void onError(String error) {
                Trace.trace((byte)3, error);
            }

            public boolean isDataAsJsonString() {
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchFiles(JsonArray names, Node domNode, IFile domFile, TernDoc doc) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.getFileManager().updateFiles(domNode, (Object)domFile, doc, names);
            if (!doc.hasFiles()) {
                this.syncFiles(doc, names, null);
            }
            this.synchFiles(doc);
        }
    }

    public void request(TernQuery query, JsonArray names, ITernScriptPath scriptPath, ITernTypeCollector collector) throws IOException, TernException {
        this.syncFiles(new TernDoc(), names, scriptPath);
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    public void request(TernQuery query, JsonArray names, Node domNode, IFile domFile, ITernTypeCollector collector) throws IOException, TernException {
        TernDoc doc = new TernDoc(query);
        this.synchFiles(names, domNode, domFile, doc);
        this.request(doc, collector);
    }

    public void request(TernQuery query, IFile file, IDocument document, int startOffset, ITernTypeCollector collector) throws IOException, TernException {
        this.synchFiles(file, document, new TernDoc());
        TernDoc doc = new TernDoc(query);
        this.request(doc, collector);
    }

    private void request(TernDoc doc, ITernTypeCollector collector) throws TernException {
        ITernServer server = this.getTernServer();
        server.request(doc, collector);
    }

    public void disposeServer() {
        if (!this.isTernServerDisposed() && this.ternServer != null) {
            this.ternServer.dispose();
        }
    }

    public <T> T getData(String key) {
        return (T)this.data.get(key);
    }

    public void setData(String key, Object value) {
        this.data.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        this.copyListeners();
    }

    public void copyListeners() {
        if (this.ternServer != null) {
            for (ITernServerListener listener : this.listeners) {
                this.ternServer.addServerListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void ensureNatureIsConfigured() throws CoreException {
        TernNature tempTernNature = new TernNature();
        tempTernNature.setProject(this.project);
        if (!tempTernNature.isConfigured()) {
            tempTernNature.configure();
        }
    }
}

