/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import tern.TernFileManager;
import tern.eclipse.ide.core.IDETernProject;
import tern.eclipse.ide.internal.core.Trace;
import tern.utils.IOUtils;

public class IDETernFileManager
extends TernFileManager<IFile>
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private final IProject project;

    public IDETernFileManager(IProject project) {
        this.project = project;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        super.cleanIndexedFiles();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public String getFileName(IFile file) {
        String fileName = file.getProjectRelativePath().toString();
        if (!this.isBelongToLocalProject(file)) {
            return this.getFileName(file.getProject().getName(), fileName);
        }
        return fileName;
    }

    private boolean isBelongToLocalProject(IFile file) {
        return file.getProject().getName().equals(this.project.getName());
    }

    public String getFileContent(IFile file) throws IOException {
        try {
            return IOUtils.toString((InputStream)file.getContents(), (String)file.getCharset());
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public IFile getRelativeFile(IFile file, String path) {
        IContainer parent = file.getParent();
        IFile relativeFile = this.getRelativeFile(path, parent);
        if (relativeFile != null && relativeFile.exists()) {
            return relativeFile;
        }
        return null;
    }

    private IFile getRelativeFile(String path, IContainer parent) {
        try {
            return parent.getFile((IPath)new Path(path));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected IFile getFile(String projectName, String path) {
        if (projectName == null) {
            return this.project.getFile(path);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null) {
            return project.getFile(path);
        }
        return null;
    }

    void removeIndexedFile(IFile file) {
        super.removeIndexedFile(this.getFileName(file));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (Throwable e) {
            Trace.trace((byte)3, "", e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        switch (resource.getType()) {
            case 2: 
            case 8: {
                return true;
            }
            case 4: {
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    if (!project.isAccessible()) {
                        return false;
                    }
                    return IDETernProject.hasTernNature(project);
                }
            }
            case 1: {
                this.removeIndexedFile((IFile)resource);
                return true;
            }
        }
        return false;
    }
}

