/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Date;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedCounterMBean;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed Counter")
public abstract class ManagedCounter
implements ManagedCounterMBean {
    protected Statistic exchangesTotal;
    protected Statistic resetTimestamp;

    public void init(ManagementStrategy strategy) {
        this.exchangesTotal = new Statistic("org.apache.camel.exchangesTotal", this, Statistic.UpdateMode.COUNTER);
        this.resetTimestamp = new Statistic("org.apache.camel.resetTimestamp", this, Statistic.UpdateMode.VALUE);
        this.resetTimestamp.updateValue(new Date().getTime());
    }

    @Override
    public synchronized void reset() {
        this.exchangesTotal.reset();
        this.resetTimestamp.updateValue(new Date().getTime());
    }

    @Override
    public Date getResetTimestamp() {
        long value = this.resetTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public long getExchangesTotal() throws Exception {
        return this.exchangesTotal.getValue();
    }

    public synchronized void increment() {
        this.exchangesTotal.increment();
    }
}

