/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.StaticService;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.impl.DefaultThreadPoolFactory;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutorServiceManager
extends ServiceSupport
implements ExecutorServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecutorServiceManager.class);
    private final CamelContext camelContext;
    private ThreadPoolFactory threadPoolFactory = new DefaultThreadPoolFactory();
    private final List<ExecutorService> executorServices = new CopyOnWriteArrayList<ExecutorService>();
    private String threadNamePattern;
    private long shutdownAwaitTermination = 10000L;
    private String defaultThreadPoolProfileId = "defaultThreadPoolProfile";
    private final Map<String, ThreadPoolProfile> threadPoolProfiles = new ConcurrentHashMap<String, ThreadPoolProfile>();
    private ThreadPoolProfile defaultProfile;

    public DefaultExecutorServiceManager(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.defaultProfile = new ThreadPoolProfile(this.defaultThreadPoolProfileId);
        this.defaultProfile.setDefaultProfile(true);
        this.defaultProfile.setPoolSize(10);
        this.defaultProfile.setMaxPoolSize(20);
        this.defaultProfile.setKeepAliveTime(60L);
        this.defaultProfile.setTimeUnit(TimeUnit.SECONDS);
        this.defaultProfile.setMaxQueueSize(1000);
        this.defaultProfile.setRejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns);
        this.registerThreadPoolProfile(this.defaultProfile);
    }

    @Override
    public ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPoolFactory;
    }

    @Override
    public void setThreadPoolFactory(ThreadPoolFactory threadPoolFactory) {
        this.threadPoolFactory = threadPoolFactory;
    }

    @Override
    public void registerThreadPoolProfile(ThreadPoolProfile profile) {
        ObjectHelper.notNull(profile, "profile");
        ObjectHelper.notEmpty(profile.getId(), "id", profile);
        this.threadPoolProfiles.put(profile.getId(), profile);
    }

    @Override
    public ThreadPoolProfile getThreadPoolProfile(String id) {
        return this.threadPoolProfiles.get(id);
    }

    @Override
    public ThreadPoolProfile getDefaultThreadPoolProfile() {
        return this.getThreadPoolProfile(this.defaultThreadPoolProfileId);
    }

    @Override
    public void setDefaultThreadPoolProfile(ThreadPoolProfile defaultThreadPoolProfile) {
        this.threadPoolProfiles.remove(this.defaultThreadPoolProfileId);
        defaultThreadPoolProfile.addDefaults(this.defaultProfile);
        LOG.info("Using custom DefaultThreadPoolProfile: " + defaultThreadPoolProfile);
        this.defaultThreadPoolProfileId = defaultThreadPoolProfile.getId();
        defaultThreadPoolProfile.setDefaultProfile(true);
        this.registerThreadPoolProfile(defaultThreadPoolProfile);
    }

    @Override
    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    @Override
    public void setThreadNamePattern(String threadNamePattern) {
        String name;
        this.threadNamePattern = name = threadNamePattern.replaceFirst("#camelId#", this.camelContext.getName());
    }

    @Override
    public long getShutdownAwaitTermination() {
        return this.shutdownAwaitTermination;
    }

    @Override
    public void setShutdownAwaitTermination(long shutdownAwaitTermination) {
        this.shutdownAwaitTermination = shutdownAwaitTermination;
    }

    @Override
    public String resolveThreadName(String name) {
        return ThreadHelper.resolveThreadName(this.threadNamePattern, name);
    }

    @Override
    public Thread newThread(String name, Runnable runnable) {
        ThreadFactory factory = this.createThreadFactory(name, true);
        return factory.newThread(runnable);
    }

    @Override
    public ExecutorService newDefaultThreadPool(Object source, String name) {
        return this.newThreadPool(source, name, this.getDefaultThreadPoolProfile());
    }

    @Override
    public ScheduledExecutorService newDefaultScheduledThreadPool(Object source, String name) {
        return this.newScheduledThreadPool(source, name, this.getDefaultThreadPoolProfile());
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newThreadPool(source, name, profile);
        }
        return null;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri(name);
        ObjectHelper.notNull(profile, "ThreadPoolProfile");
        ThreadPoolProfile defaultProfile = this.getDefaultThreadPoolProfile();
        profile.addDefaults(defaultProfile);
        ThreadFactory threadFactory = this.createThreadFactory(sanitizedName, true);
        ExecutorService executorService = this.threadPoolFactory.newThreadPool(profile, threadFactory);
        this.onThreadPoolCreated(executorService, source, profile.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, executorService});
        }
        return executorService;
    }

    @Override
    public ExecutorService newThreadPool(Object source, String name, int poolSize, int maxPoolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        profile.setMaxPoolSize(maxPoolSize);
        return this.newThreadPool(source, name, profile);
    }

    @Override
    public ExecutorService newSingleThreadExecutor(Object source, String name) {
        return this.newFixedThreadPool(source, name, 1);
    }

    @Override
    public ExecutorService newCachedThreadPool(Object source, String name) {
        String sanitizedName = URISupport.sanitizeUri(name);
        ExecutorService answer = this.threadPoolFactory.newCachedThreadPool(this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new CachedThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, answer});
        }
        return answer;
    }

    @Override
    public ExecutorService newFixedThreadPool(Object source, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        profile.setMaxPoolSize(poolSize);
        profile.setKeepAliveTime(0L);
        return this.newThreadPool(source, name, profile);
    }

    @Override
    public ScheduledExecutorService newSingleThreadScheduledExecutor(Object source, String name) {
        return this.newScheduledThreadPool(source, name, 1);
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri(name);
        profile.addDefaults(this.getDefaultThreadPoolProfile());
        ScheduledExecutorService answer = this.threadPoolFactory.newScheduledThreadPool(profile, this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ScheduledThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, answer});
        }
        return answer;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newScheduledThreadPool(source, name, profile);
        }
        return null;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(poolSize);
        return this.newScheduledThreadPool(source, name, profile);
    }

    @Override
    public void shutdown(ExecutorService executorService) {
        this.doShutdown(executorService, 0L, false);
    }

    @Override
    public void shutdownGraceful(ExecutorService executorService) {
        this.doShutdown(executorService, this.getShutdownAwaitTermination(), false);
    }

    @Override
    public void shutdownGraceful(ExecutorService executorService, long shutdownAwaitTermination) {
        this.doShutdown(executorService, shutdownAwaitTermination, false);
    }

    private boolean doShutdown(ExecutorService executorService, long shutdownAwaitTermination, boolean failSafe) {
        if (executorService == null) {
            return false;
        }
        boolean warned = false;
        if (!executorService.isShutdown()) {
            StopWatch watch = new StopWatch();
            LOG.trace("Shutdown of ExecutorService: {} with await termination: {} millis", (Object)executorService, (Object)shutdownAwaitTermination);
            executorService.shutdown();
            if (shutdownAwaitTermination > 0L) {
                try {
                    if (!this.awaitTermination(executorService, shutdownAwaitTermination)) {
                        warned = true;
                        LOG.warn("Forcing shutdown of ExecutorService: {} due first await termination elapsed.", (Object)executorService);
                        executorService.shutdownNow();
                        if (!this.awaitTermination(executorService, shutdownAwaitTermination)) {
                            LOG.warn("Cannot completely force shutdown of ExecutorService: {} due second await termination elapsed.", (Object)executorService);
                        }
                    }
                }
                catch (InterruptedException e) {
                    warned = true;
                    LOG.warn("Forcing shutdown of ExecutorService: {} due interrupted.", (Object)executorService);
                    executorService.shutdownNow();
                }
            }
            if (warned) {
                LOG.info("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration(watch.taken())});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration(watch.taken())});
            }
        }
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            threadPool = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            threadPool = ((SizedScheduledExecutorService)executorService).getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolRemove(this.camelContext, threadPool);
            }
        }
        if (!failSafe) {
            this.executorServices.remove(executorService);
        }
        return warned;
    }

    @Override
    public List<Runnable> shutdownNow(ExecutorService executorService) {
        return this.doShutdownNow(executorService, false);
    }

    private List<Runnable> doShutdownNow(ExecutorService executorService, boolean failSafe) {
        ObjectHelper.notNull(executorService, "executorService");
        List<Runnable> answer = null;
        if (!executorService.isShutdown()) {
            if (failSafe) {
                LOG.warn("Forcing shutdown of ExecutorService: {}", (Object)executorService);
            } else {
                LOG.debug("Forcing shutdown of ExecutorService: {}", (Object)executorService);
            }
            answer = executorService.shutdownNow();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated()});
            }
        }
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            threadPool = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            threadPool = ((SizedScheduledExecutorService)executorService).getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolRemove(this.camelContext, threadPool);
            }
        }
        if (!failSafe) {
            this.executorServices.remove(executorService);
        }
        return answer;
    }

    @Override
    public boolean awaitTermination(ExecutorService executorService, long shutdownAwaitTermination) throws InterruptedException {
        StopWatch watch = new StopWatch();
        long interval = Math.min(2000L, shutdownAwaitTermination);
        boolean done = false;
        while (!done && interval > 0L) {
            if (executorService.awaitTermination(interval, TimeUnit.MILLISECONDS)) {
                done = true;
                continue;
            }
            LOG.info("Waited {} for ExecutorService: {} to terminate...", (Object)TimeUtils.printDuration(watch.taken()), (Object)executorService);
            interval = Math.min(2000L, shutdownAwaitTermination - watch.taken());
        }
        return done;
    }

    protected void onNewExecutorService(ExecutorService executorService) {
    }

    @Override
    protected void doStart() throws Exception {
        if (this.threadNamePattern == null) {
            this.threadNamePattern = "Camel (" + this.camelContext.getName() + ") thread ##counter# - #name#";
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        LinkedHashSet<ExecutorService> forced = new LinkedHashSet<ExecutorService>();
        if (!this.executorServices.isEmpty()) {
            LOG.debug("Giving time for {} ExecutorService's to shutdown properly (acting as fail-safe)", (Object)this.executorServices.size());
            for (ExecutorService executorService : this.executorServices) {
                try {
                    boolean warned = this.doShutdown(executorService, this.getShutdownAwaitTermination(), true);
                    if (!warned) continue;
                    forced.add(executorService);
                }
                catch (Throwable e) {
                    LOG.warn("Error occurred during shutdown of ExecutorService: " + executorService + ". This exception will be ignored.", e);
                }
            }
        }
        if (!forced.isEmpty()) {
            LOG.warn("Forced shutdown of {} ExecutorService's which has not been shutdown properly (acting as fail-safe)", (Object)forced.size());
            for (ExecutorService executorService : forced) {
                LOG.warn("  forced -> {}", (Object)executorService);
            }
        }
        forced.clear();
        this.executorServices.clear();
        Iterator<ThreadPoolProfile> it = this.threadPoolProfiles.values().iterator();
        while (it.hasNext()) {
            ThreadPoolProfile profile = it.next();
            if (profile.isDefaultProfile().booleanValue()) continue;
            it.remove();
        }
    }

    private void onThreadPoolCreated(ExecutorService executorService, Object source, String threadPoolProfileId) {
        RouteDefinition route;
        String id;
        this.executorServices.add(executorService);
        String sourceId = null;
        String routeId = null;
        if (source instanceof NamedNode) {
            id = ((OptionalIdentifiedDefinition)source).idOrCreate(this.camelContext.getNodeIdFactory());
            sourceId = ((NamedNode)source).getShortName();
        } else {
            id = source instanceof String ? (String)source : (source != null ? (source instanceof StaticService ? source.getClass().getSimpleName() : source.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(source) + ")") : executorService.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode(executorService) + ")");
        }
        ObjectHelper.notEmpty(id, "id for thread pool " + executorService);
        if (source instanceof ProcessorDefinition && (route = ProcessorDefinitionHelper.getRoute((ProcessorDefinition)source)) != null) {
            routeId = route.idOrCreate(this.camelContext.getNodeIdFactory());
        }
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            threadPool = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            threadPool = ((SizedScheduledExecutorService)executorService).getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolAdd(this.camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId);
            }
        }
        this.onNewExecutorService(executorService);
    }

    private ThreadFactory createThreadFactory(String name, boolean isDaemon) {
        CamelThreadFactory threadFactory = new CamelThreadFactory(this.threadNamePattern, name, isDaemon);
        return threadFactory;
    }
}

