/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.camel.Component;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.ParameterConfiguration;
import org.apache.camel.spi.EndpointCompleter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public abstract class ComponentConfigurationSupport
implements ComponentConfiguration {
    protected final Component component;
    private Map<String, Object> propertyValues = new HashMap<String, Object>();
    private String baseUri;

    public ComponentConfigurationSupport(Component component) {
        this.component = component;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.propertyValues);
    }

    @Override
    public void setParameters(Map<String, Object> newValues) {
        ObjectHelper.notNull(newValues, "propertyValues");
        this.propertyValues.clear();
        Set<Map.Entry<String, Object>> entries = newValues.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object getParameter(String name) {
        this.validatePropertyName(name);
        return this.propertyValues.get(name);
    }

    @Override
    public void setParameter(String name, Object value) {
        Object convertedValue = this.validatePropertyValue(name, value);
        this.propertyValues.put(name, convertedValue);
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    @Override
    public Endpoint createEndpoint() throws Exception {
        String uri = this.getUriString();
        return this.component.createEndpoint(uri);
    }

    @Override
    public void configureEndpoint(Endpoint endpoint) {
        Map<String, Object> map = this.getParameters();
        if (map != null) {
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                this.setEndpointParameter(endpoint, entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public String getUriString() {
        ArrayList<String> queryParams = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.getParameters().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                for (Object item : (List)value) {
                    queryParams.add(key + "=" + UnsafeUriCharactersEncoder.encode(item.toString()));
                }
                continue;
            }
            queryParams.add(key + "=" + UnsafeUriCharactersEncoder.encode(value.toString()));
        }
        Collections.sort(queryParams);
        StringBuilder builder = new StringBuilder();
        String base = this.getBaseUri();
        if (base != null) {
            builder.append(base);
        }
        String separator = "?";
        for (String entry : queryParams) {
            builder.append(separator);
            builder.append(entry);
            separator = "&";
        }
        return builder.toString();
    }

    @Override
    public void setUriString(String uri) throws URISyntaxException {
        String path = uri;
        int idx = path.indexOf(63);
        Map<String, Object> newParameters = Collections.emptyMap();
        if (idx >= 0) {
            path = path.substring(0, idx);
            String query = uri.substring(idx + 1);
            newParameters = URISupport.parseQuery(query, true);
        }
        this.setBaseUri(path);
        this.setParameters(newParameters);
    }

    @Override
    public ParameterConfiguration getParameterConfiguration(String name) {
        return (ParameterConfiguration)this.getParameterConfigurationMap().get(name);
    }

    @Override
    public List<String> completeEndpointPath(String completionText) {
        if (this.component instanceof EndpointCompleter) {
            EndpointCompleter completer = (EndpointCompleter)((Object)this.component);
            return completer.completeEndpointPath(this, completionText);
        }
        return new ArrayList<String>();
    }

    @Override
    public String createParameterJsonSchema() {
        SortedMap<String, ParameterConfiguration> map = this.getParameterConfigurationMap();
        StringBuilder buffer = new StringBuilder("{\n  \"properties\": {");
        boolean first = true;
        for (Map.Entry<String, ParameterConfiguration> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            buffer.append(entry.getValue().toJson());
        }
        buffer.append("\n  }\n}\n");
        return buffer.toString();
    }

    protected void validatePropertyName(String name) {
    }

    protected Object validatePropertyValue(String name, Object value) {
        this.validatePropertyName(name);
        return value;
    }
}

