/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.camel.util.ServiceHelper;

public class LanguageProducer
extends DefaultProducer {
    public LanguageProducer(LanguageEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Object result;
        String script;
        Expression exp = exchange.getIn().getHeader("CamelLanguageScript", Expression.class);
        if (exp == null && (script = exchange.getIn().getHeader("CamelLanguageScript", String.class)) != null) {
            script = this.getEndpoint().resolveScript(script);
            exp = this.getEndpoint().getLanguage().createExpression(script);
        }
        if (exp == null && this.getEndpoint().isCacheScript()) {
            exp = this.getEndpoint().getExpression();
        }
        if (exp == null) {
            script = this.getEndpoint().getScript();
            if (script == null && this.getEndpoint().getResourceUri() == null) {
                throw new CamelExchangeException("No script to evaluate", exchange);
            }
            InputStream is = null;
            if (script == null) {
                is = this.getEndpoint().getResourceAsInputStream();
            } else if (ResourceHelper.hasScheme(script)) {
                is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getEndpoint().getCamelContext().getClassResolver(), script);
            }
            if (is != null) {
                try {
                    script = this.getEndpoint().getCamelContext().getTypeConverter().convertTo(String.class, exchange, is);
                }
                finally {
                    IOHelper.close((Closeable)is);
                }
            }
            if (script != null) {
                exp = this.getEndpoint().getLanguage().createExpression(script);
                this.getEndpoint().setContentResolvedFromResource(true);
                if (this.getEndpoint().isCacheScript()) {
                    this.getEndpoint().setExpression(exp);
                }
            } else {
                throw new CamelExchangeException("No script to evaluate", exchange);
            }
        }
        ObjectHelper.notNull(exp, "expression");
        try {
            result = exp.evaluate(exchange, Object.class);
            this.log.debug("Evaluated expression as: {} with: {}", result, (Object)exchange);
        }
        finally {
            if (!this.getEndpoint().isCacheScript()) {
                ServiceHelper.stopService(exp);
                this.getEndpoint().getCamelContext().removeService(exp);
            }
        }
        if (this.getEndpoint().isTransform()) {
            if (exchange.hasOut()) {
                exchange.getOut().setBody(result);
            } else {
                exchange.getIn().setBody(result);
            }
        }
    }

    @Override
    public LanguageEndpoint getEndpoint() {
        return (LanguageEndpoint)super.getEndpoint();
    }
}

