/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.validation;

import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.common.base.test.validation.JBTValidationTestException;
import org.jboss.tools.common.base.test.validation.ValidationExceptionLogger;
import org.jboss.tools.common.validation.CommonValidationPlugin;

public class ValidationExceptionTest
extends TestCase {
    protected static volatile ValidationExceptionLogger LOGGER;

    public static ValidationExceptionLogger initLogger() {
        LOGGER = new ValidationExceptionLogger();
        return LOGGER;
    }

    public static void assertExceptionsIsEmpty(ValidationExceptionLogger logger) throws Exception {
        Set<IStatus> exceptions = logger.getExceptions();
        StringBuffer error = new StringBuffer("The following exceptions were thrown during project validation: [");
        for (IStatus status : exceptions) {
            error.append("\r\n").append(status.toString()).append(":");
            Throwable cause = status.getException().getCause();
            if (cause != null) {
                error.append(cause.toString()).append(":");
                if (cause.getStackTrace() != null && cause.getStackTrace().length > 0) {
                    error.append(cause.getStackTrace()[0].toString());
                }
            }
            error.append(";\r\n");
        }
        error.append("]");
        ValidationExceptionTest.assertTrue((String)error.toString(), (boolean)exceptions.isEmpty());
    }

    public void testExceptions() throws Exception {
        ValidationExceptionTest.assertExceptionsIsEmpty(LOGGER);
    }

    public void testLogging() {
        ValidationExceptionLogger logger = new ValidationExceptionLogger();
        CommonValidationPlugin.getDefault().logError((Throwable)((Object)new JBTValidationTestException("Test logging", null)));
        Set<IStatus> exceptions = logger.getExceptions(false);
        ValidationExceptionTest.assertEquals((int)1, (int)exceptions.size());
    }
}

