/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.FilterUtil;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorSubsetOperation;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.test.util.JobUtils;

public class TestUtil {
    public static void _waitForValidation(IProject project) throws CoreException {
        project.build(10, null);
        ValidationFramework.getDefault().suspendAllValidation(false);
        try {
            new EnabledValidatorsOperation(project, false).run((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            ValidationFramework.getDefault().suspendAllValidation(true);
        }
    }

    public static void validate(IResource resource) throws CoreException {
        TestUtil.validate(resource.getProject(), new IResource[]{resource});
    }

    public static void validate(IProject project, IResource[] resources) throws CoreException {
        ValidationFramework.getDefault().suspendAllValidation(true);
        project.build(10, null);
        ValidationFramework.getDefault().suspendAllValidation(false);
        try {
            try {
                new IncrementalValidatorOperation(project, resources).run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
                TestCase.fail((String)e.getMessage());
                ValidationFramework.getDefault().suspendAllValidation(true);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                TestCase.fail((String)e.getMessage());
                ValidationFramework.getDefault().suspendAllValidation(true);
            }
        }
        finally {
            ValidationFramework.getDefault().suspendAllValidation(true);
        }
    }

    public static boolean waitForValidation() throws CoreException {
        int i = 0;
        while (i < 50) {
            if (ValidatorManager.getStatus().equals("Sleeping")) {
                return true;
            }
            JobUtils.delay((long)100L);
            JobUtils.waitForIdle();
            ++i;
        }
        return false;
    }

    private static class IncrementalValidatorOperation
    extends ValidatorSubsetOperation {
        public IncrementalValidatorOperation(IProject project, Object[] changedResources) throws InvocationTargetException {
            super(project, IncrementalValidatorOperation.shouldForce((Object[])changedResources), 1, false);
            ProjectConfiguration prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
            this.setEnabledValidators(InternalValidatorManager.wrapInSet((ValidatorMetaData[])prjp.getEnabledIncrementalValidators(true)));
            this.setFileDeltas(FilterUtil.getFileDeltas((Set)this.getEnabledValidators(), (Object[])changedResources, (boolean)false));
        }
    }
}

