/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.validation;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.base.test.validation.TestUtil;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.WorkbenchUtils;

public abstract class AbstractAsYouTypeValidationTest
extends TestCase {
    public static final int MAX_SECONDS_TO_WAIT = 5;
    protected String fileName;
    protected IProject project = null;
    protected IEditorPart editorPart = null;
    protected ITextEditor textEditor = null;
    protected ISourceViewer viewer = null;
    protected IDocument document = null;
    protected IFile file = null;
    IAnnotationModel annotationModel = null;
    public static final String EL2FIND_START = "#{";
    public static final String EL2FIND_END = "}";

    public AbstractAsYouTypeValidationTest(IProject project) {
        this.project = project;
    }

    public AbstractAsYouTypeValidationTest() {
    }

    public void openEditor(String fileName) {
        this.fileName = fileName;
        IFile testfile = this.project.getFile(fileName);
        AbstractAsYouTypeValidationTest.assertTrue((String)("Test file doesn't exist: " + this.project.getName() + "/" + fileName), (testfile.exists() && testfile.isAccessible() ? 1 : 0) != 0);
        this.editorPart = WorkbenchUtils.openEditor((String)(String.valueOf(this.project.getName()) + "/" + fileName));
        this.obtainEditor(this.editorPart);
        this.annotationModel = this.getAnnotationModel();
        AbstractAsYouTypeValidationTest.assertNotNull((String)"Cannot find an Annotation Model for the Java Editor", (Object)this.annotationModel);
        while (Display.getCurrent().readAndDispatch()) {
        }
        this.viewer = this.getTextViewer();
        this.document = this.viewer.getDocument();
    }

    public void closeEditor() {
        if (this.editorPart != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(this.editorPart, false);
            this.editorPart = null;
            this.textEditor = null;
            this.viewer = null;
            this.document = null;
        }
    }

    protected abstract void obtainEditor(IEditorPart var1);

    protected IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.textEditor.getDocumentProvider();
        return documentProvider == null ? null : documentProvider.getAnnotationModel((Object)this.textEditor.getEditorInput());
    }

    public IDocument getDocument() {
        return this.document;
    }

    public IFile getFile() {
        return this.file;
    }

    protected abstract ISourceViewer getTextViewer();

    public boolean doAsYouTypeValidationTest(String goodEL, String elToValidate, String errorMessage, int numberOfRegionToTest) throws Exception {
        String documentContent = this.document.get();
        int count = -1;
        int start = 0;
        int end = 0;
        while (++count <= numberOfRegionToTest) {
            int n = start = documentContent == null ? -1 : documentContent.indexOf(EL2FIND_START, end);
            if (start == -1 && count == numberOfRegionToTest) {
                return false;
            }
            AbstractAsYouTypeValidationTest.assertFalse((String)"No EL found in Java Strings: Starting '#{' characters are not found in document", (start == -1 ? 1 : 0) != 0);
            int n2 = end = documentContent == null ? -1 : documentContent.indexOf(EL2FIND_END, start);
            if (end == -1 && count == numberOfRegionToTest) {
                return false;
            }
            AbstractAsYouTypeValidationTest.assertFalse((String)"EL is not closed in Java Strings: Ending '#{' characters are not found in document", (end == -1 ? 1 : 0) != 0);
        }
        if (count < numberOfRegionToTest) {
            return false;
        }
        int length = end - start + EL2FIND_END.length();
        this.document.replace(start, length, goodEL);
        Annotation problemAnnotation = this.waitForAnnotation(start, end, null, 5, false, false);
        AbstractAsYouTypeValidationTest.assertNull((String)"Problem Annotation found on a good EL!", (Object)problemAnnotation);
        length = goodEL.length();
        this.document.replace(start, length, elToValidate);
        length = elToValidate.length();
        end = start + elToValidate.length();
        problemAnnotation = this.waitForAnnotation(start, end, errorMessage, 5, false, true);
        AbstractAsYouTypeValidationTest.assertNotNull((String)"No Problem Annotation found!", (Object)problemAnnotation);
        String message = problemAnnotation.getText();
        AbstractAsYouTypeValidationTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [" + errorMessage + "], Found: [" + message + "]"), (String)errorMessage, (String)message);
        this.document.replace(start, length, goodEL);
        problemAnnotation = this.waitForAnnotation(start, end, null, 5, false, false);
        AbstractAsYouTypeValidationTest.assertNull((String)"Problem Annotation has not disappeared!", (Object)problemAnnotation);
        return true;
    }

    public boolean doAsYouTypeValidationMarkerAnnotationsRemovalTest(String goodEL, String elToValidate, String errorMessage, String anotherELToValidate, String anotherErrorMessage, int numberOfRegionToTest) throws BadLocationException, CoreException {
        String documentContent = this.document.get();
        int count = -1;
        int start = 0;
        int end = 0;
        while (++count <= numberOfRegionToTest) {
            int n = start = documentContent == null ? -1 : documentContent.indexOf(EL2FIND_START, end);
            if (start == -1 && count == numberOfRegionToTest) {
                return false;
            }
            AbstractAsYouTypeValidationTest.assertFalse((String)"No EL found in Java Strings: Starting '#{' characters are not found in document", (start == -1 ? 1 : 0) != 0);
            int n2 = end = documentContent == null ? -1 : documentContent.indexOf(EL2FIND_END, start);
            if (end == -1 && count == numberOfRegionToTest) {
                return false;
            }
            AbstractAsYouTypeValidationTest.assertFalse((String)"EL is not closed in Java Strings: Ending '#{' characters are not found in document", (end == -1 ? 1 : 0) != 0);
        }
        if (count < numberOfRegionToTest) {
            return false;
        }
        int length = end - start + EL2FIND_END.length();
        int line = this.document.getLineOfOffset(start);
        this.assertResourceMarkerIsCreated(this.file, errorMessage, line + 1);
        Annotation problemAnnotation = this.waitForAnnotation(start, end, errorMessage, 5, true, true);
        AbstractAsYouTypeValidationTest.assertNotNull((String)"Problem Marker Annotation not found!", (Object)problemAnnotation);
        String message = problemAnnotation.getText();
        AbstractAsYouTypeValidationTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [" + errorMessage + "], Found: [" + message + "]"), (String)errorMessage, (String)message);
        this.document.replace(start, length, anotherELToValidate);
        end = start + anotherELToValidate.length();
        length = anotherELToValidate.length();
        problemAnnotation = this.waitForAnnotation(start, end, anotherErrorMessage, 5, false, true);
        AbstractAsYouTypeValidationTest.assertNotNull((String)("No Problem Annotation found for EL " + anotherELToValidate + " on region " + numberOfRegionToTest + "!"), (Object)problemAnnotation);
        message = problemAnnotation.getText();
        AbstractAsYouTypeValidationTest.assertEquals((String)("Not expected error message found in ProblemAnnotation. Expected: [" + anotherErrorMessage + "], Found: [" + message + "]"), (String)anotherErrorMessage, (String)message);
        problemAnnotation = this.waitForAnnotation(start, end, null, 5, true, false);
        AbstractAsYouTypeValidationTest.assertNull((String)"Problem Marker Annotation has not disappeared!", (Object)problemAnnotation);
        this.document.replace(start, length, goodEL);
        problemAnnotation = this.waitForAnnotation(start, end, null, 5, false, false);
        AbstractAsYouTypeValidationTest.assertNull((String)"Problem Annotation has not disappeared!", (Object)problemAnnotation);
        return true;
    }

    public Annotation waitForAnnotation(final int start, final int end, final String errorMessage, final int seconds, final boolean markerAnnotation, final boolean waitForAppearance) {
        final Annotation[] result = new Annotation[1];
        final StringBuffer sb = new StringBuffer();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int secondsLeft = seconds * 10;
                boolean isFirstPass = true;
                while (secondsLeft-- > 0) {
                    if (!isFirstPass || waitForAppearance) {
                        AbstractAsYouTypeValidationTest.assertTrue((String)"Running Platform UI is required!", (boolean)PlatformUI.isWorkbenchRunning());
                        AbstractAsYouTypeValidationTest.assertNotNull((String)"Display is required!", (Object)Display.getCurrent());
                        Thread.yield();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        JobUtils.delay((long)50L);
                    } else {
                        ++secondsLeft;
                    }
                    AbstractAsYouTypeValidationTest.this.annotationModel = AbstractAsYouTypeValidationTest.this.getAnnotationModel();
                    Iterator it = AbstractAsYouTypeValidationTest.this.annotationModel.getAnnotationIterator();
                    boolean found = false;
                    sb.replace(0, sb.length(), "Found annotations: [\r\n");
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof Annotation)) continue;
                        Annotation annotation = (Annotation)o;
                        Position position = AbstractAsYouTypeValidationTest.this.annotationModel.getPosition(annotation);
                        try {
                            sb.append("Text: ").append(annotation.getText()).append(", Position: ").append(position).append(", Document Text: [").append(AbstractAsYouTypeValidationTest.this.getDocument().get(position.getOffset(), position.getOffset() + position.getLength() + 10 >= AbstractAsYouTypeValidationTest.this.getDocument().getLength() ? AbstractAsYouTypeValidationTest.this.getDocument().getLength() - position.getOffset() : position.getLength() + 10)).append("]\r\n");
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        if (position == null || position.getOffset() < start || position.getOffset() >= end || position.getOffset() + position.getLength() > end || !markerAnnotation && errorMessage != null && !errorMessage.equals(annotation.getText())) continue;
                        boolean bl = found = markerAnnotation ? AbstractAsYouTypeValidationTest.this.isMarkerAnnotationAcceptable(annotation) : AbstractAsYouTypeValidationTest.this.isAnnotationAcceptable(annotation);
                        if (!found) continue;
                        if (!waitForAppearance) break;
                        result[0] = (Annotation)o;
                        return;
                    }
                    sb.append("]");
                    if (!(found || waitForAppearance || isFirstPass)) {
                        return;
                    }
                    isFirstPass = false;
                }
            }
        });
        if (result[0] == null && errorMessage != null) {
            try {
                System.out.println("Didn't find the following annotation: Text: " + errorMessage + "; Position:" + start + "(start), " + end + "(end)." + "Document Text: [" + this.getDocument().get(start, end + 10 >= this.getDocument().getLength() ? this.getDocument().getLength() - start : end - start + 10));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            System.out.println(sb);
        }
        return result[0];
    }

    protected void waitForValidation(IProject project) throws CoreException {
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        TestUtil._waitForValidation(project);
    }

    protected String modifyELInContent(StringBuilder content, String newEL) {
        if (content == null) {
            return null;
        }
        int start = 0;
        int end = 0;
        while (start != -1) {
            start = content.indexOf(EL2FIND_START, end);
            if (start == -1 || (end = content.indexOf(EL2FIND_END, start)) == -1) break;
            content.replace(start, end + 1, newEL);
        }
        return content.toString();
    }

    protected abstract boolean isAnnotationAcceptable(Annotation var1);

    protected abstract boolean isMarkerAnnotationAcceptable(Annotation var1);

    protected abstract void assertResourceMarkerIsCreated(IFile var1, String var2, int var3) throws CoreException;
}

