/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.util.IEditorWrapper;
import org.jboss.tools.common.validation.AsYouTypeValidatorManager;
import org.jboss.tools.test.util.WorkbenchUtils;
import org.jboss.tools.tests.AbstractResourceMarkerTest;
import org.jboss.tools.tests.IAnnotationTest;

public abstract class AbstractAnnotationTest
extends TestCase
implements IAnnotationTest {
    private Set<IResource> validatedResources = new HashSet<IResource>();

    protected abstract String getMarkerType();

    private ISourceViewer getTextViewer(IEditorPart editorPart) {
        ISourceViewer viewer = null;
        ITextEditor textEditor = null;
        if (editorPart instanceof IEditorWrapper) {
            editorPart = ((IEditorWrapper)editorPart).getEditor();
        }
        if (editorPart instanceof ITextEditor) {
            textEditor = (ITextEditor)editorPart;
        } else {
            ITextEditor iTextEditor = textEditor = editorPart == null ? null : (ITextEditor)editorPart.getAdapter(ITextEditor.class);
        }
        if (textEditor instanceof JavaEditor) {
            viewer = ((JavaEditor)textEditor).getViewer();
        } else if (textEditor instanceof StructuredTextEditor) {
            viewer = ((StructuredTextEditor)textEditor).getTextViewer();
        }
        return viewer;
    }

    private void modifyDocument(IDocument document) throws BadLocationException {
        String s = document.get(document.getLength() - 1, 1);
        document.replace(document.getLength() - 1, 1, String.valueOf(s) + " ");
    }

    public void assertAnnotationsEqualToMarkers(final IResource resource) throws CoreException {
        this.validatedResources.add(resource);
        IMarker[] allMarkers = AbstractResourceMarkerTest.findMarkers((IResource)resource, (String)this.getMarkerType(), (String)".*", (boolean)true);
        StringBuffer markersSB = new StringBuffer("Marker annotations: [\r\n");
        int i = 0;
        IMarker[] iMarkerArray = allMarkers;
        int n = allMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String message = marker.getAttribute("message", "");
            int line = marker.getAttribute("lineNumber", -1);
            String mType = marker.getType();
            int startInt = marker.getAttribute("charStart", -1);
            int endInt = marker.getAttribute("charEnd", -1);
            markersSB.append(++i).append(") message=\"").append(message).append("\"; line=\"").append(line).append("\"; start=\"").append(startInt).append("\"; end=\"").append(endInt).append("\"; type=\"").append(mType).append("\"; sevirity=\"").append(marker.getAttribute("severity")).append(";\r\n");
            ++n2;
        }
        markersSB.append("]");
        IEditorPart editorPart = WorkbenchUtils.openEditor((IPath)resource.getFullPath());
        AbstractAnnotationTest.assertNotNull((Object)editorPart);
        AsYouTypeValidatorManager manager = new AsYouTypeValidatorManager(){

            public void validateString(Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter) {
                this.validateString(dirtyRegions, helper, reporter, true);
            }

            public void validateJavaElement(Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter) {
                this.validateJavaElement(dirtyRegions, helper, reporter, true);
            }
        };
        IDocument document = null;
        try {
            try {
                AsYouTypeValidatorManager.setDisabled((boolean)true);
                ISourceViewer viewer = this.getTextViewer(editorPart);
                AbstractAnnotationTest.assertNotNull((Object)viewer);
                document = viewer.getDocument();
                manager.connect(document);
                this.modifyDocument(document);
                ArrayList<2> dirtyRegions = new ArrayList<2>();
                final IDocument finalDocument = document;
                dirtyRegions.add(new IRegion(){

                    public int getOffset() {
                        return 0;
                    }

                    public int getLength() {
                        return finalDocument.getLength();
                    }
                });
                IValidationContext helper = new IValidationContext(){

                    public Object loadModel(String symbolicName) {
                        return null;
                    }

                    public Object loadModel(String symbolicName, Object[] parms) {
                        return null;
                    }

                    public String[] getURIs() {
                        return new String[]{resource.getFullPath().toString()};
                    }
                };
                IReporter reporter = new IReporter(){
                    private List<IMessage> messages = new ArrayList<IMessage>();

                    public void addMessage(IValidator origin, IMessage message) {
                        this.messages.add(message);
                    }

                    public void displaySubtask(IValidator validator, IMessage message) {
                    }

                    public List getMessages() {
                        return this.messages;
                    }

                    public boolean isCancelled() {
                        return false;
                    }

                    public void removeAllMessages(IValidator origin) {
                    }

                    public void removeAllMessages(IValidator origin, Object object) {
                    }

                    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
                    }
                };
                manager.validateJavaElement(dirtyRegions, helper, reporter);
                StringBuffer messagesSB = new StringBuffer("AYT messages: [\r\n");
                ArrayList<IMessage> messages = new ArrayList<IMessage>();
                i = 0;
                for (Object object : reporter.getMessages()) {
                    IMessage message = (IMessage)object;
                    Object mType = message.getAttribute("jbt.type");
                    if (!this.getMarkerType().equals(mType)) continue;
                    messages.add(message);
                    String text = message.getText();
                    int line = message.getLineNumber();
                    int start = message.getOffset();
                    int end = start + message.getLength();
                    messagesSB.append(++i).append(") message=\"").append(text).append("\"; line=\"").append(line).append("\"; start=\"").append(start).append("\"; end=\"").append(end).append("\"; type=\"").append(mType).append("\"; sevirity=\"").append(message.getSeverity()).append("\";\r\n");
                }
                messagesSB.append("]");
                AbstractAnnotationTest.assertEquals((String)("The number of markers doesn't equal to the number of AYT messages for " + resource + ".\r\nThe full list of the markers and messages:\r\n" + markersSB + "\r\n" + messagesSB), (int)allMarkers.length, (int)messages.size());
                for (IMessage message : messages) {
                    int end = message.getOffset() + message.getLength();
                    AbstractAnnotationTest.assertTrue((String)("Can't find message: [text=\"" + message.getText() + "\"; line=\"" + message.getLineNumber() + "\"; start=\"" + message.getOffset() + "\"; end=\"" + end + "\"; type=\"] for " + resource + ".\r\nThe full list of the markers and messages:\r\n" + markersSB + "\r\n" + messagesSB), (boolean)this.contains(allMarkers, message));
                }
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.common.base.test", e.getMessage(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            AsYouTypeValidatorManager.setDisabled((boolean)false);
            if (document != null) {
                manager.disconnect(document);
            }
            if (editorPart != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorPart, false);
            }
            throw throwable;
        }
        AsYouTypeValidatorManager.setDisabled((boolean)false);
        if (document != null) {
            manager.disconnect(document);
        }
        if (editorPart != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorPart, false);
        }
    }

    private boolean contains(IMarker[] markers, IMessage message) throws CoreException {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (this.equaled(marker, message)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean equaled(IMarker marker, IMessage message) throws CoreException {
        String markerText = marker.getAttribute("message", "");
        int markerLine = marker.getAttribute("lineNumber", -1);
        int markerStart = marker.getAttribute("charStart", -1);
        int markerEnd = marker.getAttribute("charEnd", -1);
        String messageText = message.getText();
        int messageLine = message.getLineNumber();
        int messageStart = message.getOffset();
        int messageEnd = messageStart + message.getLength();
        return markerText.equals(messageText) && markerLine == messageLine && markerStart == messageStart && markerEnd == messageEnd;
    }

    public void assertAnnotationIsCreated(IResource resource, String pattern, int ... expectedLines) throws CoreException {
        this.assertAnnotationsEqualToMarkers(resource);
    }

    public void assertAnnotationIsCreated(IResource resource, String message, boolean pattern, int ... expectedLines) throws CoreException {
        this.assertAnnotationsEqualToMarkers(resource);
    }

    public void assertAnnotationIsNotCreated(IResource resource, String message) throws CoreException {
        this.assertAnnotationsEqualToMarkers(resource);
    }

    public void assertAnnotationIsNotCreated(IResource resource, String message, int expectedLine) throws CoreException {
        this.assertAnnotationsEqualToMarkers(resource);
    }

    public void assertAnnotationIsCreatedForGivenPosition(IResource resource, String message, int lineNumber, int startPosition, int endPosition) throws CoreException {
        this.assertAnnotationsEqualToMarkers(resource);
    }
}

