/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.base.test.contentassist;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.text.xml.contentassist.ProposalSorter;
import org.jboss.tools.test.util.JobUtils;

public class CATestUtil {
    public static final long MAX_IDLE = 300000L;
    public static int MAX_CATEGORIES_COUNT = 10;

    public static IContentAssistProcessor getProcessor(ITextViewer viewer, int offset, IContentAssistant ca) {
        try {
            IDocument document = viewer.getDocument();
            String type = TextUtilities.getContentType((IDocument)document, (String)((IContentAssistantExtension)ca).getDocumentPartitioning(), (int)offset, (boolean)true);
            return ca.getContentAssistProcessor(type);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static void delay(long waitTimeMillis) {
        JobUtils.delay((long)waitTimeMillis);
    }

    public static void waitForIdle(long maxIdle) {
        JobUtils.waitForIdle((long)500L, (long)maxIdle);
    }

    public static SourceViewerConfiguration getSourceViewerConfiguration(ITextEditor editor) {
        Class<?> editorClass = editor.getClass();
        while (editorClass != null) {
            try {
                Method m = editorClass.getDeclaredMethod("getSourceViewerConfiguration", new Class[0]);
                if (m != null) {
                    m.setAccessible(true);
                    Object result = m.invoke((Object)editor, new Object[0]);
                    return result instanceof SourceViewerConfiguration ? (SourceViewerConfiguration)result : null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {}
            editorClass = editorClass.getSuperclass();
        }
        return null;
    }

    public static void prepareCAInvokation(IContentAssistant ca, ITextViewer viewer, int offset) {
        if (ca == null || viewer == null) {
            return;
        }
        viewer.getTextWidget().setCaretOffset(offset);
        CATestUtil.waitForIdle(300000L);
        CATestUtil.delay(1000L);
        ca.showPossibleCompletions();
    }

    public static List<ICompletionProposal> collectProposals(IContentAssistant ca, ITextViewer viewer, int offset) {
        CATestUtil.prepareCAInvokation(ca, viewer, offset);
        IContentAssistProcessor p = CATestUtil.getProcessor(viewer, offset, ca);
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < MAX_CATEGORIES_COUNT && p != null) {
            ICompletionProposal[] result = p.computeCompletionProposals(viewer, offset);
            int j = 0;
            while (result != null && j < result.length) {
                res.add(result[j]);
                ++j;
            }
            ++i;
        }
        return ProposalSorter.filterAndSortProposals(res, null, null);
    }

    public static final void closeAllEditors() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getViewReferences()[0].getPart(false);
        page.activate(part);
        page.closeAllEditors(false);
    }
}

