/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.MacroEndDirective;

public class MacroDirective
extends AbstractDirective
implements Comparable {
    private MacroEndDirective endDirective;
    private String name;
    private Item[] relatedItems;
    private String[] attributes;
    private static final char[] descriptorTokens = new char[]{'/', '#', '@', '<', '>'};

    public MacroDirective() {
    }

    public MacroDirective(String contents) {
        this.contents = contents;
    }

    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }

    public boolean isStartItem() {
        return true;
    }

    public void relateItem(Item directive) {
        if (directive instanceof MacroEndDirective) {
            this.endDirective = (MacroEndDirective)directive;
        }
    }

    public boolean relatesToItem(Item directive) {
        return directive instanceof MacroEndDirective;
    }

    public boolean isNestable() {
        return true;
    }

    public MacroEndDirective getEndDirective() {
        return this.endDirective;
    }

    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            ArrayList<MacroEndDirective> l = new ArrayList<MacroEndDirective>();
            if (this.getEndDirective() != null) {
                l.add(this.getEndDirective());
            }
            this.relatedItems = l.toArray(new Item[l.size()]);
        }
        return this.relatedItems;
    }

    public String getTreeImage() {
        return "macro.png";
    }

    public String getTreeDisplay() {
        return this.getSplitValue(1);
    }

    public String[] getAttributes() {
        if (this.attributes == null) {
            ArrayList<String> l = new ArrayList<String>();
            String[] contents = this.splitContents();
            int i = 2;
            while (i < contents.length) {
                String att = contents[i];
                int index = att.indexOf("=");
                if (index < 0) {
                    if ((att = att.trim()).endsWith("]") || att.endsWith(">")) {
                        att = att.substring(0, att.length() - 1);
                    }
                    l.add(att);
                    ++i;
                    continue;
                }
                i += 2;
            }
            this.attributes = l.toArray(new String[l.size()]);
        }
        return this.attributes;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getSplitValue(1);
        }
        return this.name;
    }

    public Item getEndItem() {
        return this.endDirective;
    }

    public char[] getDescriptors() {
        return descriptorTokens;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof MacroDirective) {
            return this.nullToEmpty(this.getName()).compareTo(this.nullToEmpty(((MacroDirective)arg0).getName()));
        }
        return 0;
    }

    private String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    public void addToContext(Map context) {
        int i = 0;
        while (i < this.getAttributes().length) {
            if (context.get(this.getAttributes()[i]) == null) {
                context.put(this.getAttributes()[i], Object.class);
            }
            ++i;
        }
    }

    public void removeFromContext(Map context) {
        int i = 0;
        while (i < this.getAttributes().length) {
            Object obj = context.get(this.getAttributes()[i]);
            if (obj != null && obj.equals(Object.class)) {
                context.remove(this.getAttributes()[i]);
            }
            ++i;
        }
    }
}

