/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;

public class DirectiveRule
extends MultiLineRule {
    protected static final char[] START_SEQUENCES = new char[]{'<', '['};
    protected static Map END_SEQUENCES = new HashMap(START_SEQUENCES.length);
    protected char[] sequence;
    protected boolean nameOnly = false;

    static {
        END_SEQUENCES.put(new Character(START_SEQUENCES[0]), new Character('>'));
        END_SEQUENCES.put(new Character(START_SEQUENCES[1]), new Character(']'));
    }

    public DirectiveRule(String name, IToken token) {
        this(name, token, false);
    }

    public DirectiveRule(String name, IToken token, boolean nameOnly) {
        super("!", "!", token);
        this.sequence = name.toCharArray();
        this.nameOnly = nameOnly;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, int startChar, boolean eofAllowed) {
        int i = 0;
        while (i < this.sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != this.sequence[i]) {
                scanner.unread();
                int j = i;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner, int startChar) {
        int i;
        int c;
        char endChar = ((Character)END_SEQUENCES.get(new Character((char)startChar))).charValue();
        char[][] delimiters = scanner.getLegalLineDelimiters();
        boolean previousWasEscapeCharacter = false;
        Stack<String> keyStack = new Stack<String>();
        int charsRead = 0;
        while ((c = scanner.read()) != -1) {
            ++charsRead;
            if (this.nameOnly) {
                if (c != endChar) {
                    scanner.unread();
                    return false;
                }
                return true;
            }
            if (c == startChar) {
                int cNext = scanner.read();
                if (cNext == -1) break;
                if (cNext == 35 || cNext == 64) {
                    if (keyStack.size() == 0) {
                        break;
                    }
                } else {
                    keyStack.push(new String(new char[]{(char)c}));
                    scanner.unread();
                }
            } else if (c == 34) {
                if (keyStack.size() > 0 && keyStack.peek().equals("\"")) {
                    keyStack.pop();
                } else {
                    keyStack.push("\"");
                }
            } else if (c == 40) {
                if (keyStack.size() <= 0 || !keyStack.peek().equals("\"")) {
                    keyStack.push("(");
                }
            } else if (c == 41) {
                if ((keyStack.size() <= 0 || !keyStack.peek().equals("\"")) && keyStack.size() > 0 && keyStack.peek().equals("(")) {
                    keyStack.pop();
                }
            } else if (c == this.fEscapeCharacter) {
                scanner.read();
                ++charsRead;
            } else if (c == endChar) {
                if (keyStack.size() == 0) {
                    return true;
                }
                if (keyStack.peek().equals(new String(new char[]{(char)startChar}))) {
                    keyStack.pop();
                }
            } else if (this.fBreaksOnEOL) {
                i = 0;
                while (i < delimiters.length) {
                    if (!(c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true) || this.fEscapeContinuesLine && previousWasEscapeCharacter)) {
                        return true;
                    }
                    ++i;
                }
            }
            boolean bl = previousWasEscapeCharacter = c == this.fEscapeCharacter;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        i = 0;
        while (i < charsRead) {
            scanner.unread();
            ++i;
        }
        return false;
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            if (this.endSequenceDetected(scanner)) {
                return this.fToken;
            }
        } else {
            int c = scanner.read();
            if (c == START_SEQUENCES[0] || c == START_SEQUENCES[1]) {
                int c2 = scanner.read();
                if (c2 == this.getIdentifierChar() && this.sequenceDetected(scanner, c, false) && this.endSequenceDetected(scanner, c)) {
                    return this.fToken;
                }
                scanner.unread();
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected char getIdentifierChar() {
        return '#';
    }
}

