/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.jboss.ide.eclipse.freemarker.editor.ColorManager;

public class ContentScanner
implements ITokenScanner {
    private IDocument document;
    private int offset;
    private int length;
    private int endOffset;
    private Stack stack = new Stack();
    private IToken defaultToken;
    private int tokenOffset;
    private int tokenLength;
    private Stack stringTypes = new Stack();
    private List tokens = new ArrayList();
    private int currentOffset;
    private static String TYPE_UNKNOWN = "UNKNOWN";
    private static String TYPE_INTERPOLATION = "INTERPOLATION";
    private static String TYPE_DIRECTIVE = "DIRECTIVE";
    private static String TYPE_STRING = "STRING";
    private static IToken STRING_TOKEN;
    private static IToken INTERPOLATION_TOKEN;
    private static IToken DIRECTIVE_TOKEN;

    public ContentScanner(IToken defaultToken, ColorManager colorManager) {
        this.defaultToken = defaultToken;
        STRING_TOKEN = new Token((Object)new TextAttribute(colorManager.getColor("color.string")));
        INTERPOLATION_TOKEN = new Token((Object)new TextAttribute(colorManager.getColor("color.interpolation")));
        DIRECTIVE_TOKEN = new Token((Object)new TextAttribute(colorManager.getColor("color.directive")));
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.offset = offset;
        this.currentOffset = offset;
        this.length = length;
        this.endOffset = offset + length;
        this.stack.clear();
        this.stringTypes.clear();
        this.tokens.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IToken nextToken() {
        int offsetStart = this.currentOffset;
        int i = this.currentOffset;
        char directiveTypeChar = '\u0000';
        boolean escape = false;
        boolean doEscape = false;
        try {
            char c = this.document.getChar(i);
            char cNext = '\u0000';
            if (this.document.getLength() > i + 2) {
                cNext = this.document.getChar(i + 1);
            }
            if (i >= this.endOffset) {
                return Token.EOF;
            }
            while (i < this.endOffset) {
                block24: {
                    block31: {
                        String type;
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                doEscape = false;
                                                if (escape) break block24;
                                                type = this.peek();
                                                if (c != '\\') break block25;
                                                if (type.equals(TYPE_STRING)) {
                                                    doEscape = true;
                                                }
                                                break block24;
                                            }
                                            if (c != '\"' && c != '\'') break block26;
                                            if (type.equals(TYPE_STRING)) {
                                                if (this.stringTypes.size() > 0 && c == ((Character)this.stringTypes.peek()).charValue()) {
                                                    this.tokenOffset = offsetStart;
                                                    this.tokenLength = i - offsetStart + 1;
                                                    this.currentOffset = i + 1;
                                                    this.pop();
                                                    return STRING_TOKEN;
                                                }
                                                break block24;
                                            } else {
                                                if (i != offsetStart) {
                                                    this.tokenOffset = offsetStart;
                                                    this.tokenLength = i - offsetStart;
                                                    this.currentOffset = i;
                                                    return this.getToken(type);
                                                }
                                                this.push(TYPE_STRING);
                                                this.stringTypes.push(new Character(c));
                                            }
                                            break block24;
                                        }
                                        if (c != '$') break block27;
                                        if (cNext == '{') {
                                            this.tokenOffset = offsetStart;
                                            this.tokenLength = i - offsetStart;
                                            this.currentOffset = i;
                                            if (i != offsetStart) {
                                                return this.getToken(type);
                                            }
                                            this.push(TYPE_INTERPOLATION);
                                        }
                                        break block24;
                                    }
                                    if (c != '}') break block28;
                                    if (type.equals(TYPE_INTERPOLATION)) {
                                        this.tokenOffset = offsetStart;
                                        this.tokenLength = i - offsetStart + 1;
                                        this.currentOffset = i + 1;
                                        this.pop();
                                        return INTERPOLATION_TOKEN;
                                    }
                                    break block24;
                                }
                                if (c != '(') break block29;
                                if (type.equals(TYPE_INTERPOLATION)) {
                                    this.push("(");
                                }
                                break block24;
                            }
                            if (c != ')') break block30;
                            if (type.equals("(")) {
                                this.pop();
                            }
                            break block24;
                        }
                        if (c != '<' && c != '[' || (this.stack.contains(TYPE_DIRECTIVE) || this.stack.contains(TYPE_INTERPOLATION)) && this.stack.contains(TYPE_STRING)) break block31;
                        if (cNext == '#') {
                            if (i != offsetStart) {
                                this.tokenOffset = offsetStart;
                                this.tokenLength = i - offsetStart - 1;
                                this.currentOffset = i;
                                return this.getToken(type);
                            }
                            directiveTypeChar = c;
                            this.push(TYPE_DIRECTIVE);
                            break block24;
                        } else if (cNext == '@') {
                            if (i != offsetStart) {
                                this.tokenOffset = offsetStart;
                                this.tokenLength = i - offsetStart - 1;
                                this.currentOffset = i;
                                return this.getToken(type);
                            }
                            directiveTypeChar = c;
                            this.push(TYPE_DIRECTIVE);
                        }
                        break block24;
                    }
                    if (!(c != ']' && c != '>' || (this.stack.contains(TYPE_DIRECTIVE) || this.stack.contains(TYPE_INTERPOLATION)) && this.stack.contains(TYPE_STRING) || !(c == ']' && directiveTypeChar == '[' || c == '>' && directiveTypeChar == '<') && directiveTypeChar != '\u0000')) {
                        this.tokenOffset = offsetStart;
                        this.tokenLength = i - offsetStart + 1;
                        this.currentOffset = i + 1;
                        if (directiveTypeChar != '\u0000') {
                            this.pop();
                            return DIRECTIVE_TOKEN;
                        }
                        return this.defaultToken;
                    }
                }
                c = this.document.getChar(++i);
                cNext = '\u0000';
                if (this.document.getLength() > i + 2) {
                    cNext = this.document.getChar(i + 1);
                }
                escape = doEscape;
            }
        }
        catch (BadLocationException badLocationException) {
            this.currentOffset = i;
            this.tokenOffset = offsetStart;
            this.tokenLength = this.endOffset - this.tokenOffset;
            if (this.tokenLength > 0) {
                return this.defaultToken;
            }
            return Token.EOF;
        }
        this.currentOffset = i + 1;
        this.tokenOffset = offsetStart;
        this.tokenLength = this.endOffset - this.tokenOffset;
        return this.getToken(this.peek());
    }

    private String peek() {
        if (this.stack.size() > 0) {
            return (String)this.stack.peek();
        }
        return TYPE_UNKNOWN;
    }

    private void push(String s) {
        this.stack.push(s);
    }

    private String pop() {
        if (this.stack.size() > 0) {
            return (String)this.stack.pop();
        }
        return TYPE_UNKNOWN;
    }

    private IToken getToken(String type) {
        if (type.equals(TYPE_DIRECTIVE)) {
            return DIRECTIVE_TOKEN;
        }
        if (type.equals(TYPE_INTERPOLATION) || type.equals("(")) {
            return INTERPOLATION_TOKEN;
        }
        if (type.equals(TYPE_STRING)) {
            return STRING_TOKEN;
        }
        return this.defaultToken;
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }
}

