/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;

public class TraverseUtil {
    public static TextPart getNextTextPartInSameNode(TextPart textPart) {
        DiagramNodePart nodePart = (DiagramNodePart)textPart.nearest(DiagramNodePart.class);
        List textParts = nodePart.getContainedTextParts();
        int index = textParts.indexOf(textPart);
        int i = index + 1;
        while (i < textParts.size()) {
            TextPart nextSibling = (TextPart)textParts.get(i);
            if (nextSibling.isEditable()) {
                return nextSibling;
            }
            ++i;
        }
        return null;
    }

    public static List<DiagramNodePart> getSortedNodeParts(SapphireDiagramEditorPagePart diagramPagePart) {
        ArrayList<DiagramNodePart> nodeParts = new ArrayList<DiagramNodePart>();
        nodeParts.addAll(diagramPagePart.getNodes());
        Collections.sort(nodeParts, new Comparator<DiagramNodePart>(){

            @Override
            public int compare(DiagramNodePart node1, DiagramNodePart node2) {
                DiagramNodeBounds bounds1 = node1.getNodeBounds();
                DiagramNodeBounds bounds2 = node2.getNodeBounds();
                if (bounds1.getY() < bounds2.getY()) {
                    return -1;
                }
                if (bounds1.getY() == bounds2.getY()) {
                    return bounds1.getX() < bounds2.getX() ? -1 : (bounds1.getX() == bounds2.getX() ? 0 : 1);
                }
                return 1;
            }
        });
        return nodeParts;
    }

    public static TextPart getTextPartInNextNode(List<DiagramNodePart> sortedNodes, DiagramNodePart thisNode) {
        int index = sortedNodes.indexOf(thisNode);
        int i = index + 1;
        while (i < sortedNodes.size()) {
            DiagramNodePart nextNode = sortedNodes.get(i);
            List textParts = nextNode.getContainedTextParts();
            for (TextPart textPart : textParts) {
                if (!textPart.isEditable()) continue;
                return textPart;
            }
            ++i;
        }
        return null;
    }
}

