/*
 * Decompiled with CFR 0.152.
 */
package tern.utils;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.HashMap;
import java.util.List;
import tern.TernException;
import tern.TernProject;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.server.ITernPlugin;
import tern.server.ModuleType;
import tern.server.TernModuleConfigurable;
import tern.utils.StringUtils;

public class TernModuleHelper {
    public static void groupByType(ITernModule[] modules, List<ITernModule> groupedModules) {
        HashMap<String, TernModuleConfigurable> wrappers = null;
        ITernModule[] iTernModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ITernModule module = iTernModuleArray[n2];
            if (!TernModuleHelper.isConfigurableModule(module)) {
                groupedModules.add(module);
            } else {
                TernModuleConfigurable wrapper;
                if (wrappers == null) {
                    wrappers = new HashMap<String, TernModuleConfigurable>();
                }
                if ((wrapper = (TernModuleConfigurable)wrappers.get(module.getType())) == null) {
                    wrapper = new TernModuleConfigurable(module);
                    wrappers.put(module.getType(), wrapper);
                    groupedModules.add(wrapper);
                } else {
                    wrapper.addModule(module);
                }
            }
            ++n2;
        }
    }

    public static boolean isConfigurableModule(ITernModule module) {
        TernModuleMetadata metadata = module.getMetadata();
        return !StringUtils.isEmpty(module.getVersion()) || metadata != null && metadata.getOptions().size() > 0;
    }

    public static void update(List<ITernDef> defs, List<ITernPlugin> plugins, ITernModule module) {
        TernModuleHelper.update(defs, plugins, null, module);
    }

    private static void update(List<ITernDef> defs, List<ITernPlugin> plugins, JsonObject options, ITernModule module) {
        switch (module.getModuleType()) {
            case Def: {
                defs.add((ITernDef)module);
                break;
            }
            case Plugin: {
                plugins.add((ITernPlugin)module);
                break;
            }
            case Configurable: {
                ITernModule wrappedModule = ((ITernModuleConfigurable)module).getWrappedModule();
                JsonObject wrappedOptions = ((ITernModuleConfigurable)module).getOptions();
                TernModuleHelper.update(defs, plugins, wrappedOptions, wrappedModule);
            }
        }
    }

    public static void update(ITernModule module, TernProject<?> ternProject) {
        TernModuleHelper.update(module, null, ternProject);
    }

    public static void update(ITernModule module, JsonObject options, TernProject<?> ternProject) {
        switch (module.getModuleType()) {
            case Def: {
                ternProject.addLib((ITernDef)module);
                break;
            }
            case Plugin: {
                ternProject.addPlugin((ITernPlugin)module, options);
                break;
            }
            case Configurable: {
                ITernModule wrappedModule = ((ITernModuleConfigurable)module).getWrappedModule();
                JsonObject wrappedOptions = ((ITernModuleConfigurable)module).getOptions();
                TernModuleHelper.update(wrappedModule, wrappedOptions, ternProject);
            }
        }
    }

    public static ITernModuleConfigurable findConfigurable(ITernModule module, JsonValue options, List<ITernModule> allModules) throws TernException {
        String version = module.getVersion();
        for (ITernModule f : allModules) {
            if (f.getModuleType() != ModuleType.Configurable || f.getType() != module.getType()) continue;
            if (!StringUtils.isEmpty(version)) {
                ((ITernModuleConfigurable)f).setVersion(version);
            }
            if (options instanceof JsonObject) {
                ((ITernModuleConfigurable)f).setOptions(new JsonObject((JsonObject)options));
            }
            return (ITernModuleConfigurable)f;
        }
        return null;
    }

    public static boolean hasOptions(ITernModule module) {
        if (module == null || module.getModuleType() != ModuleType.Configurable) {
            return false;
        }
        ITernModuleConfigurable f = (ITernModuleConfigurable)module;
        return f.getOptions() != null && f.getOptions().size() > 0;
    }
}

