/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import com.eclipsesource.json.JsonObject;
import tern.server.IInterceptor;
import tern.server.ITernServer;
import tern.server.protocol.TernDoc;

public class LoggingInterceptor
implements IInterceptor {
    private static final IInterceptor INSTANCE = new LoggingInterceptor();

    public static IInterceptor getInstance() {
        return INSTANCE;
    }

    @Override
    public void handleRequest(TernDoc request, ITernServer server, String methodName) {
        this.outPrintln("-----------------------------------");
        this.outPrintln("Tern request#" + methodName + ": ");
        this.outPrintln(request.toString());
    }

    @Override
    public void handleResponse(JsonObject response, ITernServer server, String methodName, long ellapsedTime) {
        this.outPrintln("");
        this.outPrintln("Tern response#" + methodName + " with " + ellapsedTime + "ms: ");
        this.outPrintln(response.toString());
        this.outPrintln("-----------------------------------");
    }

    @Override
    public void handleError(Throwable error, ITernServer server, String methodName, long ellapsedTime) {
        this.errPrintln("");
        this.errPrintln("Tern error#" + methodName + " with " + ellapsedTime + "ms: ");
        this.printStackTrace(error);
        this.errPrintln("-----------------------------------");
    }

    protected void outPrintln(String line) {
        System.out.println(line);
    }

    protected void errPrintln(String line) {
        System.err.println(line);
    }

    protected void printStackTrace(Throwable error) {
        error.printStackTrace(System.err);
    }
}

