/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import java.util.ArrayList;
import java.util.List;
import tern.TernFileManager;
import tern.TernProject;
import tern.server.ITernServer;
import tern.server.ITernServerListener;
import tern.server.TernServerAdapter;
import tern.server.protocol.completions.ITernCompletionCollector;

public abstract class AbstractTernServer
implements ITernServer {
    private final TernProject<?> project;
    private final List<ITernServerListener> listeners;
    private boolean dataAsJsonString;
    private boolean dispose;

    public AbstractTernServer(TernProject<?> project) {
        this.project = project;
        this.listeners = new ArrayList<ITernServerListener>();
        final TernFileManager<?> fileManager = this.getFileManager();
        if (fileManager != null) {
            this.addServerListener(new TernServerAdapter(){

                @Override
                public void onStop(ITernServer server) {
                    fileManager.cleanIndexedFiles();
                }
            });
        }
    }

    @Override
    public boolean isDataAsJsonString() {
        return this.dataAsJsonString;
    }

    @Override
    public void setDataAsJsonString(boolean dataAsJsonString) {
        this.dataAsJsonString = dataAsJsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerListener(ITernServerListener listener) {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStartServer() {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            for (ITernServerListener listener : this.listeners) {
                listener.onStart(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndServer() {
        List<ITernServerListener> list = this.listeners;
        synchronized (list) {
            for (ITernServerListener listener : this.listeners) {
                listener.onStop(this);
            }
        }
    }

    @Override
    public final void dispose() {
        if (!this.isDisposed()) {
            this.dispose = true;
            this.doDispose();
            this.fireEndServer();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.dispose;
    }

    protected abstract void doDispose();

    protected void addProposal(Object completion, int pos, ITernCompletionCollector collector) {
        String name = this.getText(completion, "name");
        String type = this.getText(completion, "type");
        String origin = this.getText(completion, "origin");
        String doc = this.getText(completion, "doc");
        collector.addProposal(name, type, origin, doc, pos, completion, this);
    }

    public abstract String getText(Object var1);

    @Override
    public String getText(Object value, String name) {
        return this.getText(this.getValue(value, name));
    }

    public abstract Object getValue(Object var1, String var2);

    @Override
    public TernFileManager<?> getFileManager() {
        if (this.project != null) {
            return this.project.getFileManager();
        }
        return null;
    }

    public TernProject<?> getProject() {
        return this.project;
    }
}

