/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.angular.AngularType;
import tern.angular.modules.DirectiveHelper;
import tern.angular.modules.DirectiveParameter;
import tern.angular.modules.DirectiveValue;
import tern.angular.modules.Module;
import tern.angular.modules.Restriction;
import tern.utils.StringUtils;

public class Directive {
    private final String name;
    private final AngularType type;
    private final String url;
    private final String restrict;
    private final Module module;
    private final Collection<String> tagNames;
    private String description;
    private final DirectiveValue directiveValue;
    private Map<String, DirectiveParameter> parameters;
    private final boolean custom;

    public Directive(String name, AngularType type, String url, Collection<String> tagNames, String restrict, DirectiveValue directiveValue, Module module) {
        this(name, type, url, tagNames, restrict, directiveValue, module, true);
    }

    public Directive(String name, AngularType type, String url, Collection<String> tagNames, String restrict, DirectiveValue directiveValue, Module module, boolean custom) {
        this.name = name;
        this.type = type;
        this.url = url;
        this.restrict = StringUtils.isEmpty(restrict) ? Restriction.A.name() : restrict;
        this.directiveValue = directiveValue;
        this.module = module;
        this.tagNames = tagNames;
        if (module != null) {
            module.addDirective(this);
        }
        this.custom = custom;
    }

    public String getName() {
        return this.name;
    }

    public AngularType getType() {
        return this.type;
    }

    public Collection<String> getTagNames() {
        return this.tagNames;
    }

    public List<String> getDirectiveNames() {
        return DirectiveHelper.getDirectiveNames(this.name);
    }

    public Module getModule() {
        return this.module;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHTMLDescription() {
        StringBuilder info = new StringBuilder("");
        info.append("<b>");
        info.append(this.getName());
        info.append("</b>");
        info.append(" directive in module ");
        info.append("<b>");
        info.append(this.getModule().getName());
        info.append("</b>");
        if (!StringUtils.isEmpty(this.description)) {
            info.append("<br/>");
            info.append("<br/>");
            info.append(this.description);
        }
        if (!StringUtils.isEmpty(this.restrict)) {
            info.append("<br/>");
            info.append("<br/>");
            info.append("<b>restrict</b> ");
            info.append(this.restrict);
        }
        if (this.tagNames != null && this.tagNames.size() > 0) {
            info.append("<br/>");
            info.append("<br/>");
            info.append("<b>tags:</b> ");
            info.append(Arrays.toString(this.tagNames.toArray()));
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            info.append("<br/>");
            info.append("<br/>");
            info.append("<b>parameters:</b> ");
            info.append(Arrays.toString(this.parameters.keySet().toArray()));
        }
        if (!StringUtils.isEmpty(this.url)) {
            info.append("<br/>");
            info.append("<br/>");
            info.append("<b>@see</b> ");
            info.append(this.url);
        }
        return info.toString();
    }

    public DirectiveValue getDirectiveValue() {
        return this.directiveValue;
    }

    public Collection<DirectiveParameter> getParameters() {
        if (this.parameters != null) {
            return this.parameters.values();
        }
        return Collections.emptyList();
    }

    public void addParameter(DirectiveParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, DirectiveParameter>();
        }
        this.parameters.put(parameter.getName(), parameter);
    }

    public boolean hasParameters() {
        if (this.parameters != null) {
            return !this.parameters.isEmpty();
        }
        return false;
    }

    public DirectiveParameter getParameter(String name) {
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        return null;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public boolean isMatch(Restriction restriction) {
        if (restriction == null) {
            return true;
        }
        return restriction.isMatch(this.restrict);
    }
}

