/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.modules;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tern.angular.modules.Directive;
import tern.angular.modules.IAngularModulesRegistry;
import tern.angular.modules.IDirectiveCollector;
import tern.angular.modules.IDirectiveSyntax;
import tern.angular.modules.Module;
import tern.angular.modules.Restriction;

public abstract class AbstractAngularModulesRegistry
implements IAngularModulesRegistry {
    private final Map<String, Module> modules = new HashMap<String, Module>();

    public void addModule(Module module) {
        this.modules.put(module.getName(), module);
    }

    public Collection<Module> getModules() {
        return this.modules.values();
    }

    @Override
    public Module getModule(String name) {
        return this.modules.get(name);
    }

    @Override
    public void collectDirectives(String tagName, String directiveName, IDirectiveSyntax syntax, List<Directive> existingDirectives, Restriction restriction, IDirectiveCollector collector) {
        Collection<Module> modules = this.getModules();
        for (Module module : modules) {
            module.collectDirectives(tagName, directiveName, syntax, existingDirectives, restriction, collector);
        }
    }

    @Override
    public Directive getDirective(String tagName, String name, Restriction restriction) {
        Collection<Module> modules = this.getModules();
        for (Module module : modules) {
            Directive directive = module.getDirective(tagName, name, restriction);
            if (directive == null) continue;
            return directive;
        }
        return null;
    }

    public void clear() {
        this.modules.clear();
    }
}

