/*
 * Decompiled with CFR 0.152.
 */
package tern;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import tern.DirtyableJsonArray;
import tern.DirtyableJsonObject;
import tern.TernFileManager;
import tern.server.ITernDef;
import tern.server.ITernPlugin;
import tern.server.protocol.JsonHelper;
import tern.utils.IOUtils;

public class TernProject<T>
extends DirtyableJsonObject {
    private static final long serialVersionUID = 1L;
    public static final String TERN_PROJECT = ".tern-project";
    private static final String PLUGINS_FIELD_NAME = "plugins";
    private static final String LIBS_FIELD_NAME = "libs";
    private final File projectDir;
    private DirtyableJsonArray patterns;
    private boolean dirty;
    private TernFileManager<T> fileManager;

    public TernProject(File projectDir) {
        super(null);
        this.projectDir = projectDir;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public void addLib(ITernDef lib) {
        this.addLib(lib.getName());
    }

    public void addLib(String lib) {
        if (!this.hasLib(lib)) {
            this.getLibs().add(lib);
        }
    }

    public boolean hasLib(String lib) {
        JsonArray libs = this.getLibs();
        if (libs != null) {
            for (JsonValue l : libs) {
                if (!l.isString() || !l.asString().equals(lib)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLib(ITernDef lib) {
        return this.hasLib(lib.getName());
    }

    public JsonArray getLibs() {
        JsonArray libs = (JsonArray)super.get(LIBS_FIELD_NAME);
        if (libs == null) {
            libs = new DirtyableJsonArray(this);
            this.add(LIBS_FIELD_NAME, (JsonValue)libs);
        }
        return libs;
    }

    public void addPlugin(ITernPlugin plugin) {
        this.addPlugin(plugin, null);
    }

    public void addPlugin(ITernPlugin plugin, JsonObject options) {
        JsonObject plugins = this.getPlugins();
        if (options == null) {
            options = new JsonObject();
        }
        if (!this.hasPlugin(plugin)) {
            plugins.add(plugin.getName(), (JsonValue)options);
        } else if (!JsonHelper.isSameJson(plugins.get(plugin.getName()), options)) {
            plugins.set(plugin.getName(), (JsonValue)options);
        }
    }

    public boolean hasPlugin(ITernPlugin plugin) {
        JsonObject plugins = (JsonObject)super.get(PLUGINS_FIELD_NAME);
        return plugins == null ? false : plugins.get(plugin.getName()) != null;
    }

    public JsonObject getPlugins() {
        JsonObject plugins = (JsonObject)super.get(PLUGINS_FIELD_NAME);
        if (plugins == null) {
            plugins = new DirtyableJsonObject(this);
            this.add(PLUGINS_FIELD_NAME, (JsonValue)plugins);
        }
        return plugins;
    }

    public void addLoadEagerlyPattern(String pattern) {
        if (this.patterns == null) {
            this.patterns = new DirtyableJsonArray(this);
            this.add("loadEagerly", (JsonValue)this.patterns);
        }
        this.patterns.add(pattern);
    }

    public void save() throws IOException {
        this.projectDir.mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(this.projectDir, TERN_PROJECT));
            super.writeTo((Writer)writer);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                IOUtils.closeQuietly(writer);
            }
            throw throwable;
        }
        if (writer != null) {
            IOUtils.closeQuietly(writer);
        }
        this.dirty = false;
    }

    public void saveIfNeeded() throws IOException {
        if (this.isDirty()) {
            this.save();
        }
    }

    public void load() throws IOException {
        File file = new File(this.projectDir, TERN_PROJECT);
        if (file.exists()) {
            try {
                JsonHelper.readFrom(new FileReader(file), this);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        this.dirty = false;
    }

    public void setFileManager(TernFileManager<T> fileManager) {
        this.fileManager = fileManager;
    }

    public TernFileManager<T> getFileManager() {
        return this.fileManager;
    }

    public void clearLibs() {
        this.remove(LIBS_FIELD_NAME);
    }

    public void clearPlugins() {
        this.remove(PLUGINS_FIELD_NAME);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

