/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.jmx.ui.ConnectionWizardPage;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.Messages;

public class UIExtensionManager {
    private static final String CONNECTION_UI_EXT_PT = "org.jboss.tools.jmx.ui.providerUI";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ICON = "icon";
    private static final String CLASS = "class";
    private static final String EDITABLE = "editable";
    private static HashMap<String, ConnectionProviderUI> connectionUIElements;
    private static HashMap<String, ConnectionCategoryUI> connectionCategoryUIElements;

    private static void ensureLoaded() {
        if (connectionUIElements == null) {
            UIExtensionManager.loadConnectionUI();
            UIExtensionManager.loadConnectionCategoryUI();
        }
    }

    public static HashMap<String, ConnectionProviderUI> getConnectionUIElements() {
        UIExtensionManager.ensureLoaded();
        return connectionUIElements;
    }

    public static ConnectionProviderUI getConnectionProviderUI(String id) {
        UIExtensionManager.ensureLoaded();
        return connectionUIElements.get(id);
    }

    public static ConnectionCategoryUI getConnectionCategoryUI(String id) {
        UIExtensionManager.ensureLoaded();
        return connectionCategoryUIElements.get(id);
    }

    private static void loadConnectionUI() {
        HashMap<String, ConnectionProviderUI> map = new HashMap<String, ConnectionProviderUI>();
        IExtension[] extensions = UIExtensionManager.findExtension(CONNECTION_UI_EXT_PT);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("providerUI")) {
                    try {
                        ConnectionProviderUI pUI = new ConnectionProviderUI(elements[j]);
                        map.put(pUI.getId(), pUI);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                }
                ++j;
            }
            ++i;
        }
        connectionUIElements = map;
    }

    private static void loadConnectionCategoryUI() {
        HashMap<String, ConnectionCategoryUI> map = new HashMap<String, ConnectionCategoryUI>();
        IExtension[] extensions = UIExtensionManager.findExtension(CONNECTION_UI_EXT_PT);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[i].getName().equals("providerCategoryUI")) {
                    try {
                        ConnectionCategoryUI pUI = new ConnectionCategoryUI(elements[j]);
                        map.put(pUI.getId(), pUI);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                }
                ++j;
            }
            ++i;
        }
        connectionCategoryUIElements = map;
    }

    public static IWizardPage[] getNewConnectionWizardPages(String typeName) {
        IWizardPage[] pages;
        ConnectionProviderUI ui = connectionUIElements.get(typeName);
        if (ui != null && (pages = ui.createPages()) != null) {
            return pages;
        }
        return new IWizardPage[0];
    }

    private static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static class ConnectionCategoryUI {
        String id;
        String name;
        String icon;
        ImageDescriptor imageDescriptor;

        public ConnectionCategoryUI(IConfigurationElement element) {
            this.id = element.getAttribute(UIExtensionManager.ID);
            this.name = element.getAttribute(UIExtensionManager.NAME);
            this.icon = element.getAttribute(UIExtensionManager.ICON);
            String pluginName = element.getDeclaringExtension().getContributor().getName();
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginName, (String)this.icon);
            if (this.imageDescriptor == null) {
                Status s = new Status(2, "org.jboss.tools.jmx.ui", NLS.bind((String)Messages.JMXUIImageDescriptorNotFound, (Object)this.icon, (Object)pluginName));
                JMXUIActivator.getDefault();
                JMXUIActivator.log((IStatus)s);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.imageDescriptor;
        }
    }

    public static class ConnectionProviderUI
    extends ConnectionCategoryUI {
        String id;
        String name;
        String icon;
        boolean editable;
        IConfigurationElement[] wizardPages;
        ImageDescriptor imageDescriptor;

        public ConnectionProviderUI(IConfigurationElement element) {
            super(element);
            this.editable = Boolean.parseBoolean(element.getAttribute(UIExtensionManager.EDITABLE));
            this.wizardPages = element.getChildren();
        }

        public boolean isEditable() {
            return this.editable;
        }

        public ConnectionWizardPage[] createPages() {
            ArrayList<ConnectionWizardPage> list = new ArrayList<ConnectionWizardPage>();
            int i = 0;
            while (i < this.wizardPages.length) {
                try {
                    ConnectionWizardPage wp = (ConnectionWizardPage)this.wizardPages[i].createExecutableExtension(UIExtensionManager.CLASS);
                    list.add(wp);
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
                ++i;
            }
            return list.toArray(new ConnectionWizardPage[list.size()]);
        }
    }
}

