/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportConflictBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeIds;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WithScope;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.ObjectVector;
import org.eclipse.wst.jsdt.internal.core.Logger;

public abstract class Scope
implements TypeConstants,
TypeIds {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int WITH_SCOPE = 5;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public static final int EQUAL_OR_MORE_SPECIFIC = -1;
    public static final int NOT_RELATED = 0;
    public static final int MORE_GENERIC = 1;
    public int kind;
    public Scope parent;

    public static int compareTypes(TypeBinding left, TypeBinding right) {
        if (left.isCompatibleWith(right)) {
            return -1;
        }
        if (right.isCompatibleWith(left)) {
            return 1;
        }
        return 0;
    }

    public static TypeBinding getBaseType(char[] name) {
        int length = name.length;
        if (length > 2 && length < 8) {
            switch (name[0]) {
                case 'i': {
                    if (length != 3 || name[1] != 'n' || name[2] != 't') break;
                    return TypeBinding.INT;
                }
                case 'v': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                    return TypeBinding.VOID;
                }
                case 'b': {
                    if (length != 7 || name[1] != 'o' || name[2] != 'o' || name[3] != 'l' || name[4] != 'e' || name[5] != 'a' || name[6] != 'n') break;
                    return TypeBinding.BOOLEAN;
                }
                case 'c': {
                    if (length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                    return TypeBinding.CHAR;
                }
                case 'd': {
                    if (length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                    return TypeBinding.DOUBLE;
                }
                case 'f': {
                    if (length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                    return TypeBinding.FLOAT;
                }
                case 'l': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                    return TypeBinding.LONG;
                }
                case 's': {
                    if (length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                    return TypeBinding.SHORT;
                }
            }
        }
        return null;
    }

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public TypeBinding boxing(TypeBinding type) {
        if (type.isBaseType()) {
            return this.environment().computeBoxingType(type);
        }
        return type;
    }

    public ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (CompilationUnitScope)lastScope;
    }

    public final CompilerOptions compilerOptions() {
        return this.compilationUnitScope().environment.globalOptions;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding method, TypeBinding[] arguments, InvocationSite invocationSite) {
        TypeBinding[] parameters = method.parameters;
        if (parameters == arguments) {
            return method;
        }
        int argLength = arguments.length;
        int paramLength = parameters.length;
        boolean isVarArgs = method.isVarargs();
        if (!(argLength == paramLength || isVarArgs && argLength >= paramLength - 1)) {
            return null;
        }
        if (this.parameterCompatibilityLevel(method, arguments) > -1) {
            return method;
        }
        return null;
    }

    public ArrayBinding createArrayType(TypeBinding type, int dimension) {
        if (type.isValidBinding()) {
            return this.environment().createArrayType(type, dimension);
        }
        return new ArrayBinding(type, dimension, this.environment());
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public final MethodScope enclosingMethodScope() {
        scope = this;
        if (!(scope instanceof MethodScope)) ** GOTO lbl6
        return (MethodScope)scope;
lbl-1000:
        // 1 sources

        {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
lbl6:
            // 2 sources

            ** while ((scope = scope.parent) != null)
        }
lbl7:
        // 1 sources

        return null;
    }

    public final ReferenceBinding enclosingReceiverType() {
        Scope scope = this;
        AbstractMethodDeclaration inMethod = null;
        do {
            if (scope instanceof MethodScope) {
                MethodScope methodScope = (MethodScope)scope;
                inMethod = methodScope.referenceMethod();
                if (inMethod.inferredMethod != null && inMethod.inferredMethod.inType != null && inMethod.inferredMethod.inType.binding != null) {
                    return inMethod.inferredMethod.inType.binding;
                }
            } else if (scope instanceof CompilationUnitScope) {
                CompilationUnitScope compilationUnitScope = (CompilationUnitScope)scope;
                int i = 0;
                while (i < compilationUnitScope.referenceContext.numberInferredTypes) {
                    InferredType type = compilationUnitScope.referenceContext.inferredTypes[i];
                    if (type.containsMethod(inMethod)) {
                        return (ReferenceBinding)compilationUnitScope.getTypeOrPackage(type.getName(), 4);
                    }
                    ++i;
                }
            }
            if (!(scope instanceof ClassScope)) continue;
            ClassScope classScope = (ClassScope)scope;
            if (classScope.referenceContext != null) {
                return classScope.referenceContext.binding;
            }
            if (classScope.inferredType == null) continue;
            return classScope.inferredType.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitBinding enclosingCompilationUnit() {
        Scope scope = this;
        do {
            if (!(scope instanceof CompilationUnitScope)) continue;
            return ((CompilationUnitScope)scope).referenceContext.compilationUnitBinding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public ReferenceContext enclosingReferenceContext() {
        Scope current = this;
        while ((current = current.parent) != null) {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (scope instanceof ClassScope) {
                return ((ClassScope)scope).getReferenceBinding();
            }
            if (!(scope instanceof CompilationUnitScope)) continue;
            return ((CompilationUnitScope)scope).referenceContext.compilationUnitBinding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final SourceTypeBinding enclosingTypeBinding() {
        Scope scope = this;
        do {
            if (scope instanceof ClassScope) {
                return ((ClassScope)scope).getReferenceBinding();
            }
            if (!(scope instanceof CompilationUnitScope)) continue;
            return ((CompilationUnitScope)scope).referenceContext.compilationUnitBinding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).environment;
    }

    protected MethodBinding findDefaultAbstractMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding classHierarchyStart, ObjectVector found, MethodBinding concreteMatch) {
        int startFoundSize = found.size;
        MethodBinding[] candidates = null;
        int candidatesCount = 0;
        MethodBinding problemMethod = null;
        int foundSize = found.size;
        if (foundSize > startFoundSize) {
            int i = startFoundSize;
            while (i < foundSize) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                if (compatibleMethod != null) {
                    if (compatibleMethod.isValidBinding()) {
                        if (candidatesCount == 0) {
                            candidates = new MethodBinding[foundSize - startFoundSize + 1];
                            if (concreteMatch != null) {
                                candidates[candidatesCount++] = concreteMatch;
                            }
                        }
                        candidates[candidatesCount++] = compatibleMethod;
                    } else if (problemMethod == null) {
                        problemMethod = compatibleMethod;
                    }
                }
                ++i;
            }
        }
        if (candidatesCount < 2) {
            if (concreteMatch == null) {
                if (candidatesCount == 0) {
                    return problemMethod;
                }
                concreteMatch = candidates != null ? candidates[0] : null;
            }
            return concreteMatch;
        }
        if (this.compilerOptions().complianceLevel >= 0x300000L) {
            return this.mostSpecificMethodBinding(candidates, candidatesCount, argumentTypes, invocationSite, receiverType);
        }
        return null;
    }

    public ReferenceBinding findDirectMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x10000L) != 0L) {
            return null;
        }
        ReferenceBinding enclosingReceiverType = this.enclosingReceiverType();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingReceiverType == null ? memberType.canBeSeenBy(this.getCurrentPackage()) : memberType.canBeSeenBy(enclosingType, enclosingReceiverType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(typeName, memberType, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        MethodBinding exactMethod;
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        MethodBinding methodBinding = exactMethod = receiverType != null ? receiverType.getExactMethod(selector, argumentTypes, unitScope) : unitScope.referenceContext.compilationUnitBinding.getExactMethod(selector, argumentTypes, unitScope);
        if (exactMethod != null && !exactMethod.isBridge() && exactMethod.canBeSeenBy(receiverType, invocationSite, this)) {
            return exactMethod;
        }
        return null;
    }

    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReference(receiverType);
        switch (receiverType.kind()) {
            case 132: {
                return null;
            }
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        if (!currentType.canBeSeenBy(this)) {
            return new ProblemFieldBinding(currentType, fieldName, 8);
        }
        FieldBinding field = currentType.getField(fieldName, needResolve);
        if (field != null) {
            if (invocationSite == null ? field.canBeSeenBy(this.getCurrentPackage()) : field.canBeSeenBy(currentType, invocationSite, this)) {
                return field;
            }
            return new ProblemFieldBinding(field, field.declaringClass, fieldName, 2);
        }
        FieldBinding visibleField = null;
        boolean keepLooking = true;
        FieldBinding notVisibleField = null;
        HashSet<ReferenceBinding> checkedParents = new HashSet<ReferenceBinding>();
        while (keepLooking) {
            if ((currentType = currentType.getSuperBinding()) == null || checkedParents.contains(currentType)) break;
            checkedParents.add(currentType);
            unitScope.recordTypeReference(currentType);
            field = currentType.getField(fieldName, needResolve);
            if (field == null) continue;
            keepLooking = false;
            if (field.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visibleField == null) {
                    visibleField = field;
                    continue;
                }
                return new ProblemFieldBinding(visibleField, visibleField.declaringClass, fieldName, 3);
            }
            if (notVisibleField != null) continue;
            notVisibleField = field;
        }
        if (visibleField != null) {
            return visibleField;
        }
        if (notVisibleField != null) {
            return new ProblemFieldBinding(notVisibleField, currentType, fieldName, 2);
        }
        return null;
    }

    public ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x10000L) != 0L) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.enclosingSourceType();
        PackageBinding currentPackage = this.getCurrentPackage();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingSourceType == null ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(typeName, memberType, 2);
        }
        ReferenceBinding currentType = enclosingType;
        Object interfacesToVisit = null;
        int nextPosition = 0;
        ReferenceBinding visibleMemberType = null;
        boolean keepLooking = true;
        ReferenceBinding notVisible = null;
        HashSet<ReferenceBinding> checkedParents = new HashSet<ReferenceBinding>();
        while (keepLooking) {
            ReferenceBinding sourceType = currentType;
            if (sourceType.isHierarchyBeingConnected()) {
                return null;
            }
            ((SourceTypeBinding)sourceType).classScope.connectTypeHierarchy();
            currentType = currentType.getSuperBinding();
            if (currentType == null || checkedParents.contains(currentType)) break;
            checkedParents.add(currentType);
            unitScope.recordReference(currentType, typeName);
            memberType = currentType.getMemberType(typeName);
            if (memberType == null) continue;
            unitScope.recordTypeReference(memberType);
            keepLooking = false;
            if (enclosingSourceType == null ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                if (visibleMemberType == null) {
                    visibleMemberType = memberType;
                    continue;
                }
                return new ProblemReferenceBinding(typeName, visibleMemberType, 3);
            }
            notVisible = memberType;
        }
        if (interfacesToVisit != null) {
            ProblemReferenceBinding ambiguous = null;
            int i = 0;
            while (i < nextPosition) {
                void anInterface = interfacesToVisit[i];
                unitScope.recordReference((ReferenceBinding)anInterface, typeName);
                memberType = anInterface.getMemberType(typeName);
                if (memberType != null) {
                    unitScope.recordTypeReference(memberType);
                    if (visibleMemberType == null) {
                        visibleMemberType = memberType;
                    } else {
                        ambiguous = new ProblemReferenceBinding(typeName, visibleMemberType, 3);
                        break;
                    }
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleMemberType != null) {
            return visibleMemberType;
        }
        if (notVisible != null) {
            return new ProblemReferenceBinding(typeName, notVisible, 2);
        }
        return null;
    }

    public MethodBinding findMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        int candidatesCount;
        MethodBinding[] candidates;
        ReferenceBinding classHierarchyStart;
        long complianceLevel;
        ObjectVector found;
        block40: {
            Binding binding;
            ReferenceBinding currentType = receiverType;
            found = new ObjectVector(3);
            CompilationUnitScope unitScope = this.compilationUnitScope();
            unitScope.recordTypeReferences(argumentTypes);
            if (receiverType == null) {
                MethodBinding methodBinding = unitScope.referenceContext.compilationUnitBinding.getExactMethod(selector, argumentTypes, unitScope);
                if (methodBinding == null) {
                    methodBinding = new ProblemMethodBinding(selector, argumentTypes, 1);
                }
                return methodBinding;
            }
            complianceLevel = this.compilerOptions().complianceLevel;
            boolean isCompliant14 = complianceLevel >= 0x300000L;
            boolean isCompliant15 = complianceLevel >= 0x310000L;
            classHierarchyStart = currentType;
            HashSet<ReferenceBinding> checkedParents = new HashSet<ReferenceBinding>();
            while (currentType != null) {
                if (checkedParents.contains(currentType)) break;
                checkedParents.add(currentType);
                unitScope.recordTypeReference(currentType);
                Object[] currentMethods = currentType.getMethods(selector);
                int currentLength = currentMethods.length;
                if (currentLength > 0) {
                    Object currentMethod;
                    int i;
                    if (isCompliant14 && found.size > 0) {
                        i = 0;
                        int l = currentLength;
                        while (i < l) {
                            currentMethod = currentMethods[i];
                            if (currentMethod != null) {
                                int j = 0;
                                int max = found.size;
                                while (j < max) {
                                    MethodBinding matchingMethod = (MethodBinding)found.elementAt(j);
                                    if (((MethodBinding)currentMethod).areParametersEqual(matchingMethod)) {
                                        if (isCompliant15 && matchingMethod.isBridge() && !((MethodBinding)currentMethod).isBridge()) break;
                                        --currentLength;
                                        currentMethods[i] = null;
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                    if (currentLength > 0) {
                        if (currentMethods.length == currentLength) {
                            found.addAll(currentMethods);
                        } else {
                            i = 0;
                            int max = currentMethods.length;
                            while (i < max) {
                                currentMethod = currentMethods[i];
                                if (currentMethod != null) {
                                    found.add(currentMethod);
                                }
                                ++i;
                            }
                        }
                    }
                }
                currentType = currentType.getSuperBinding();
            }
            if (found.size == 0 && (receiverType == null || receiverType instanceof CompilationUnitBinding) && (binding = this.getTypeOrPackage(selector, 8)) instanceof MethodBinding) {
                ((MethodBinding)binding).ensureBindingsAreComplete();
                found.add(binding);
            }
            int foundSize = found.size;
            candidates = null;
            candidatesCount = 0;
            MethodBinding problemMethod = null;
            if (foundSize > 0) {
                int i = 0;
                while (i < foundSize) {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                    MethodBinding compatibleMethod = methodBinding;
                    if (compatibleMethod != null) {
                        if (compatibleMethod.isValidBinding()) {
                            if (foundSize == 1 && compatibleMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                                return compatibleMethod;
                            }
                            if (candidatesCount == 0) {
                                candidates = new MethodBinding[foundSize];
                            }
                            candidates[candidatesCount++] = compatibleMethod;
                        } else if (problemMethod == null) {
                            problemMethod = compatibleMethod;
                        }
                    }
                    ++i;
                }
            }
            if (candidatesCount != 0) break block40;
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, null);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            if (found.size == 0) {
                return null;
            }
            if (problemMethod != null) {
                return problemMethod;
            }
            int bestArgMatches = -1;
            MethodBinding bestGuess = (MethodBinding)found.elementAt(0);
            int argLength = argumentTypes.length;
            foundSize = found.size;
            int i = 0;
            while (i < foundSize) {
                block41: {
                    int argMatches;
                    MethodBinding methodBinding;
                    block42: {
                        int diff2;
                        methodBinding = (MethodBinding)found.elementAt(i);
                        TypeBinding[] params = methodBinding.parameters;
                        int paramLength = params.length;
                        argMatches = 0;
                        int a = 0;
                        while (a < argLength) {
                            TypeBinding arg = argumentTypes[a];
                            int p = a == 0 ? 0 : a - 1;
                            while (p < paramLength && p < a + 1) {
                                if (params[p] == arg) {
                                    ++argMatches;
                                    break;
                                }
                                ++p;
                            }
                            ++a;
                        }
                        if (argMatches < bestArgMatches) break block41;
                        if (argMatches != bestArgMatches) break block42;
                        int diff1 = paramLength < argLength ? 2 * (argLength - paramLength) : paramLength - argLength;
                        int bestLength = bestGuess.parameters.length;
                        int n = diff2 = bestLength < argLength ? 2 * (argLength - bestLength) : bestLength - argLength;
                        if (diff1 >= diff2) break block41;
                    }
                    bestArgMatches = argMatches;
                    bestGuess = methodBinding;
                }
                ++i;
            }
            return bestGuess;
        }
        int visiblesCount = 0;
        int i = 0;
        while (i < candidatesCount) {
            void methodBinding = candidates[i];
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visiblesCount != i) {
                    candidates[i] = null;
                    candidates[visiblesCount] = methodBinding;
                }
                ++visiblesCount;
            }
            ++i;
        }
        if (visiblesCount == 1) {
            return candidates[0];
        }
        if (visiblesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, found, null);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            return new ProblemMethodBinding(candidates[0], candidates[0].selector, candidates[0].parameters, 2);
        }
        if (complianceLevel <= 0x2F0000L) {
            ReferenceBinding cfr_ignored_0 = candidates[0].declaringClass;
            return this.mostSpecificClassMethodBinding(candidates, visiblesCount, invocationSite);
        }
        MethodBinding mostSpecificMethod = this.mostSpecificMethodBinding(candidates, visiblesCount, argumentTypes, invocationSite, receiverType);
        return mostSpecificMethod;
    }

    public MethodBinding findMethodForArray(ArrayBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        TypeBinding leafType = receiverType.leafComponentType();
        if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(selector, Binding.NO_PARAMETERS, (ReferenceBinding)leafType, 8);
        }
        ReferenceBinding object = this.getJavaLangObject();
        MethodBinding methodBinding = object.getExactMethod(selector, argumentTypes, null);
        if (methodBinding != null) {
            if (argumentTypes == Binding.NO_PARAMETERS) {
                switch (selector[0]) {
                    case 'c': {
                        break;
                    }
                }
            }
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(object, selector, argumentTypes, invocationSite)) == null) {
            return new ProblemMethodBinding(selector, argumentTypes, 1);
        }
        return methodBinding;
    }

    public Binding findBinding(char[] typeName, int mask, PackageBinding declarationPackage, PackageBinding invocationPackage, boolean searchEnvironment) {
        Binding typeBinding;
        this.compilationUnitScope().recordReference(declarationPackage.compoundName, typeName);
        Binding binding = typeBinding = searchEnvironment ? declarationPackage.getBinding(typeName, mask) : declarationPackage.getBinding0(typeName, mask);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isValidBinding() && declarationPackage != invocationPackage && typeBinding instanceof ReferenceBinding && !((ReferenceBinding)typeBinding).canBeSeenBy(invocationPackage)) {
            return new ProblemReferenceBinding(typeName, (ReferenceBinding)typeBinding, 2);
        }
        return typeBinding;
    }

    public ReferenceBinding findType(char[] typeName, PackageBinding declarationPackage, PackageBinding invocationPackage) {
        return (ReferenceBinding)this.findBinding(typeName, 4, declarationPackage, invocationPackage, true);
    }

    public LocalVariableBinding findVariable(char[] variable) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getBinding(char[] name, int mask, InvocationSite invocationSite, boolean needResolve) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            env.missingClassFileLocation = invocationSite;
            Binding binding = null;
            Binding problemField = null;
            if ((mask & 3) != 0) {
                boolean insideStaticContext = false;
                boolean insideConstructorCall = false;
                Binding foundField = null;
                ProblemFieldBinding foundInsideProblem = null;
                Scope scope = this;
                int depth = 0;
                int foundDepth = 0;
                ReferenceBinding foundActualReceiverType = null;
                block39: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            insideStaticContext |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                        }
                        case 1: {
                            LocalVariableBinding variableBinding = scope.findVariable(name);
                            if (variableBinding == null) break;
                            if (foundField != null && foundField.isValidBinding()) {
                                ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                return problemFieldBinding;
                            }
                            if (depth > 0) {
                                invocationSite.setDepth(depth);
                            }
                            LocalVariableBinding localVariableBinding = variableBinding;
                            return localVariableBinding;
                        }
                        case 3: {
                            ClassScope classScope = (ClassScope)scope;
                            ReferenceBinding receiverType = classScope.enclosingReceiverType();
                            FieldBinding fieldBinding = classScope.findField(receiverType, name, invocationSite, needResolve);
                            if (fieldBinding != null) {
                                if (fieldBinding.problemId() == 3) {
                                    if (foundField != null && foundField.problemId() != 2) {
                                        ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                        return problemFieldBinding;
                                    }
                                    FieldBinding fieldBinding2 = fieldBinding;
                                    return fieldBinding2;
                                }
                                ProblemFieldBinding insideProblem = null;
                                if (fieldBinding.isValidBinding()) {
                                    if (!fieldBinding.isStatic()) {
                                        if (insideConstructorCall) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 6);
                                        } else if (insideStaticContext) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 7);
                                        }
                                    }
                                    if (receiverType == fieldBinding.declaringClass || this.compilerOptions().complianceLevel >= 0x300000L) {
                                        if (foundField == null) {
                                            if (depth > 0) {
                                                invocationSite.setDepth(depth);
                                                invocationSite.setActualReceiverType(receiverType);
                                            }
                                            FieldBinding fieldBinding3 = insideProblem == null ? fieldBinding : insideProblem;
                                            return fieldBinding3;
                                        }
                                        if (foundField.isValidBinding() && ((FieldBinding)foundField).declaringClass != fieldBinding.declaringClass) {
                                            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                            return problemFieldBinding;
                                        }
                                    }
                                }
                                if (foundField == null || foundField.problemId() == 2 && fieldBinding.problemId() != 2) {
                                    foundDepth = depth;
                                    foundActualReceiverType = receiverType;
                                    foundInsideProblem = insideProblem;
                                    foundField = fieldBinding;
                                }
                            }
                            ++depth;
                            insideStaticContext |= receiverType.isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 5: {
                            WithScope withScope = (WithScope)scope;
                            ReferenceBinding withType = withScope.referenceContext;
                            FieldBinding fieldBinding = withScope.findField(withType, name, invocationSite, needResolve);
                            if (fieldBinding == null || !fieldBinding.isValidBinding()) break;
                            FieldBinding fieldBinding4 = fieldBinding;
                            return fieldBinding4;
                        }
                        case 4: {
                            MethodBinding methodBinding;
                            LocalVariableBinding variableBinding;
                            if ((mask & 3) > 0) {
                                variableBinding = scope.findVariable(name);
                                if (variableBinding != null) {
                                    if (foundField != null && foundField.isValidBinding()) {
                                        ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                        return problemFieldBinding;
                                    }
                                    if (depth > 0) {
                                        invocationSite.setDepth(depth);
                                    }
                                    LocalVariableBinding localVariableBinding = variableBinding;
                                    return localVariableBinding;
                                }
                                if (unitScope.classScope() == null || (foundField = unitScope.classScope().findField(unitScope.superBinding, name, invocationSite, true)) == null || !foundField.isValidBinding()) break block39;
                                Binding binding2 = foundField;
                                return binding2;
                            }
                            if ((mask & 8) <= 0 || (methodBinding = unitScope.classScope().findMethod(unitScope.superBinding, name, new TypeBinding[0], invocationSite)) == null || !methodBinding.isValidBinding()) break block39;
                            MethodBinding methodBinding2 = methodBinding;
                            return methodBinding2;
                        }
                    }
                    scope = scope.parent;
                }
                if (foundInsideProblem != null) {
                    ProblemFieldBinding problemFieldBinding = foundInsideProblem;
                    return problemFieldBinding;
                }
                if (foundField != null) {
                    if (foundField.isValidBinding()) {
                        if (foundDepth > 0) {
                            invocationSite.setDepth(foundDepth);
                            invocationSite.setActualReceiverType(foundActualReceiverType);
                        }
                        Binding binding3 = foundField;
                        return binding3;
                    }
                    problemField = foundField;
                    foundField = null;
                }
            }
            if ((mask & 8) != 0) {
                Scope scope = this;
                block40: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            binding = methodScope.findMethod(name, Binding.NO_PARAMETERS, true);
                            if (binding == null) break;
                            Binding binding4 = binding;
                            return binding4;
                        }
                        case 5: {
                            WithScope withScope = (WithScope)scope;
                            ReferenceBinding withType = withScope.referenceContext;
                            MethodBinding methBinding = withScope.findExactMethod(withType, name, Binding.NO_PARAMETERS, invocationSite);
                            if (methBinding == null) {
                                methBinding = withScope.findMethod(withType, name, Binding.NO_PARAMETERS, invocationSite);
                            }
                            if (methBinding == null || !methBinding.isValidBinding()) break;
                            MethodBinding methodBinding = methBinding;
                            return methodBinding;
                        }
                        case 3: {
                            ClassScope classScope = (ClassScope)scope;
                            ReferenceBinding receiverType = classScope.enclosingReceiverType();
                            break;
                        }
                        case 4: {
                            CompilationUnitBinding compilationUnitBinding;
                            CompilationUnitScope compilationUnitScope = (CompilationUnitScope)scope;
                            CompilationUnitBinding receiverType = compilationUnitBinding = compilationUnitScope.enclosingCompilationUnit();
                            MethodBinding methodBinding = compilationUnitScope.findExactMethod(receiverType, name, Binding.NO_PARAMETERS, invocationSite);
                            if (methodBinding == null) break block40;
                            MethodBinding methodBinding3 = methodBinding;
                            return methodBinding3;
                        }
                    }
                    scope = scope.parent;
                }
            }
            if ((mask & 4 | 3 | 8) != 0) {
                if ((mask & 4) != 0 && (binding = Scope.getBaseType(name)) != null) {
                    Binding binding5 = binding;
                    return binding5;
                }
                binding = this.getTypeOrPackage(name, mask);
                if (binding.isValidBinding() || mask == 4) {
                    Binding binding6 = binding;
                    return binding6;
                }
            } else if ((mask & 0x4000) != 0) {
                unitScope.recordSimpleReference(name);
                binding = env.getTopLevelPackage(name);
                if (binding != null) {
                    Binding binding7 = binding;
                    return binding7;
                }
            }
            if (problemField != null) {
                Binding binding8 = problemField;
                return binding8;
            }
            if (binding != null && binding.problemId() != 1) {
                Binding binding9 = binding;
                return binding9;
            }
            ProblemBinding problemBinding = new ProblemBinding(name, (ReferenceBinding)this.enclosingTypeBinding(), 1);
            return problemBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getLocalBinding(char[] name, int mask, InvocationSite invocationSite, boolean needResolve) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        try {
            MethodBinding methodBinding;
            Binding binding = null;
            Binding problemField = null;
            if ((mask & 3) != 0) {
                boolean insideStaticContext = false;
                boolean insideConstructorCall = false;
                Binding foundField = null;
                ProblemFieldBinding foundInsideProblem = null;
                Scope scope = this;
                int depth = 0;
                int foundDepth = 0;
                ReferenceBinding foundActualReceiverType = null;
                block9: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            insideStaticContext |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                        }
                        case 1: {
                            LocalVariableBinding variableBinding = scope.findVariable(name);
                            if (variableBinding == null) break;
                            if (foundField != null && foundField.isValidBinding()) {
                                return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                            }
                            if (depth <= 0) return variableBinding;
                            invocationSite.setDepth(depth);
                            return variableBinding;
                        }
                        case 3: {
                            ClassScope classScope = (ClassScope)scope;
                            ReferenceBinding receiverType = classScope.enclosingReceiverType();
                            FieldBinding fieldBinding = classScope.findField(receiverType, name, invocationSite, needResolve);
                            if (fieldBinding != null) {
                                if (fieldBinding.problemId() == 3) {
                                    if (foundField == null) return fieldBinding;
                                    if (foundField.problemId() != 2) return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                    return fieldBinding;
                                }
                                ProblemFieldBinding insideProblem = null;
                                if (fieldBinding.isValidBinding()) {
                                    if (!fieldBinding.isStatic()) {
                                        if (insideConstructorCall) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 6);
                                        } else if (insideStaticContext) {
                                            insideProblem = new ProblemFieldBinding(fieldBinding, fieldBinding.declaringClass, name, 7);
                                        }
                                    }
                                    if (receiverType == fieldBinding.declaringClass || this.compilerOptions().complianceLevel >= 0x300000L) {
                                        if (foundField == null) {
                                            FieldBinding fieldBinding2;
                                            if (depth > 0) {
                                                invocationSite.setDepth(depth);
                                                invocationSite.setActualReceiverType(receiverType);
                                            }
                                            if (insideProblem == null) {
                                                fieldBinding2 = fieldBinding;
                                                return fieldBinding2;
                                            }
                                            fieldBinding2 = insideProblem;
                                            return fieldBinding2;
                                        }
                                        if (foundField.isValidBinding() && ((FieldBinding)foundField).declaringClass != fieldBinding.declaringClass) {
                                            return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                        }
                                    }
                                }
                                if (foundField == null || foundField.problemId() == 2 && fieldBinding.problemId() != 2) {
                                    foundDepth = depth;
                                    foundActualReceiverType = receiverType;
                                    foundInsideProblem = insideProblem;
                                    foundField = fieldBinding;
                                }
                            }
                            ++depth;
                            insideStaticContext |= receiverType.isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 5: {
                            WithScope withScope = (WithScope)scope;
                            ReferenceBinding withType = withScope.referenceContext;
                            FieldBinding withBinding = withScope.findField(withType, name, invocationSite, needResolve);
                            if (withBinding == null || !withBinding.isValidBinding()) break;
                            return withBinding;
                        }
                        case 4: {
                            MethodBinding methodBinding2;
                            LocalVariableBinding variableBinding;
                            if ((mask & 3) > 0) {
                                variableBinding = scope.findVariable(name);
                                if (variableBinding != null) {
                                    if (foundField != null && foundField.isValidBinding()) {
                                        return new ProblemFieldBinding((FieldBinding)foundField, ((FieldBinding)foundField).declaringClass, name, 5);
                                    }
                                    if (depth <= 0) return variableBinding;
                                    invocationSite.setDepth(depth);
                                    return variableBinding;
                                }
                                if (unitScope.classScope() == null || (foundField = unitScope.classScope().findField(unitScope.superBinding, name, invocationSite, true)) == null || !foundField.isValidBinding()) break block9;
                                return foundField;
                            }
                            if ((mask & 8) <= 0 || (methodBinding2 = unitScope.classScope().findMethod(unitScope.superBinding, name, new TypeBinding[0], invocationSite)) == null || !methodBinding2.isValidBinding()) break block9;
                            return methodBinding2;
                        }
                    }
                    scope = scope.parent;
                }
                if (foundInsideProblem != null) {
                    return foundInsideProblem;
                }
                if (foundField != null) {
                    if (foundField.isValidBinding()) {
                        if (foundDepth <= 0) return foundField;
                        invocationSite.setDepth(foundDepth);
                        invocationSite.setActualReceiverType(foundActualReceiverType);
                        return foundField;
                    }
                    problemField = foundField;
                    foundField = null;
                }
            }
            if ((mask & 8) != 0 && (methodBinding = this.findMethod(null, name, Binding.NO_PARAMETERS, invocationSite)) != null && methodBinding.isValidBinding()) {
                return methodBinding;
            }
            if (problemField != null) {
                return problemField;
            }
            if (binding == null) return new ProblemBinding(name, (ReferenceBinding)this.enclosingTypeBinding(), 1);
            if (binding.problemId() == 1) return new ProblemBinding(name, (ReferenceBinding)this.enclosingTypeBinding(), 1);
            return binding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public MethodBinding getConstructor(ReferenceBinding receiverType, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            env.missingClassFileLocation = invocationSite;
            unitScope.recordTypeReference(receiverType);
            unitScope.recordTypeReferences(argumentTypes);
            MethodBinding methodBinding = receiverType.getExactConstructor(argumentTypes);
            if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            MethodBinding[] methods = receiverType.sourceName != null ? receiverType.getMethods(receiverType.sourceName) : null;
            MethodBinding constructor = null;
            if (methods == null || methods == Binding.NO_METHODS || methods.length == 0) {
                constructor = new MethodBinding(0, receiverType.sourceName, receiverType, null, receiverType);
            } else {
                if (methods.length > 1 && Compiler.DEBUG) {
                    Logger.log(202, "Scope#getConstructor: There should only ever be one match for a constructor search but found " + methods.length + " when looking for " + new String(receiverType.sourceName) + ". Using the first match.");
                }
                constructor = methods[0];
            }
            if (!constructor.canBeSeenBy(invocationSite, this)) {
                constructor = new ProblemMethodBinding(methods[0], methods[0].selector, methods[0].parameters, 2);
            }
            MethodBinding methodBinding3 = constructor;
            return methodBinding3;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).getDefaultPackage();
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).getBinding();
                    if (context == null) break;
                    return context.modifiers;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (type == null) break;
                return type.modifiers;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                return context.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        LookupEnvironment env = this.environment();
        try {
            env.missingClassFileLocation = invocationSite;
            FieldBinding field = this.findField(receiverType, fieldName, invocationSite, true);
            if (field != null) {
                FieldBinding fieldBinding = field;
                return fieldBinding;
            }
            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, 1);
            return problemFieldBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    public Binding getFieldOrMethod(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        LookupEnvironment env = this.environment();
        try {
            env.missingClassFileLocation = invocationSite;
            FieldBinding field = this.findField(receiverType, fieldName, invocationSite, true);
            if (field != null) {
                FieldBinding fieldBinding = field;
                return fieldBinding;
            }
            MethodBinding method = this.findMethod(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, null, invocationSite);
            if (method != null) {
                if (!method.isValidBinding()) {
                    if (method.problemId() != 1) {
                        MethodBinding methodBinding = method;
                        return methodBinding;
                    }
                } else {
                    MethodBinding methodBinding = method;
                    return methodBinding;
                }
            }
            ProblemFieldBinding problemFieldBinding = new ProblemFieldBinding(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, 1);
            return problemFieldBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public MethodBinding getImplicitMethod(char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        insideStaticContext = false;
        insideConstructorCall = false;
        foundMethod = null;
        foundProblem = null;
        foundProblemVisible = false;
        scope = this;
        depth = 0;
        options = this.compilerOptions();
        inheritedHasPrecedence = options.complianceLevel >= 0x300000L;
        block6: while (true) {
            switch (scope.kind) {
                case 2: {
                    methodScope = (MethodScope)scope;
                    insideStaticContext |= methodScope.isStatic;
                    insideConstructorCall |= methodScope.isConstructorCall;
                    binding = methodScope.findMethod(selector, argumentTypes, true);
                    if (binding != null) {
                        return binding;
                    }
                    variable = methodScope.findVariable(selector);
                    ** GOTO lbl108
                }
                case 5: {
                    withScope = (WithScope)scope;
                    withType = withScope.referenceContext;
                    methBinding = withScope.findExactMethod(withType, selector, argumentTypes, invocationSite);
                    if (methBinding == null) {
                        methBinding = withScope.findMethod(withType, selector, argumentTypes, invocationSite);
                    }
                    if (methBinding != null && methBinding.isValidBinding()) {
                        return methBinding;
                    }
                    ** GOTO lbl108
                }
                case 3: {
                    classScope = (ClassScope)scope;
                    receiverType = classScope.enclosingReceiverType();
                    methodBinding = classScope.findExactMethod(receiverType, selector, argumentTypes, invocationSite);
                    if (methodBinding == null) {
                        methodBinding = classScope.findMethod(receiverType, selector, argumentTypes, invocationSite);
                    }
                    if (methodBinding != null) {
                        if (foundMethod == null) {
                            if (methodBinding.isValidBinding()) {
                                if (!methodBinding.isStatic() && (insideConstructorCall || insideStaticContext)) {
                                    if (foundProblem != null && foundProblem.problemId() != 2) {
                                        return foundProblem;
                                    }
                                    return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, insideConstructorCall != false ? 6 : 7);
                                }
                                if (inheritedHasPrecedence || receiverType == methodBinding.declaringClass || receiverType.getMethods(selector) != Binding.NO_METHODS) {
                                    if (foundProblemVisible) {
                                        return foundProblem;
                                    }
                                    if (depth > 0) {
                                        invocationSite.setDepth(depth);
                                        invocationSite.setActualReceiverType(receiverType);
                                    }
                                    return methodBinding;
                                }
                                if (foundProblem == null || foundProblem.problemId() == 2) {
                                    if (foundProblem != null) {
                                        foundProblem = null;
                                    }
                                    if (depth > 0) {
                                        invocationSite.setDepth(depth);
                                        invocationSite.setActualReceiverType(receiverType);
                                    }
                                    foundMethod = methodBinding;
                                }
                            } else {
                                if (methodBinding.problemId() != 2 && methodBinding.problemId() != 1) {
                                    return methodBinding;
                                }
                                if (foundProblem == null) {
                                    foundProblem = methodBinding;
                                }
                                if (!foundProblemVisible && methodBinding.problemId() == 1 && (closestMatch = ((ProblemMethodBinding)methodBinding).closestMatch) != null && closestMatch.canBeSeenBy(receiverType, invocationSite, this)) {
                                    foundProblem = methodBinding;
                                    foundProblemVisible = true;
                                }
                            }
                        } else if (methodBinding.problemId() == 3 || foundMethod.declaringClass != methodBinding.declaringClass && (receiverType == methodBinding.declaringClass || receiverType.getMethods(selector) != Binding.NO_METHODS)) {
                            return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 5);
                        }
                    }
                    ++depth;
                    insideStaticContext |= receiverType.isStatic();
                    enclosingMethodScope = scope.methodScope();
                    insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                    ** GOTO lbl108
                }
                case 4: {
                    compilationUnitScope = (CompilationUnitScope)scope;
                    compilationUnitBinding = compilationUnitScope.enclosingCompilationUnit();
                    receiverType = compilationUnitBinding;
                    v0 = methodBinding = foundMethod == null ? compilationUnitScope.findExactMethod(receiverType, selector, argumentTypes, invocationSite) : compilationUnitScope.findExactMethod(receiverType, foundMethod.selector, foundMethod.parameters, invocationSite);
                    if (methodBinding == null) {
                        methodBinding = compilationUnitScope.findMethod(receiverType, selector, argumentTypes, invocationSite);
                    }
                    if (methodBinding == null) {
                        methodBinding = compilationUnitScope.findMethod(selector, argumentTypes, true);
                    }
                    if (methodBinding != null) {
                        if (methodBinding.problemId() == 3) {
                            if (foundMethod == null || foundMethod.problemId() == 2) {
                                return methodBinding;
                            }
                            return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 5);
                        }
                        fuzzyProblem = null;
                        insideProblem = null;
                        if (foundMethod == null && (receiverType == methodBinding.declaringClass || receiverType.getMethods(selector) != Binding.NO_METHODS || (foundProblem == null || foundProblem.problemId() != 2) && this.compilerOptions().complianceLevel >= 0x300000L)) {
                            if (depth > 0) {
                                invocationSite.setDepth(depth);
                                invocationSite.setActualReceiverType(receiverType);
                            }
                            if (foundProblem != null && foundProblem.problemId() != 2) {
                                return foundProblem;
                            }
                            if (insideProblem != null) {
                                return insideProblem;
                            }
                            return methodBinding;
                        }
                        if (foundMethod == null || foundMethod.problemId() == 2 && methodBinding.problemId() != 2) {
                            if (depth > 0) {
                                invocationSite.setDepth(depth);
                                invocationSite.setActualReceiverType(receiverType);
                            }
                            foundProblem = fuzzyProblem;
                            foundProblem = insideProblem;
                            if (fuzzyProblem == null) {
                                foundMethod = methodBinding;
                            }
                        }
                    }
                    ++depth;
                    break block6;
                }
lbl108:
                // 4 sources

                default: {
                    scope = scope.parent;
                    continue block6;
                }
            }
            break;
        }
        if ((insideStaticContext |= receiverType.isStatic()) && options.sourceLevel >= 0x310000L && foundProblem != null) {
            if (foundProblem.declaringClass != null && foundProblem.declaringClass.id == 1) {
                return foundProblem;
            }
            if (foundProblem.problemId() == 1 && foundProblemVisible) {
                return foundProblem;
            }
        }
        if (foundMethod != null) {
            invocationSite.setActualReceiverType(foundMethod.declaringClass);
            return foundMethod;
        }
        if (foundProblem != null) {
            return foundProblem;
        }
        return new ProblemMethodBinding(selector, argumentTypes, 1);
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(JAVA_LANG_ASSERTIONERROR);
        return unitScope.environment.getResolvedType(JAVA_LANG_ASSERTIONERROR, this);
    }

    public final ReferenceBinding getJavaLangClass() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(JAVA_LANG_CLASS);
        return unitScope.environment.getResolvedType(JAVA_LANG_CLASS, this);
    }

    public final ReferenceBinding getJavaLangIterable() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(JAVA_LANG_ITERABLE);
        return unitScope.environment.getResolvedType(JAVA_LANG_ITERABLE, this);
    }

    public final ReferenceBinding getJavaLangObject() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(JAVA_LANG_OBJECT);
        return unitScope.environment.getResolvedType(JAVA_LANG_OBJECT, this);
    }

    public final ReferenceBinding getJavaLangArray() {
        this.compilationUnitScope().recordQualifiedReference(ARRAY);
        return this.environment().getResolvedType(ARRAY, this);
    }

    public final ReferenceBinding getJavaLangString() {
        this.compilationUnitScope().recordQualifiedReference(JAVA_LANG_STRING);
        return this.environment().getResolvedType(JAVA_LANG_STRING, this);
    }

    public final ReferenceBinding getJavaLangNumber() {
        this.compilationUnitScope().recordQualifiedReference(NUMBER);
        return this.environment().getResolvedType(NUMBER, this);
    }

    public final ReferenceBinding getJavaLangFunction() {
        this.compilationUnitScope().recordQualifiedReference(FUNCTION);
        return this.environment().getResolvedType(FUNCTION, this);
    }

    public final ReferenceBinding getJavaLangBoolean() {
        this.compilationUnitScope().recordQualifiedReference(BOOLEAN_OBJECT);
        return this.environment().getResolvedType(BOOLEAN_OBJECT, this);
    }

    public final ReferenceBinding getJavaLangThrowable() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(JAVA_LANG_THROWABLE);
        return unitScope.environment.getResolvedType(JAVA_LANG_THROWABLE, this);
    }

    public final ReferenceBinding getJavaLangError() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(ERROR);
        return unitScope.environment.getResolvedType(ERROR, this);
    }

    public final ReferenceBinding getJavaLangRegExp() {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(REGEXP);
        return unitScope.environment.getResolvedType(REGEXP, this);
    }

    public final ReferenceBinding getMemberType(char[] typeName, ReferenceBinding enclosingType) {
        ReferenceBinding memberType = this.findMemberType(typeName, enclosingType);
        if (memberType != null) {
            return memberType;
        }
        return new ProblemReferenceBinding(typeName, null, 1);
    }

    public MethodBinding getMethod(TypeBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            env.missingClassFileLocation = invocationSite;
            if (receiverType == null) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(selector, argumentTypes, 1);
                return problemMethodBinding;
            }
            switch (receiverType.kind()) {
                case 132: {
                    ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(selector, argumentTypes, 1);
                    return problemMethodBinding;
                }
            }
            unitScope.recordTypeReference(receiverType);
            ReferenceBinding currentType = (ReferenceBinding)receiverType;
            if (!currentType.canBeSeenBy(this)) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(selector, argumentTypes, 8);
                return problemMethodBinding;
            }
            MethodBinding methodBinding = this.findExactMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding != null) {
                MethodBinding methodBinding2 = methodBinding;
                return methodBinding2;
            }
            methodBinding = this.findMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding == null) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(selector, argumentTypes, 1);
                return problemMethodBinding;
            }
            if (!methodBinding.isValidBinding()) {
                MethodBinding methodBinding3 = methodBinding;
                return methodBinding3;
            }
            MethodBinding methodBinding4 = methodBinding;
            return methodBinding4;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    public final Binding getPackage(char[][] compoundName) {
        this.compilationUnitScope().recordQualifiedReference(compoundName);
        Binding binding = this.getTypeOrPackage(compoundName[0], 16388);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], null, 1);
        }
        if (!binding.isValidBinding()) {
            return binding;
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int currentIndex = 1;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (currentIndex < compoundName.length) {
            if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++], 16384)) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding instanceof ReferenceBinding ? ((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
            }
            if (!(binding instanceof PackageBinding)) {
                return packageBinding;
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(compoundName, null, 1);
    }

    public final TypeBinding getType(char[] name) {
        TypeBinding binding = Scope.getBaseType(name);
        if (binding != null) {
            return binding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(name, 4);
    }

    public final TypeBinding getType(char[] name, PackageBinding packageBinding) {
        if (packageBinding == null) {
            return this.getType(name);
        }
        Binding binding = packageBinding.getTypeOrPackage(name, 4);
        if (binding == null) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), null, 1);
        }
        if (!binding.isValidBinding()) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), binding instanceof ReferenceBinding ? ((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
        }
        ReferenceBinding typeBinding = (ReferenceBinding)binding;
        if (!typeBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), typeBinding, 2);
        }
        return typeBinding;
    }

    /*
     * Unable to fully structure code
     */
    public final TypeBinding getType(char[][] compoundName, int typeNameLength) {
        if (typeNameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(compoundName);
        binding = this.getTypeOrPackage(compoundName[0], typeNameLength == 1 ? 4 : 16388);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], null, 1);
        }
        if (!binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < typeNameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++], 4)) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding instanceof ReferenceBinding != false ? ((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        unitScope.recordTypeReference(typeBinding);
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl34
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) continue;
            if (typeBinding instanceof ProblemReferenceBinding) {
                problemBinding = (ProblemReferenceBinding)typeBinding;
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), problemBinding.closestMatch(), typeBinding.problemId());
            }
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), ((ReferenceBinding)binding).closestMatch(), typeBinding.problemId());
lbl34:
            // 2 sources

            ** while (currentIndex < typeNameLength)
        }
lbl35:
        // 1 sources

        return typeBinding;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] name, int mask) {
        void var4_8;
        PackageBinding packageBinding;
        void var4_5;
        Binding binding;
        Scope scope = this;
        Object var4_4 = null;
        if ((mask & 4) == 0) {
            Scope next = scope;
            while ((next = scope.parent) != null) {
                scope = next;
            }
        } else {
            block7: while (true) {
                switch (scope.kind) {
                    case 2: {
                        MethodScope methodScope = (MethodScope)scope;
                        boolean cfr_ignored_0 = methodScope.isStatic;
                    }
                    case 1: {
                        ReferenceBinding localType = ((BlockScope)scope).findLocalType(name);
                        if (localType == null) break;
                        return localType;
                    }
                    case 3: {
                        SourceTypeBinding sourceType = ((ClassScope)scope).getReferenceBinding();
                        if (CharOperation.equals(name, sourceType.sourceName)) {
                            return sourceType;
                        }
                        sourceType.isStatic();
                        break;
                    }
                    case 4: {
                        break block7;
                    }
                }
                scope = scope.parent;
            }
        }
        CompilationUnitScope unitScope = (CompilationUnitScope)scope;
        HashtableOfObject typeOrPackageCache = unitScope.typeOrPackageCache;
        if (typeOrPackageCache != null && (binding = (Binding)typeOrPackageCache.get(name)) != null) {
            if (binding instanceof ImportBinding) {
                ImportReference importReference = ((ImportBinding)binding).reference;
                if (importReference != null) {
                    importReference.bits |= 2;
                }
                if (binding instanceof ImportConflictBinding) {
                    binding = ((ImportConflictBinding)binding).conflictingTypeBinding;
                    typeOrPackageCache.put(name, binding);
                } else {
                    binding = ((ImportBinding)binding).resolvedImport;
                    typeOrPackageCache.put(name, binding);
                }
            }
            if ((mask & 4) != 0 && binding instanceof ReferenceBinding) {
                return binding;
            }
            if ((mask & 0x4000) != 0 && binding instanceof PackageBinding) {
                return binding;
            }
        }
        if ((mask & 4 | 3 | 8) != 0) {
            Binding resolvedImport;
            int length;
            ImportBinding[] imports = unitScope.imports;
            if (imports != null && typeOrPackageCache == null) {
                int i = 0;
                length = imports.length;
                while (i < length) {
                    ImportBinding importBinding = imports[i];
                    if (!importBinding.onDemand && CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) && (resolvedImport = unitScope.resolveSingleImport(importBinding)) != null && (!(resolvedImport instanceof MethodBinding) || (resolvedImport = this.getType(importBinding.compoundName, importBinding.compoundName.length)).isValidBinding()) && resolvedImport instanceof TypeBinding) {
                        ImportReference importReference = importBinding.reference;
                        if (importReference != null) {
                            importReference.bits |= 2;
                        }
                        return resolvedImport;
                    }
                    ++i;
                }
            }
            if (imports != null) {
                int i = 0;
                length = imports.length;
                while (i < length) {
                    ImportBinding someImport = imports[i];
                    if (someImport.reference != null && someImport.reference.isFileImport()) {
                        CompilationUnitBinding compilationUnitBinding;
                        resolvedImport = someImport.resolvedImport;
                        Binding temp = null;
                        if (resolvedImport instanceof CompilationUnitBinding && (temp = this.findBinding(name, mask, (compilationUnitBinding = (CompilationUnitBinding)resolvedImport).getPackage(), unitScope.getDefaultPackage(), false)) != null && temp.isValidBinding()) {
                            ImportReference importReference = someImport.reference;
                            importReference.bits |= 2;
                            if (typeOrPackageCache != null) {
                                typeOrPackageCache.put(name, temp);
                            }
                            return temp;
                        }
                    }
                    ++i;
                }
            }
            PackageBinding currentPackage = unitScope.getDefaultPackage();
            unitScope.recordReference(currentPackage.compoundName, name);
            Binding binding2 = currentPackage.getTypeOrPackage(name, mask);
            if ((binding2 instanceof ReferenceBinding || binding2 instanceof MethodBinding) && !(binding2 instanceof ProblemReferenceBinding)) {
                if (typeOrPackageCache != null) {
                    typeOrPackageCache.put(name, binding2);
                }
                return binding2;
            }
            if (binding2 instanceof LocalVariableBinding && binding2.isValidBinding()) {
                this.compilationUnitScope().addExternalVar((LocalVariableBinding)binding2);
                return binding2;
            }
            if (imports != null) {
                boolean foundInImport = false;
                Binding type = null;
                int i = 0;
                int length2 = imports.length;
                while (i < length2) {
                    ImportBinding someImport = imports[i];
                    if (someImport.onDemand) {
                        Binding resolvedImport2 = someImport.resolvedImport;
                        Binding temp = null;
                        temp = resolvedImport2 instanceof PackageBinding ? this.findBinding(name, mask, (PackageBinding)resolvedImport2, currentPackage, false) : this.findDirectMemberType(name, (ReferenceBinding)resolvedImport2);
                        if (temp != type && temp != null) {
                            if (temp.isValidBinding()) {
                                ImportReference importReference = someImport.reference;
                                if (importReference != null) {
                                    importReference.bits |= 2;
                                }
                                if (foundInImport) {
                                    temp = new ProblemReferenceBinding(name, null, 3);
                                    if (typeOrPackageCache != null) {
                                        typeOrPackageCache.put(name, temp);
                                    }
                                    return temp;
                                }
                                type = temp;
                                foundInImport = true;
                            } else if (var4_5 == null) {
                                Binding binding3 = temp;
                            }
                        }
                    }
                    ++i;
                }
                if (type != null) {
                    if (typeOrPackageCache != null) {
                        typeOrPackageCache.put(name, type);
                    }
                    return type;
                }
            }
        }
        unitScope.recordSimpleReference(name);
        if ((mask & 0x4000) != 0 && (packageBinding = unitScope.environment.getTopLevelPackage(name)) != null) {
            if (typeOrPackageCache != null) {
                typeOrPackageCache.put(name, packageBinding);
            }
            return packageBinding;
        }
        if (var4_5 == null) {
            ProblemReferenceBinding problemReferenceBinding = new ProblemReferenceBinding(name, null, 1);
            if (typeOrPackageCache != null && (mask & 0x4000) != 0) {
                typeOrPackageCache.put(name, problemReferenceBinding);
            }
        }
        return var4_8;
    }

    public final Binding getTypeOrPackage(char[][] compoundName) {
        return this.getTypeOrPackage(compoundName, 16388);
    }

    /*
     * Unable to fully structure code
     */
    public final Binding getTypeOrPackage(char[][] compoundName, int mask) {
        nameLength = compoundName.length;
        if (nameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        binding = this.getTypeOrPackage(compoundName[0], 16388);
        if (!binding.isValidBinding()) {
            return binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < nameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++], mask)) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), binding instanceof ReferenceBinding != false ? ((ReferenceBinding)binding).closestMatch() : null, binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return binding;
            }
            checkVisibility = true;
        }
        qualifiedType = typeBinding = (ReferenceBinding)binding;
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl28
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if (!(typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), ((ReferenceBinding)binding).closestMatch(), typeBinding.problemId());
            }
            qualifiedType = typeBinding;
lbl28:
            // 2 sources

            ** while (currentIndex < nameLength)
        }
lbl29:
        // 1 sources

        return qualifiedType;
    }

    protected boolean hasErasedCandidatesCollisions(TypeBinding one, TypeBinding two, Map invocations, ReferenceBinding type, ASTNode typeRef) {
        invocations.clear();
        TypeBinding[] mecs = this.minimalErasedCandidates(new TypeBinding[]{one, two}, invocations);
        if (mecs != null) {
            int k = 0;
            int max = mecs.length;
            while (k < max) {
                Object value;
                TypeBinding mec = mecs[k];
                if (mec != null && (value = invocations.get(mec)) instanceof TypeBinding[]) {
                    TypeBinding[] cfr_ignored_0 = (TypeBinding[])value;
                    type.tagBits |= 0x20000L;
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    public CaseStatement innermostSwitchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).enclosingCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    protected boolean isAcceptableMethod(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneParams = one.parameters;
        int oneParamsLength = oneParams.length;
        TypeBinding[] twoParams = two.parameters;
        int twoParamsLength = twoParams.length;
        if (oneParamsLength == twoParamsLength) {
            int i = 0;
            while (i < oneParamsLength) {
                TypeBinding oneParam = oneParams[i];
                TypeBinding twoParam = twoParams[i];
                if (oneParam != twoParam && !oneParam.isCompatibleWith(twoParam)) {
                    TypeBinding eType;
                    return i == oneParamsLength - 1 && one.isVarargs() && two.isVarargs() && (oneParam == (eType = ((ArrayBinding)twoParam).elementsType()) || oneParam.isCompatibleWith(eType));
                }
                ++i;
            }
            return true;
        }
        if (one.isVarargs() && two.isVarargs()) {
            if (oneParamsLength > twoParamsLength && ((ArrayBinding)twoParams[twoParamsLength - 1]).elementsType().id != 1) {
                return false;
            }
            int i = (oneParamsLength > twoParamsLength ? twoParamsLength : oneParamsLength) - 2;
            while (i >= 0) {
                if (oneParams[i] != twoParams[i] && !oneParams[i].isCompatibleWith(twoParams[i])) {
                    return false;
                }
                --i;
            }
            if (this.parameterCompatibilityLevel(one, twoParams) == -1 && this.parameterCompatibilityLevel(two, oneParams) == 2) {
                return true;
            }
        }
        return false;
    }

    public boolean isBoxingCompatibleWith(TypeBinding expressionType, TypeBinding targetType) {
        LookupEnvironment environment = this.environment();
        if (environment.globalOptions.sourceLevel < 0x310000L || expressionType.isBaseType() == targetType.isBaseType()) {
            return false;
        }
        TypeBinding convertedType = environment.computeBoxingType(expressionType);
        return convertedType == targetType || convertedType.isCompatibleWith(targetType);
    }

    public final boolean isDefinedInField(FieldBinding field) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != field) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding method) {
        Scope scope = this;
        do {
            ReferenceContext refContext;
            if (!(scope instanceof MethodScope) || !((refContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)refContext).getBinding() != method) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding type) {
        Scope scope;
        ReferenceBinding enclosingType = type;
        while ((type = enclosingType.enclosingType()) != null) {
            enclosingType = type;
        }
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        SourceTypeBinding[] topLevelTypes = ((CompilationUnitScope)unitScope).topLevelTypes;
        int i = topLevelTypes.length;
        while (--i >= 0) {
            if (topLevelTypes[i] != enclosingType) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding type) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || ((ClassScope)scope).getReferenceBinding() != type) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideCase(CaseStatement caseStatement) {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 1: {
                    if (((BlockScope)scope).enclosingCase != caseStatement) break;
                    return true;
                }
            }
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).getBinding();
                    if (context == null || !context.isViewedAsDeprecated()) break;
                    return true;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                if (type == null || !type.isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null || !context.isViewedAsDeprecated()) break;
                return true;
            }
            case 4: {
                SourceTypeBinding type;
                CompilationUnitDeclaration unit = this.referenceCompilationUnit();
                if (unit.types == null || unit.types.length <= 0 || (type = unit.types[0].binding) == null || !type.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    public MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected TypeBinding[] minimalErasedCandidates(TypeBinding[] types, Map allInvocations) {
        length = types.length;
        indexOfFirst = -1;
        actualLength = 0;
        i = 0;
        while (i < length) {
            type = types[i];
            if (type != null) {
                if (type.isBaseType()) {
                    return null;
                }
                if (indexOfFirst < 0) {
                    indexOfFirst = i;
                }
                ++actualLength;
            }
            ++i;
        }
        switch (actualLength) {
            case 0: {
                return Binding.NO_TYPES;
            }
            case 1: {
                return types;
            }
        }
        firstType = types[indexOfFirst];
        if (firstType.isBaseType()) {
            return null;
        }
        typesToVisit = new ArrayList<TypeBinding>(5);
        dim = firstType.dimensions();
        leafType = firstType.leafComponentType();
        firstErasure = firstType;
        if (firstErasure != firstType) {
            allInvocations.put(firstErasure, firstType);
        }
        typesToVisit.add(firstType);
        max = 1;
        i = 0;
        while (i < max) {
            block57: {
                block56: {
                    typeToVisit = (TypeBinding)typesToVisit.get(i);
                    dim = typeToVisit.dimensions();
                    if (dim <= 0) break block56;
                    leafType = typeToVisit.leafComponentType();
                    switch (leafType.id) {
                        case 1: {
                            if (dim <= 1) ** GOTO lbl48
                            elementType = ((ArrayBinding)typeToVisit).elementsType();
                            if (!typesToVisit.contains(elementType)) {
                                typesToVisit.add(elementType);
                                ++max;
                            }
                            break block57;
                        }
lbl48:
                        // 2 sources

                        case 2: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            superType = this.getJavaLangObject();
                            if (!typesToVisit.contains(superType)) {
                                typesToVisit.add(superType);
                                ++max;
                            }
                            break block57;
                        }
                        default: {
                            typeToVisit = leafType;
                        }
                    }
                }
                if ((itsSuperclass = (currentType = (ReferenceBinding)typeToVisit).getSuperBinding()) != null) {
                    v0 = superType = dim == 0 ? itsSuperclass : this.environment().createArrayType(itsSuperclass, dim);
                    if (!typesToVisit.contains(superType)) {
                        typesToVisit.add(superType);
                        ++max;
                        superTypeErasure = superType;
                        if (superTypeErasure != superType) {
                            allInvocations.put(superTypeErasure, superType);
                        }
                    }
                }
            }
            ++i;
        }
        superLength = typesToVisit.size();
        erasedSuperTypes = new TypeBinding[superLength];
        rank = 0;
        for (TypeBinding type : typesToVisit) {
            leafType = type.leafComponentType();
            erasedSuperTypes[rank++] = type;
        }
        remaining = superLength;
        i = indexOfFirst + 1;
        while (i < length) {
            block58: {
                block59: {
                    otherType = types[i];
                    if (otherType == null) break block58;
                    if (!otherType.isArrayType()) break block59;
                    j = 0;
                    while (j < superLength) {
                        block54: {
                            erasedSuperType = erasedSuperTypes[j];
                            if (erasedSuperType != null && erasedSuperType != otherType) {
                                match /* !! */  = otherType.findSuperTypeWithSameErasure(erasedSuperType);
                                if (match /* !! */  == null) {
                                    erasedSuperTypes[j] = null;
                                    if (--remaining == 0) {
                                        return null;
                                    }
                                } else {
                                    invocationData = allInvocations.get(erasedSuperType);
                                    if (invocationData == null) {
                                        allInvocations.put(erasedSuperType, match /* !! */ );
                                    } else if (invocationData instanceof TypeBinding) {
                                        if (match /* !! */  != invocationData) {
                                            someInvocations = new TypeBinding[]{(TypeBinding)invocationData, match /* !! */ };
                                            allInvocations.put(erasedSuperType, someInvocations);
                                        }
                                    } else {
                                        someInvocations = (TypeBinding[])invocationData;
                                        invocLength = someInvocations.length;
                                        k = 0;
                                        while (k < invocLength) {
                                            if (someInvocations[k] != match /* !! */ ) {
                                                ++k;
                                                continue;
                                            }
                                            break block54;
                                        }
                                        v1 = someInvocations;
                                        someInvocations = new TypeBinding[invocLength + 1];
                                        System.arraycopy(v1, 0, someInvocations, 0, invocLength);
                                        allInvocations.put(erasedSuperType, someInvocations);
                                        someInvocations[invocLength] = match /* !! */ ;
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    break block58;
                }
                j = 0;
                while (j < superLength) {
                    block55: {
                        block60: {
                            erasedSuperType = erasedSuperTypes[j];
                            if (erasedSuperType == null) break block55;
                            if (erasedSuperType != otherType) break block60;
                            match /* !! */  = erasedSuperType;
                            ** GOTO lbl-1000
                        }
                        match /* !! */  = erasedSuperType.isArrayType() != false ? null : otherType.findSuperTypeWithSameErasure(erasedSuperType);
                        if (match /* !! */  == null) {
                            erasedSuperTypes[j] = null;
                            if (--remaining == 0) {
                                return null;
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            invocationData = allInvocations.get(erasedSuperType);
                            if (invocationData == null) {
                                allInvocations.put(erasedSuperType, match /* !! */ );
                            } else if (invocationData instanceof TypeBinding) {
                                if (match /* !! */  != invocationData) {
                                    someInvocations = new TypeBinding[]{(TypeBinding)invocationData, match /* !! */ };
                                    allInvocations.put(erasedSuperType, someInvocations);
                                }
                            } else {
                                someInvocations = (TypeBinding[])invocationData;
                                invocLength = someInvocations.length;
                                k = 0;
                                while (k < invocLength) {
                                    if (someInvocations[k] != match /* !! */ ) {
                                        ++k;
                                        continue;
                                    }
                                    break block55;
                                }
                                v2 = someInvocations;
                                someInvocations = new TypeBinding[invocLength + 1];
                                System.arraycopy(v2, 0, someInvocations, 0, invocLength);
                                allInvocations.put(erasedSuperType, someInvocations);
                                someInvocations[invocLength] = match /* !! */ ;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (remaining > 1) {
            i = 0;
            while (i < superLength) {
                erasedSuperType = erasedSuperTypes[i];
                if (erasedSuperType != null) {
                    j = 0;
                    while (j < superLength) {
                        if (i != j && (otherType = erasedSuperTypes[j]) != null) {
                            if (erasedSuperType instanceof ReferenceBinding) {
                                if (erasedSuperType.findSuperTypeWithSameErasure(otherType) != null) {
                                    erasedSuperTypes[j] = null;
                                    --remaining;
                                }
                            } else if (erasedSuperType.isArrayType() && erasedSuperType.findSuperTypeWithSameErasure(otherType) != null) {
                                erasedSuperTypes[j] = null;
                                --remaining;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return erasedSuperTypes;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding previous = null;
        int i = 0;
        while (i < visibleSize) {
            block4: {
                MethodBinding method = visible[i];
                if (previous != null && method.declaringClass != previous.declaringClass) break;
                if (!method.isStatic()) {
                    previous = method;
                }
                int j = 0;
                while (j < visibleSize) {
                    if (i == j || visible[j].areParametersCompatibleWith(method.parameters)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return method;
            }
            ++i;
        }
        return new ProblemMethodBinding(visible[0], visible[0].selector, visible[0].parameters, 3);
    }

    protected final MethodBinding mostSpecificMethodBinding(MethodBinding[] visible, int visibleSize, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding receiverType) {
        int i;
        int[] compatibilityLevels = new int[visibleSize];
        int i2 = 0;
        while (i2 < visibleSize) {
            compatibilityLevels[i2] = this.parameterCompatibilityLevel(visible[i2], argumentTypes);
            ++i2;
        }
        MethodBinding[] moreSpecific = new MethodBinding[visibleSize];
        int count = 0;
        int level = 0;
        int max = 2;
        while (level <= max) {
            int i3 = 0;
            while (i3 < visibleSize) {
                block29: {
                    if (compatibilityLevels[i3] == level) {
                        max = level;
                        MethodBinding current = visible[i3];
                        MethodBinding original = current.original();
                        MethodBinding tiebreakMethod = current.tiebreakMethod();
                        int j = 0;
                        while (j < visibleSize) {
                            if (i3 != j && compatibilityLevels[j] == level) {
                                MethodBinding next = visible[j];
                                if (original == next.original()) {
                                    compatibilityLevels[j] = -1;
                                } else {
                                    MethodBinding methodToTest = next;
                                    MethodBinding acceptable = this.computeCompatibleMethod(methodToTest, tiebreakMethod.parameters, invocationSite);
                                    if (acceptable == null || !acceptable.isValidBinding() || !this.isAcceptableMethod(tiebreakMethod, acceptable) || current.isBridge() && !next.isBridge() && tiebreakMethod.areParametersEqual(acceptable)) break block29;
                                }
                            }
                            ++j;
                        }
                        moreSpecific[i3] = current;
                        ++count;
                    }
                }
                ++i3;
            }
            ++level;
        }
        if (count == 1) {
            i = 0;
            while (i < visibleSize) {
                if (moreSpecific[i] != null) {
                    return visible[i];
                }
                ++i;
            }
        } else if (count == 0) {
            return new ProblemMethodBinding(visible[0], visible[0].selector, visible[0].parameters, 3);
        }
        i = 0;
        block5: while (i < visibleSize) {
            block30: {
                MethodBinding current = moreSpecific[i];
                if (current != null) {
                    MethodBinding original = current.original();
                    int j = 0;
                    while (j < visibleSize) {
                        MethodBinding next = moreSpecific[j];
                        if (next != null && i != j) {
                            TypeBinding superType;
                            MethodBinding original2 = next.original();
                            if (original.declaringClass == original2.declaringClass) break block5;
                            if (!original.isAbstract()) {
                                if (!original2.isAbstract() && (superType = original.declaringClass.findSuperTypeWithSameErasure(original2.declaringClass)) == null) {
                                    break block30;
                                }
                            } else if (receiverType != null) {
                                int l;
                                int m;
                                MethodBinding[] superMethods;
                                superType = receiverType.findSuperTypeWithSameErasure(original.declaringClass);
                                if (original.declaringClass != superType && superType instanceof ReferenceBinding) {
                                    superMethods = ((ReferenceBinding)superType).getMethods(original.selector);
                                    m = 0;
                                    l = superMethods.length;
                                    while (m < l) {
                                        if (superMethods[m].original() == original) {
                                            original = superMethods[m];
                                            break;
                                        }
                                        ++m;
                                    }
                                }
                                if (original2.declaringClass != (superType = receiverType.findSuperTypeWithSameErasure(original2.declaringClass)) && superType instanceof ReferenceBinding) {
                                    superMethods = ((ReferenceBinding)superType).getMethods(original2.selector);
                                    m = 0;
                                    l = superMethods.length;
                                    while (m < l) {
                                        if (superMethods[m].original() == original2) {
                                            original2 = superMethods[m];
                                            break;
                                        }
                                        ++m;
                                    }
                                }
                                if (original2 == null || !original.areParametersEqual(original2) || !original.returnType.isCompatibleWith(original2.returnType) && !original.returnType.isCompatibleWith(original2.returnType)) break block30;
                            }
                        }
                        ++j;
                    }
                    return current;
                }
            }
            ++i;
        }
        return moreSpecific[0];
    }

    public final ClassScope outerMostClassScope() {
        ClassScope lastClassScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            lastClassScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return lastClassScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope lastMethodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            lastMethodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return lastMethodScope;
    }

    public int parameterCompatibilityLevel(MethodBinding method, TypeBinding[] arguments) {
        TypeBinding arg;
        if (arguments == null) {
            return 0;
        }
        TypeBinding[] parameters = method.parameters;
        int paramLength = parameters.length;
        int argLength = arguments.length;
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            if (paramLength != argLength) {
                return -1;
            }
            int i = 0;
            while (i < argLength) {
                TypeBinding arg2 = arguments[i];
                TypeBinding param = parameters[i];
                if (arg2 != param && !arg2.isCompatibleWith(param)) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }
        int level = 0;
        int lastIndex = argLength;
        LookupEnvironment env = this.environment();
        if (method.isVarargs()) {
            TypeBinding param;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                param = parameters[lastIndex];
                TypeBinding arg3 = arguments[lastIndex];
                if (param != arg3 && (level = this.parameterCompatibilityLevel(arg3, param, env)) == -1) {
                    if (this.parameterCompatibilityLevel(arg3, param = ((ArrayBinding)param).elementsType(), env) == -1) {
                        return -1;
                    }
                    level = 2;
                }
            } else {
                if (paramLength < argLength) {
                    param = ((ArrayBinding)parameters[lastIndex]).elementsType();
                    int i = lastIndex;
                    while (i < argLength) {
                        arg = arguments[i];
                        if (param != arg && this.parameterCompatibilityLevel(arg, param, env) == -1) {
                            return -1;
                        }
                        ++i;
                    }
                } else if (lastIndex != argLength) {
                    return -1;
                }
                level = 2;
            }
        } else if (paramLength != argLength) {
            return -1;
        }
        int i = 0;
        while (i < lastIndex) {
            arg = arguments[i];
            TypeBinding param = parameters[i];
            if (arg != param) {
                int newLevel = this.parameterCompatibilityLevel(arg, param, env);
                if (newLevel == -1) {
                    return -1;
                }
                if (newLevel > level) {
                    level = newLevel;
                }
            }
            ++i;
        }
        return level;
    }

    private int parameterCompatibilityLevel(TypeBinding arg, TypeBinding param, LookupEnvironment env) {
        TypeBinding convertedType;
        if (arg.isCompatibleWith(param)) {
            return 0;
        }
        if (arg.isBaseType() != param.isBaseType() && ((convertedType = env.computeBoxingType(arg)) == param || convertedType.isCompatibleWith(param))) {
            return 1;
        }
        return -1;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).referenceContext;
    }

    public ReferenceContext referenceContext() {
        Scope current = this;
        do {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        } while ((current = current.parent) != null);
        return null;
    }

    int startIndex() {
        return 0;
    }
}

