/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionBinding;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnitBinding;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageBinding;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.RecoveredTypeBinding;
import org.eclipse.wst.jsdt.core.dom.RecoveredVariableBinding;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeBinding;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableBinding;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocImplicitTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;

class DefaultBindingResolver
extends BindingResolver {
    Map astNodesToBlockScope;
    Map bindingsToAstNodes;
    BindingTables bindingTables;
    Map newAstToOldAst = new HashMap();
    private CompilationUnitScope scope;
    WorkingCopyOwner workingCopyOwner;
    boolean isRecoveredBinding;

    DefaultBindingResolver(CompilationUnitScope scope, WorkingCopyOwner workingCopyOwner, BindingTables bindingTables, boolean isRecoveredBinding) {
        this.astNodesToBlockScope = new HashMap();
        this.bindingsToAstNodes = new HashMap();
        this.bindingTables = bindingTables;
        this.scope = scope;
        this.workingCopyOwner = workingCopyOwner;
        this.isRecoveredBinding = isRecoveredBinding;
    }

    DefaultBindingResolver(LookupEnvironment lookupEnvironment, WorkingCopyOwner workingCopyOwner, BindingTables bindingTables, boolean isRecoveredBinding) {
        this.astNodesToBlockScope = new HashMap();
        this.bindingsToAstNodes = new HashMap();
        this.bindingTables = bindingTables;
        this.scope = new CompilationUnitScope(new CompilationUnitDeclaration(null, null, -1), lookupEnvironment);
        this.workingCopyOwner = workingCopyOwner;
        this.isRecoveredBinding = isRecoveredBinding;
    }

    @Override
    synchronized ASTNode findDeclaringNode(IBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding instanceof IFunctionBinding) {
            IFunctionBinding methodBinding = (IFunctionBinding)binding;
            return (ASTNode)this.bindingsToAstNodes.get(methodBinding.getMethodDeclaration());
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            return (ASTNode)this.bindingsToAstNodes.get(typeBinding.getTypeDeclaration());
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            return (ASTNode)this.bindingsToAstNodes.get(variableBinding.getVariableDeclaration());
        }
        return (ASTNode)this.bindingsToAstNodes.get(binding);
    }

    @Override
    synchronized ASTNode findDeclaringNode(String bindingKey) {
        if (bindingKey == null) {
            return null;
        }
        Object binding = this.bindingTables.bindingKeysToBindings.get(bindingKey);
        if (binding == null) {
            return null;
        }
        return (ASTNode)this.bindingsToAstNodes.get(binding);
    }

    IBinding getBinding(Binding binding) {
        switch (binding.kind()) {
            case 16384: {
                return this.getPackageBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding)binding);
            }
            case 4: 
            case 132: {
                return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
            }
            case 68: {
                return new TypeBinding(this, (org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
            }
            case 8: {
                return this.getMethodBinding((MethodBinding)binding);
            }
            case 1: 
            case 2: {
                return this.getVariableBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding)binding);
            }
        }
        return null;
    }

    @Override
    synchronized org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode getCorrespondingNode(ASTNode currentNode) {
        return (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(currentNode);
    }

    @Override
    synchronized IFunctionBinding getMethodBinding(MethodBinding methodBinding) {
        if (methodBinding != null && !methodBinding.isValidBinding()) {
            ProblemMethodBinding problemMethodBinding = (ProblemMethodBinding)methodBinding;
            methodBinding = problemMethodBinding.closestMatch;
        }
        if (methodBinding != null) {
            IFunctionBinding binding = (IFunctionBinding)this.bindingTables.compilerBindingsToASTBindings.get(methodBinding);
            if (binding != null) {
                return binding;
            }
            binding = new FunctionBinding(this, methodBinding);
            this.bindingTables.compilerBindingsToASTBindings.put(methodBinding, binding);
            return binding;
        }
        return null;
    }

    @Override
    synchronized IPackageBinding getPackageBinding(org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding packageBinding) {
        if (packageBinding == null || !packageBinding.isValidBinding()) {
            return null;
        }
        IPackageBinding binding = (IPackageBinding)this.bindingTables.compilerBindingsToASTBindings.get(packageBinding);
        if (binding != null) {
            return binding;
        }
        binding = new PackageBinding(packageBinding, this);
        this.bindingTables.compilerBindingsToASTBindings.put(packageBinding, binding);
        return binding;
    }

    @Override
    synchronized ITypeBinding getTypeBinding(VariableDeclaration variableDeclaration) {
        ITypeBinding binding = (ITypeBinding)this.bindingTables.compilerBindingsToASTBindings.get(variableDeclaration);
        if (binding != null) {
            return binding;
        }
        binding = new RecoveredTypeBinding((BindingResolver)this, variableDeclaration);
        this.bindingTables.compilerBindingsToASTBindings.put(variableDeclaration, binding);
        return binding;
    }

    @Override
    synchronized ITypeBinding getTypeBinding(Type type) {
        ITypeBinding binding = (ITypeBinding)this.bindingTables.compilerBindingsToASTBindings.get(type);
        if (binding != null) {
            return binding;
        }
        binding = new RecoveredTypeBinding((BindingResolver)this, type);
        this.bindingTables.compilerBindingsToASTBindings.put(type, binding);
        return binding;
    }

    @Override
    synchronized ITypeBinding getTypeBinding(org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding referenceBinding) {
        if (referenceBinding == null) {
            return null;
        }
        if (!referenceBinding.isValidBinding()) {
            switch (referenceBinding.problemId()) {
                case 2: 
                case 7: {
                    if (!(referenceBinding instanceof ProblemReferenceBinding)) break;
                    ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)referenceBinding;
                    ReferenceBinding binding2 = problemReferenceBinding.closestMatch();
                    ITypeBinding binding = (ITypeBinding)this.bindingTables.compilerBindingsToASTBindings.get(binding2);
                    if (binding != null) {
                        return binding;
                    }
                    binding = new TypeBinding(this, binding2);
                    this.bindingTables.compilerBindingsToASTBindings.put(binding2, binding);
                    return binding;
                }
                case 1: {
                    if (!this.isRecoveredBinding) break;
                    ITypeBinding binding = (ITypeBinding)this.bindingTables.compilerBindingsToASTBindings.get(referenceBinding);
                    if (binding != null) {
                        return binding;
                    }
                    binding = new RecoveredTypeBinding((BindingResolver)this, referenceBinding);
                    this.bindingTables.compilerBindingsToASTBindings.put(referenceBinding, binding);
                    return binding;
                }
            }
            return null;
        }
        ITypeBinding binding = (ITypeBinding)this.bindingTables.compilerBindingsToASTBindings.get(referenceBinding);
        if (binding != null) {
            return binding;
        }
        binding = referenceBinding instanceof CompilationUnitBinding ? new JavaScriptUnitBinding(this, referenceBinding) : new TypeBinding(this, referenceBinding);
        this.bindingTables.compilerBindingsToASTBindings.put(referenceBinding, binding);
        return binding;
    }

    @Override
    synchronized ITypeBinding getTypeBinding(RecoveredTypeBinding recoveredTypeBinding, int dimensions) {
        if (recoveredTypeBinding == null) {
            return null;
        }
        return new RecoveredTypeBinding(this, recoveredTypeBinding, dimensions);
    }

    synchronized IVariableBinding getVariableBinding(org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding variableBinding, VariableDeclaration variableDeclaration) {
        if (this.isRecoveredBinding) {
            if (variableBinding != null) {
                if (variableBinding.isValidBinding()) {
                    IVariableBinding binding = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(variableBinding);
                    if (binding != null) {
                        return binding;
                    }
                    binding = variableBinding.type != null ? new VariableBinding(this, variableBinding) : new RecoveredVariableBinding(this, variableDeclaration);
                    this.bindingTables.compilerBindingsToASTBindings.put(variableBinding, binding);
                    return binding;
                }
                if (variableBinding instanceof ProblemFieldBinding) {
                    ProblemFieldBinding problemFieldBinding = (ProblemFieldBinding)variableBinding;
                    switch (problemFieldBinding.problemId()) {
                        case 2: 
                        case 6: 
                        case 7: {
                            ReferenceBinding declaringClass = problemFieldBinding.declaringClass;
                            FieldBinding exactBinding = declaringClass.getField(problemFieldBinding.name, true);
                            if (exactBinding == null) break;
                            IVariableBinding variableBinding2 = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                            if (variableBinding2 != null) {
                                return variableBinding2;
                            }
                            variableBinding2 = new VariableBinding(this, exactBinding);
                            this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, variableBinding2);
                            return variableBinding2;
                        }
                    }
                }
            }
            return null;
        }
        return this.getVariableBinding(variableBinding);
    }

    @Override
    public WorkingCopyOwner getWorkingCopyOwner() {
        return this.workingCopyOwner;
    }

    @Override
    synchronized IVariableBinding getVariableBinding(org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding variableBinding) {
        if (variableBinding != null) {
            if (variableBinding.isValidBinding()) {
                if (variableBinding.type != null) {
                    IVariableBinding binding = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(variableBinding);
                    if (binding != null) {
                        return binding;
                    }
                    binding = new VariableBinding(this, variableBinding);
                    this.bindingTables.compilerBindingsToASTBindings.put(variableBinding, binding);
                    return binding;
                }
            } else if (variableBinding instanceof ProblemFieldBinding) {
                ProblemFieldBinding problemFieldBinding = (ProblemFieldBinding)variableBinding;
                switch (problemFieldBinding.problemId()) {
                    case 2: 
                    case 6: 
                    case 7: {
                        ReferenceBinding declaringClass = problemFieldBinding.declaringClass;
                        FieldBinding exactBinding = declaringClass.getField(problemFieldBinding.name, true);
                        if (exactBinding == null) break;
                        IVariableBinding variableBinding2 = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                        if (variableBinding2 != null) {
                            return variableBinding2;
                        }
                        variableBinding2 = new VariableBinding(this, exactBinding);
                        this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, variableBinding2);
                        return variableBinding2;
                    }
                }
            }
        }
        return null;
    }

    @Override
    boolean isResolvedTypeInferredFromExpectedType(FunctionInvocation methodInvocation) {
        Object oldNode = this.newAstToOldAst.get(methodInvocation);
        boolean cfr_ignored_0 = oldNode instanceof MessageSend;
        return false;
    }

    @Override
    boolean isResolvedTypeInferredFromExpectedType(SuperMethodInvocation superMethodInvocation) {
        Object oldNode = this.newAstToOldAst.get(superMethodInvocation);
        boolean cfr_ignored_0 = oldNode instanceof MessageSend;
        return false;
    }

    @Override
    LookupEnvironment lookupEnvironment() {
        return this.scope.environment();
    }

    @Override
    synchronized void recordScope(ASTNode astNode, BlockScope blockScope) {
        this.astNodesToBlockScope.put(astNode, blockScope);
    }

    @Override
    Object resolveConstantExpressionValue(Expression expression) {
        org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node != null && node instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Expression) {
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression compilerExpression = (org.eclipse.wst.jsdt.internal.compiler.ast.Expression)node;
            Constant constant = compilerExpression.constant;
            if (constant != null && constant != Constant.NotAConstant) {
                switch (constant.typeID()) {
                    case 10: {
                        return new Integer(constant.intValue());
                    }
                    case 4: {
                        return new Short(constant.shortValue());
                    }
                    case 2: {
                        return new Character(constant.charValue());
                    }
                    case 9: {
                        return new Float(constant.floatValue());
                    }
                    case 8: {
                        return new Double(constant.doubleValue());
                    }
                    case 5: {
                        return constant.booleanValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 7: {
                        return new Long(constant.longValue());
                    }
                    case 11: {
                        return constant.stringValue();
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    synchronized IFunctionBinding resolveConstructor(ClassInstanceCreation expression) {
        org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node != null && (node.bits & 0x200) != 0) {
            org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration anonymousLocalTypeDeclaration = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)node;
            return this.getMethodBinding(anonymousLocalTypeDeclaration.allocation.binding);
        }
        if (node instanceof AllocationExpression) {
            return this.getMethodBinding(((AllocationExpression)node).binding);
        }
        return null;
    }

    @Override
    synchronized IFunctionBinding resolveConstructor(ConstructorInvocation expression) {
        org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node instanceof ExplicitConstructorCall) {
            ExplicitConstructorCall explicitConstructorCall = (ExplicitConstructorCall)node;
            return this.getMethodBinding(explicitConstructorCall.binding);
        }
        return null;
    }

    @Override
    synchronized IFunctionBinding resolveConstructor(SuperConstructorInvocation expression) {
        org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
        if (node instanceof ExplicitConstructorCall) {
            ExplicitConstructorCall explicitConstructorCall = (ExplicitConstructorCall)node;
            return this.getMethodBinding(explicitConstructorCall.binding);
        }
        return null;
    }

    @Override
    synchronized ITypeBinding resolveExpressionType(Expression expression) {
        try {
            switch (expression.getNodeType()) {
                case 14: {
                    org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode astNode = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(expression);
                    if (astNode instanceof org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration) {
                        org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDeclaration = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)astNode;
                        ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
                        if (typeBinding != null) {
                            return typeBinding;
                        }
                        break;
                    }
                    AllocationExpression allocationExpression = (AllocationExpression)astNode;
                    return this.getTypeBinding(allocationExpression.resolvedType);
                }
                case 40: 
                case 42: {
                    return this.resolveTypeBindingForName((Name)expression);
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 16: 
                case 22: 
                case 27: 
                case 32: 
                case 37: 
                case 38: 
                case 45: 
                case 47: 
                case 48: 
                case 57: 
                case 62: {
                    if (this.scope != null) {
                        return this.getTypeBinding(this.scope.getJavaLangString());
                    }
                    break;
                }
                case 9: 
                case 13: 
                case 33: 
                case 34: 
                case 87: 
                case 88: {
                    Literal literal = (Literal)this.newAstToOldAst.get(expression);
                    return this.getTypeBinding(literal.literalType(this.scope));
                }
                case 52: {
                    ThisReference thisReference = (ThisReference)this.newAstToOldAst.get(expression);
                    BlockScope blockScope = (BlockScope)this.astNodesToBlockScope.get(expression);
                    if (blockScope != null) {
                        return this.getTypeBinding(thisReference.resolveType(blockScope));
                    }
                    break;
                }
                case 36: {
                    ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
                    return this.resolveExpressionType(parenthesizedExpression.getExpression());
                }
                case 58: {
                    VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)expression;
                    Type type = variableDeclarationExpression.getType();
                    if (type != null) {
                        return type.resolveBinding();
                    }
                    break;
                }
            }
        }
        catch (AbortCompilation abortCompilation) {}
        return null;
    }

    @Override
    synchronized IVariableBinding resolveField(FieldAccess fieldAccess) {
        Object oldNode = this.newAstToOldAst.get(fieldAccess);
        if (oldNode instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)oldNode;
            return this.getVariableBinding(fieldReference.binding);
        }
        return null;
    }

    @Override
    synchronized IVariableBinding resolveField(SuperFieldAccess fieldAccess) {
        Object oldNode = this.newAstToOldAst.get(fieldAccess);
        if (oldNode instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)oldNode;
            return this.getVariableBinding(fieldReference.binding);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    synchronized IBinding resolveImport(ImportDeclaration importDeclaration) {
        if (this.scope == null) {
            return null;
        }
        try {
            org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(importDeclaration);
            if (!(node instanceof ImportReference)) return null;
            ImportReference importReference = (ImportReference)node;
            if ((importReference.bits & 0x20000) != 0) {
                Binding binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, importReference.tokens.length), true);
                if (binding == null) return null;
                if ((binding.kind() & 0x4000) != 0) {
                    IPackageBinding packageBinding = this.getPackageBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding)binding);
                    if (packageBinding != null) return packageBinding;
                    return null;
                }
                ITypeBinding typeBinding = this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
                if (typeBinding != null) return typeBinding;
                return null;
            }
            Binding binding = this.scope.getImport(importReference.tokens, false);
            if (binding == null) return null;
            if (!(binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)) return null;
            ITypeBinding typeBinding = this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
            if (typeBinding == null) {
                return null;
            }
            ITypeBinding iTypeBinding = typeBinding;
            return iTypeBinding;
        }
        catch (AbortCompilation abortCompilation) {}
        return null;
    }

    @Override
    synchronized IFunctionBinding resolveMethod(FunctionDeclaration method) {
        Object oldNode = this.newAstToOldAst.get(method);
        if (oldNode instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)oldNode;
            IFunctionBinding methodBinding = this.getMethodBinding(methodDeclaration.getBinding());
            if (methodBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(methodBinding, method);
            String key = methodBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, methodBinding);
            }
            return methodBinding;
        }
        return null;
    }

    @Override
    synchronized IFunctionBinding resolveMethod(FunctionInvocation method) {
        Object oldNode = this.newAstToOldAst.get(method);
        if (oldNode instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)oldNode;
            return this.getMethodBinding(messageSend.binding);
        }
        return null;
    }

    @Override
    synchronized IFunctionBinding resolveMethod(SuperMethodInvocation method) {
        Object oldNode = this.newAstToOldAst.get(method);
        if (oldNode instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)oldNode;
            return this.getMethodBinding(messageSend.binding);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized ITypeBinding resolveTypeBindingForName(Name name) {
        org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node;
        block56: {
            block58: {
                int index;
                block57: {
                    block55: {
                        node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(name);
                        index = name.index;
                        if (!(node instanceof QualifiedNameReference)) break block55;
                        QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)node;
                        char[][] tokens = qualifiedNameReference.tokens;
                        if (tokens.length == index) {
                            return this.getTypeBinding(qualifiedNameReference.resolvedType);
                        }
                        int indexOfFirstFieldBinding = qualifiedNameReference.indexOfFirstFieldBinding;
                        if (index < indexOfFirstFieldBinding) {
                            void var8_39;
                            BlockScope internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
                            Object var8_36 = null;
                            try {
                                if (internalScope == null) {
                                    if (this.scope == null) {
                                        return null;
                                    }
                                    Binding binding = this.scope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index));
                                } else {
                                    Binding binding = internalScope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index));
                                }
                            }
                            catch (AbortCompilation abortCompilation) {}
                            if (var8_39 instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding) {
                                return null;
                            }
                            if (var8_39 instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding) {
                                return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)var8_39);
                            }
                            break block56;
                        } else {
                            void var9_48;
                            if (index == indexOfFirstFieldBinding) {
                                void var8_43;
                                if (qualifiedNameReference.isTypeReference()) {
                                    return this.getTypeBinding(qualifiedNameReference.resolvedType);
                                }
                                if (qualifiedNameReference.otherBindings == null) {
                                    return null;
                                }
                                FieldBinding fieldBinding = qualifiedNameReference.otherBindings[0];
                                if (fieldBinding == null) {
                                    return null;
                                }
                                ReferenceBinding referenceBinding = fieldBinding.declaringClass;
                                if (referenceBinding != null) return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)var8_43);
                                switch (qualifiedNameReference.bits & 0xF) {
                                    case 1: {
                                        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = ((FieldBinding)qualifiedNameReference.binding).type;
                                        return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)var8_43);
                                    }
                                    case 2: {
                                        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = ((LocalVariableBinding)qualifiedNameReference.binding).type;
                                        return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)var8_43);
                                    }
                                }
                                return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)var8_43);
                            }
                            if (qualifiedNameReference.otherBindings == null) {
                                return null;
                            }
                            int otherBindingsLength = qualifiedNameReference.otherBindings.length;
                            if (otherBindingsLength == index - indexOfFirstFieldBinding) {
                                return this.getTypeBinding(qualifiedNameReference.resolvedType);
                            }
                            FieldBinding fieldBinding = qualifiedNameReference.otherBindings[index - indexOfFirstFieldBinding];
                            if (fieldBinding == null) {
                                return null;
                            }
                            ReferenceBinding referenceBinding = fieldBinding.declaringClass;
                            if (referenceBinding != null) return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)var9_48);
                            FieldBinding fieldBinding2 = qualifiedNameReference.otherBindings[index - indexOfFirstFieldBinding - 1];
                            if (fieldBinding2 == null) {
                                return null;
                            }
                            org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding typeBinding = fieldBinding2.type;
                            return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)var9_48);
                        }
                    }
                    if (!(node instanceof QualifiedTypeReference)) break block57;
                    QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)node;
                    if (qualifiedTypeReference.resolvedType == null) {
                        return null;
                    }
                    if (index == qualifiedTypeReference.tokens.length) {
                        if (qualifiedTypeReference.resolvedType.isValidBinding()) return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                        if (!(qualifiedTypeReference instanceof JavadocQualifiedTypeReference)) return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                        JavadocQualifiedTypeReference typeRef = (JavadocQualifiedTypeReference)node;
                        if (typeRef.packageBinding == null) return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                        return null;
                    }
                    if (index >= 0) {
                        BlockScope internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
                        Binding binding = null;
                        try {
                            if (internalScope == null) {
                                if (this.scope == null) {
                                    return null;
                                }
                                binding = this.scope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index));
                            } else {
                                binding = internalScope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index));
                            }
                        }
                        catch (AbortCompilation abortCompilation) {}
                        if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding) {
                            return null;
                        }
                        if (!(binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)) return null;
                        return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
                    }
                    break block56;
                }
                if (!(node instanceof ImportReference)) break block58;
                ImportReference importReference = (ImportReference)node;
                int importReferenceLength = importReference.tokens.length;
                if (index >= 0) {
                    Binding binding = null;
                    if (this.scope == null) {
                        return null;
                    }
                    if (importReferenceLength == index) {
                        try {
                            binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), (importReference.bits & 0x20000) != 0);
                        }
                        catch (AbortCompilation abortCompilation) {}
                    } else {
                        try {
                            binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), true);
                        }
                        catch (AbortCompilation abortCompilation) {}
                    }
                    if (binding != null) {
                        if (!(binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)) return null;
                        return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
                    }
                }
                break block56;
            }
            if (node instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)node;
                IFunctionBinding method = this.getMethodBinding(abstractMethodDeclaration.getBinding());
                if (method != null) return method.getReturnType();
                return null;
            }
            if (node instanceof org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration) {
                org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDeclaration = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)node;
                ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
                if (typeBinding != null) {
                    return typeBinding;
                }
            }
        }
        if (node instanceof JavadocSingleNameReference) {
            JavadocSingleNameReference javadocSingleNameReference = (JavadocSingleNameReference)node;
            LocalVariableBinding localVariable = (LocalVariableBinding)javadocSingleNameReference.binding;
            if (localVariable != null) {
                return this.getTypeBinding(localVariable.type);
            }
        }
        if (node instanceof SingleNameReference) {
            SingleNameReference singleNameReference = (SingleNameReference)node;
            return this.getTypeBinding(singleNameReference.resolvedType);
        }
        if (node instanceof LocalDeclaration) {
            IVariableBinding iVariableBinding = this.getVariableBinding(((LocalDeclaration)node).binding);
            if (iVariableBinding != null) return iVariableBinding.getType();
            return null;
        }
        if (node instanceof JavadocFieldReference) {
            JavadocFieldReference javadocFieldReference = (JavadocFieldReference)node;
            if (javadocFieldReference.methodBinding == null) return this.getTypeBinding(javadocFieldReference.resolvedType);
            return this.getMethodBinding(javadocFieldReference.methodBinding).getReturnType();
        }
        if (node instanceof FieldReference) {
            return this.getTypeBinding(((FieldReference)node).resolvedType);
        }
        if (node instanceof SingleTypeReference) {
            SingleTypeReference singleTypeReference = (SingleTypeReference)node;
            org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding binding = singleTypeReference.resolvedType;
            if (binding == null) return null;
            return this.getTypeBinding(binding.leafComponentType());
        }
        if (node instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            IVariableBinding field = this.getVariableBinding(fieldDeclaration.binding);
            if (field != null) return field.getType();
            return null;
        }
        if (node instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)node;
            IFunctionBinding method = this.getMethodBinding(messageSend.binding);
            if (method != null) return method.getReturnType();
            return null;
        }
        if (node instanceof AllocationExpression) {
            AllocationExpression allocationExpression = (AllocationExpression)node;
            return this.getTypeBinding(allocationExpression.resolvedType);
        }
        if (!(node instanceof JavadocImplicitTypeReference)) return null;
        JavadocImplicitTypeReference javadocImplicitTypeReference = (JavadocImplicitTypeReference)node;
        return this.getTypeBinding(javadocImplicitTypeReference.resolvedType);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    synchronized IBinding resolveName(Name name) {
        block77: {
            block76: {
                block78: {
                    block73: {
                        block75: {
                            block70: {
                                block69: {
                                    block71: {
                                        block74: {
                                            block72: {
                                                block68: {
                                                    block67: {
                                                        node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(name);
                                                        index = name.index;
                                                        if (!(node instanceof QualifiedNameReference)) break block71;
                                                        qualifiedNameReference = (QualifiedNameReference)node;
                                                        tokens = qualifiedNameReference.tokens;
                                                        indexOfFirstFieldBinding = qualifiedNameReference.indexOfFirstFieldBinding;
                                                        if (index >= indexOfFirstFieldBinding) break block72;
                                                        internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
                                                        binding = null;
                                                        try {
                                                            if (internalScope != null) ** GOTO lbl19
                                                            if (this.scope != null) break block67;
                                                            return null;
                                                        }
                                                        catch (AbortCompilation v0) {}
                                                    }
                                                    binding = this.scope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index));
                                                    break block68;
lbl19:
                                                    // 1 sources

                                                    binding = internalScope.getTypeOrPackage(CharOperation.subarray(tokens, 0, index));
                                                }
                                                if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding) {
                                                    return this.getPackageBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding)binding);
                                                }
                                                if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding) {
                                                    return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
                                                }
                                                break block73;
                                            }
                                            if (index != indexOfFirstFieldBinding) break block74;
                                            if (qualifiedNameReference.isTypeReference()) {
                                                return this.getTypeBinding(qualifiedNameReference.resolvedType);
                                            }
                                            binding = qualifiedNameReference.binding;
                                            if (binding == null) break block73;
                                            if (binding.isValidBinding()) {
                                                return this.getVariableBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding)binding);
                                            }
                                            if (!(binding instanceof ProblemFieldBinding)) break block73;
                                            problemFieldBinding = (ProblemFieldBinding)binding;
                                            switch (problemFieldBinding.problemId()) {
                                                case 2: 
                                                case 7: {
                                                    declaringClass = problemFieldBinding.declaringClass;
                                                    if (declaringClass != null && (exactBinding = declaringClass.getField(tokens[tokens.length - 1], true)) != null && exactBinding.type != null) {
                                                        variableBinding = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                                                        if (variableBinding != null) {
                                                            return variableBinding;
                                                        }
                                                        variableBinding = new VariableBinding(this, exactBinding);
                                                        this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, variableBinding);
                                                        return variableBinding;
                                                    }
                                                    break block73;
                                                }
                                                default: {
                                                    ** break;
                                                }
                                            }
lbl52:
                                            // 1 sources

                                            break block73;
                                        }
                                        if (qualifiedNameReference.otherBindings == null || index - indexOfFirstFieldBinding - 1 < 0) {
                                            return null;
                                        }
                                        return this.getVariableBinding(qualifiedNameReference.otherBindings[index - indexOfFirstFieldBinding - 1]);
                                    }
                                    if (!(node instanceof QualifiedTypeReference)) break block75;
                                    qualifiedTypeReference = (QualifiedTypeReference)node;
                                    if (qualifiedTypeReference.resolvedType == null) {
                                        return null;
                                    }
                                    if (index == qualifiedTypeReference.tokens.length) {
                                        if (!qualifiedTypeReference.resolvedType.isValidBinding() && qualifiedTypeReference instanceof JavadocQualifiedTypeReference) {
                                            typeRef = (JavadocQualifiedTypeReference)node;
                                            if (typeRef.packageBinding != null) {
                                                return this.getPackageBinding(typeRef.packageBinding);
                                            }
                                        }
                                        return this.getTypeBinding(qualifiedTypeReference.resolvedType.leafComponentType());
                                    }
                                    if (index < 0) break block73;
                                    internalScope = (BlockScope)this.astNodesToBlockScope.get(name);
                                    binding = null;
                                    try {
                                        if (internalScope != null) ** GOTO lbl80
                                        if (this.scope != null) break block69;
                                        return null;
                                    }
                                    catch (AbortCompilation v1) {}
                                }
                                binding = this.scope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index));
                                break block70;
lbl80:
                                // 1 sources

                                binding = internalScope.getTypeOrPackage(CharOperation.subarray(qualifiedTypeReference.tokens, 0, index));
                            }
                            if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding) {
                                return this.getPackageBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding)binding);
                            }
                            if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding) {
                                return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
                            }
                            return null;
                        }
                        if (node instanceof ImportReference) {
                            importReference = (ImportReference)node;
                            importReferenceLength = importReference.tokens.length;
                            if (index >= 0) {
                                binding = null;
                                if (this.scope == null) {
                                    return null;
                                }
                                if (importReferenceLength == index) {
                                    try {
                                        binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), (importReference.bits & 131072) != 0);
                                    }
                                    catch (AbortCompilation v2) {}
                                } else {
                                    try {
                                        binding = this.scope.getImport(CharOperation.subarray(importReference.tokens, 0, index), true);
                                    }
                                    catch (AbortCompilation v3) {}
                                }
                                if (binding != null) {
                                    if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding) {
                                        return this.getPackageBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding)binding);
                                    }
                                    if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding) {
                                        return this.getTypeBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding)binding);
                                    }
                                    if (binding instanceof FieldBinding) {
                                        return this.getVariableBinding((FieldBinding)binding);
                                    }
                                    if (binding instanceof MethodBinding) {
                                        return this.getMethodBinding((MethodBinding)binding);
                                    }
                                    return null;
                                }
                            }
                        } else if (node instanceof CompilationUnitDeclaration) {
                            compilationUnitDeclaration = (CompilationUnitDeclaration)node;
                            types = compilationUnitDeclaration.types;
                            if (types == null || types.length == 0) {
                                return null;
                            }
                            type = types[0];
                            if (type != null && (typeBinding = this.getTypeBinding(type.binding)) != null) {
                                return typeBinding.getPackage();
                            }
                        } else if (node instanceof AbstractMethodDeclaration) {
                            methodDeclaration = (AbstractMethodDeclaration)node;
                            methodBinding = this.getMethodBinding(methodDeclaration.getBinding());
                            if (methodBinding != null) {
                                return methodBinding;
                            }
                        } else if (node instanceof org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration) {
                            typeDeclaration = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)node;
                            typeBinding = this.getTypeBinding(typeDeclaration.binding);
                            if (typeBinding != null) {
                                return typeBinding;
                            }
                        }
                    }
                    if (!(node instanceof SingleNameReference)) break block76;
                    singleNameReference = (SingleNameReference)node;
                    if (singleNameReference.isTypeReference()) {
                        return this.getTypeBinding(singleNameReference.resolvedType);
                    }
                    binding = singleNameReference.binding;
                    if (binding == null) break block77;
                    if (!binding.isValidBinding()) break block78;
                    if (binding instanceof org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding) {
                        return this.getVariableBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding)binding);
                    }
                    if (binding instanceof MethodBinding) {
                        return this.getMethodBinding((MethodBinding)binding);
                    }
                    break block77;
                }
                if (!(binding instanceof ProblemFieldBinding)) break block77;
                problemFieldBinding = (ProblemFieldBinding)binding;
                switch (problemFieldBinding.problemId()) {
                    case 2: 
                    case 6: 
                    case 7: {
                        declaringClass = problemFieldBinding.declaringClass;
                        exactBinding = declaringClass.getField(problemFieldBinding.name, true);
                        if (exactBinding != null && exactBinding.type != null) {
                            variableBinding2 = (IVariableBinding)this.bindingTables.compilerBindingsToASTBindings.get(exactBinding);
                            if (variableBinding2 != null) {
                                return variableBinding2;
                            }
                            variableBinding2 = new VariableBinding(this, exactBinding);
                            this.bindingTables.compilerBindingsToASTBindings.put(exactBinding, variableBinding2);
                            return variableBinding2;
                        }
                        break block77;
                    }
                    default: {
                        ** break;
                    }
                }
lbl170:
                // 1 sources

                break block77;
            }
            if (node instanceof LocalDeclaration) {
                return this.getVariableBinding(((LocalDeclaration)node).binding);
            }
            if (node instanceof JavadocFieldReference) {
                fieldRef = (JavadocFieldReference)node;
                if (fieldRef.methodBinding != null) {
                    return this.getMethodBinding(fieldRef.methodBinding);
                }
                return this.getVariableBinding(fieldRef.binding);
            }
            if (node instanceof FieldReference) {
                return this.getVariableBinding(((FieldReference)node).binding);
            }
            if (node instanceof SingleTypeReference) {
                singleTypeReference = (SingleTypeReference)node;
                binding = singleTypeReference.resolvedType;
                if (binding != null) {
                    if (!binding.isValidBinding() && node instanceof JavadocSingleTypeReference) {
                        typeRef = (JavadocSingleTypeReference)node;
                        if (typeRef.packageBinding != null) {
                            return this.getPackageBinding(typeRef.packageBinding);
                        }
                    }
                    return this.getTypeBinding(binding.leafComponentType());
                }
            } else {
                if (node instanceof FieldDeclaration) {
                    fieldDeclaration = (FieldDeclaration)node;
                    return this.getVariableBinding(fieldDeclaration.binding);
                }
                if (node instanceof MessageSend) {
                    messageSend = (MessageSend)node;
                    return this.getMethodBinding(messageSend.binding);
                }
                if (node instanceof AllocationExpression) {
                    allocation = (AllocationExpression)node;
                    return this.getMethodBinding(allocation.binding);
                }
                if (node instanceof JavadocImplicitTypeReference) {
                    implicitRef = (JavadocImplicitTypeReference)node;
                    return this.getTypeBinding(implicitRef.resolvedType);
                }
            }
        }
        return null;
    }

    @Override
    synchronized IPackageBinding resolvePackage(PackageDeclaration pkg) {
        block5: {
            IPackageBinding packageBinding;
            block6: {
                if (this.scope == null) {
                    return null;
                }
                try {
                    org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(pkg);
                    if (!(node instanceof ImportReference)) break block5;
                    ImportReference importReference = (ImportReference)node;
                    Binding binding = this.scope.getTypeOrPackage(CharOperation.subarray(importReference.tokens, 0, importReference.tokens.length));
                    if (binding == null || !binding.isValidBinding()) break block5;
                    packageBinding = this.getPackageBinding((org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding)binding);
                    if (packageBinding != null) break block6;
                    return null;
                }
                catch (AbortCompilation abortCompilation) {}
            }
            this.bindingsToAstNodes.put(packageBinding, pkg);
            String key = packageBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, packageBinding);
            }
            return packageBinding;
        }
        return null;
    }

    @Override
    synchronized IBinding resolveReference(MemberRef ref) {
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression = (org.eclipse.wst.jsdt.internal.compiler.ast.Expression)this.newAstToOldAst.get(ref);
        if (expression instanceof TypeReference) {
            return this.getTypeBinding(expression.resolvedType);
        }
        if (expression instanceof JavadocFieldReference) {
            JavadocFieldReference fieldRef = (JavadocFieldReference)expression;
            if (fieldRef.methodBinding != null) {
                return this.getMethodBinding(fieldRef.methodBinding);
            }
            return this.getVariableBinding(fieldRef.binding);
        }
        return null;
    }

    @Override
    synchronized IBinding resolveReference(FunctionRef ref) {
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression = (org.eclipse.wst.jsdt.internal.compiler.ast.Expression)this.newAstToOldAst.get(ref);
        if (expression instanceof JavadocMessageSend) {
            return this.getMethodBinding(((JavadocMessageSend)expression).binding);
        }
        if (expression instanceof JavadocAllocationExpression) {
            return this.getMethodBinding(((JavadocAllocationExpression)expression).binding);
        }
        return null;
    }

    @Override
    synchronized ITypeBinding resolveType(AnonymousClassDeclaration type) {
        org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(type);
        if (node != null && (node.bits & 0x200) != 0) {
            org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration anonymousLocalTypeDeclaration = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)node;
            ITypeBinding typeBinding = this.getTypeBinding(anonymousLocalTypeDeclaration.binding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, type);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    @Override
    synchronized ITypeBinding resolveType(Type type) {
        org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = (org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode)this.newAstToOldAst.get(type);
        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding binding = null;
        if (node != null) {
            if (node instanceof TypeReference) {
                TypeReference typeReference = (TypeReference)node;
                binding = typeReference.resolvedType;
            } else if (node instanceof SingleNameReference && ((SingleNameReference)node).isTypeReference()) {
                binding = ((SingleNameReference)node).resolvedType;
            } else if (node instanceof QualifiedNameReference && ((QualifiedNameReference)node).isTypeReference()) {
                binding = ((QualifiedNameReference)node).resolvedType;
            } else if (node instanceof ArrayAllocationExpression) {
                binding = ((ArrayAllocationExpression)node).resolvedType;
            }
            if (binding != null) {
                if (type.isArrayType()) {
                    ArrayType arrayType = (ArrayType)type;
                    if (this.scope == null) {
                        return null;
                    }
                    if (binding.isArrayType()) {
                        ArrayBinding arrayBinding = (ArrayBinding)binding;
                        return this.getTypeBinding(this.scope.createArrayType(arrayBinding.leafComponentType, arrayType.getDimensions()));
                    }
                    return this.getTypeBinding(this.scope.createArrayType(binding, arrayType.getDimensions()));
                }
                if (binding.isArrayType()) {
                    ArrayBinding arrayBinding = (ArrayBinding)binding;
                    return this.getTypeBinding(arrayBinding.leafComponentType);
                }
                return this.getTypeBinding(binding);
            }
        } else if (type.isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID) {
            return this.getTypeBinding(org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.VOID);
        }
        return null;
    }

    @Override
    synchronized ITypeBinding resolveType(TypeDeclaration type) {
        Object node = this.newAstToOldAst.get(type);
        if (node instanceof org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration) {
            org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDeclaration = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)node;
            ITypeBinding typeBinding = this.getTypeBinding(typeDeclaration.binding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, type);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    @Override
    ITypeBinding resolveType(JavaScriptUnit compilationUnit) {
        Object node = this.newAstToOldAst.get(compilationUnit);
        if (node instanceof CompilationUnitDeclaration) {
            CompilationUnitDeclaration compilationUnitDeclaration = (CompilationUnitDeclaration)node;
            ITypeBinding typeBinding = this.getTypeBinding(compilationUnitDeclaration.compilationUnitBinding);
            if (typeBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(typeBinding, compilationUnit);
            String key = typeBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, typeBinding);
            }
            return typeBinding;
        }
        return null;
    }

    @Override
    synchronized IVariableBinding resolveVariable(VariableDeclaration variable) {
        Object node = this.newAstToOldAst.get(variable);
        if (node instanceof AbstractVariableDeclaration) {
            AbstractVariableDeclaration abstractVariableDeclaration = (AbstractVariableDeclaration)node;
            if (abstractVariableDeclaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)abstractVariableDeclaration;
                IVariableBinding variableBinding = this.getVariableBinding(fieldDeclaration.binding, variable);
                if (variableBinding == null) {
                    return null;
                }
                this.bindingsToAstNodes.put(variableBinding, variable);
                String key = variableBinding.getKey();
                if (key != null) {
                    this.bindingTables.bindingKeysToBindings.put(key, variableBinding);
                }
                return variableBinding;
            }
            IVariableBinding variableBinding = this.getVariableBinding(((LocalDeclaration)abstractVariableDeclaration).binding, variable);
            if (variableBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(variableBinding, variable);
            String key = variableBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, variableBinding);
            }
            return variableBinding;
        }
        return null;
    }

    @Override
    synchronized IVariableBinding resolveVariable(VariableDeclarationStatement variable) {
        Object node = this.newAstToOldAst.get(variable);
        if (node instanceof AbstractVariableDeclaration) {
            AbstractVariableDeclaration abstractVariableDeclaration = (AbstractVariableDeclaration)node;
            if (abstractVariableDeclaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)abstractVariableDeclaration;
                IVariableBinding variableBinding = this.getVariableBinding(fieldDeclaration.binding);
                if (variableBinding == null) {
                    return null;
                }
                this.bindingsToAstNodes.put(variableBinding, variable);
                String key = variableBinding.getKey();
                if (key != null) {
                    this.bindingTables.bindingKeysToBindings.put(key, variableBinding);
                }
                return variableBinding;
            }
            IVariableBinding variableBinding = this.getVariableBinding(((LocalDeclaration)abstractVariableDeclaration).binding);
            if (variableBinding == null) {
                return null;
            }
            this.bindingsToAstNodes.put(variableBinding, variable);
            String key = variableBinding.getKey();
            if (key != null) {
                this.bindingTables.bindingKeysToBindings.put(key, variableBinding);
            }
            return variableBinding;
        }
        return null;
    }

    @Override
    synchronized ITypeBinding resolveWellKnownType(String name) {
        if (this.scope == null) {
            return null;
        }
        try {
            if ("Object".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangObject());
            }
            if ("String".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangString());
            }
            if ("Number".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangNumber());
            }
            if ("Function".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangFunction());
            }
            if ("Boolean".equals(name)) {
                return this.getTypeBinding(this.scope.getJavaLangBoolean());
            }
        }
        catch (AbortCompilation abortCompilation) {}
        return null;
    }

    @Override
    public CompilationUnitScope scope() {
        return this.scope;
    }

    @Override
    synchronized void store(ASTNode node, org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode oldASTNode) {
        this.newAstToOldAst.put(node, oldASTNode);
    }

    @Override
    synchronized void updateKey(ASTNode node, ASTNode newNode) {
        Object astNode = this.newAstToOldAst.remove(node);
        if (astNode != null) {
            this.newAstToOldAst.put(newNode, astNode);
        }
    }

    @Override
    ITypeBinding resolveArrayType(ITypeBinding typeBinding, int dimensions) {
        if (typeBinding.isRecovered()) {
            throw new IllegalArgumentException("Cannot be called on a recovered type binding");
        }
        ITypeBinding leafComponentType = typeBinding;
        int actualDimensions = dimensions;
        if (typeBinding.isArray()) {
            leafComponentType = typeBinding.getElementType();
            actualDimensions += typeBinding.getDimensions();
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding leafTypeBinding = null;
        if (leafComponentType.isPrimitive()) {
            String name = leafComponentType.getBinaryName();
            switch (name.charAt(0)) {
                case 'I': {
                    leafTypeBinding = org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.INT;
                    break;
                }
                case 'Z': {
                    leafTypeBinding = org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.BOOLEAN;
                    break;
                }
                case 'C': {
                    leafTypeBinding = org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.CHAR;
                    break;
                }
                case 'J': {
                    leafTypeBinding = org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.LONG;
                    break;
                }
                case 'S': {
                    leafTypeBinding = org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.SHORT;
                    break;
                }
                case 'D': {
                    leafTypeBinding = org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.DOUBLE;
                    break;
                }
                case 'F': {
                    leafTypeBinding = org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding.FLOAT;
                    break;
                }
                case 'V': {
                    throw new IllegalArgumentException();
                }
            }
        } else {
            leafTypeBinding = ((TypeBinding)leafComponentType).binding;
        }
        if (!(leafComponentType instanceof TypeBinding)) {
            return null;
        }
        return this.getTypeBinding(this.lookupEnvironment().createArrayType(leafTypeBinding, actualDimensions));
    }

    static class BindingTables {
        Map bindingKeysToBindings;
        Map compilerBindingsToASTBindings = new HashMap();

        BindingTables() {
            this.bindingKeysToBindings = new HashMap();
        }
    }
}

