/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.jdt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;

public class Annotation {
    public static final String VALUE = "value";
    private final IAnnotation javaAnnotation;
    private final String javaAnnotationName;
    private final Map<String, List<String>> javaAnnotationElements;

    public Annotation(IAnnotation annotation, String annotationName, Map<String, List<String>> annotationElements) {
        this.javaAnnotation = annotation;
        this.javaAnnotationName = annotationName;
        this.javaAnnotationElements = new HashMap<String, List<String>>(annotationElements);
    }

    public Annotation(IAnnotation annotation, String annotationName, String annotationValue) {
        this(annotation, annotationName, CollectionUtils.toMap(VALUE, Arrays.asList(annotationValue)));
    }

    public boolean update(Annotation otherAnnotation) {
        if (otherAnnotation == null || !this.hasChanges(otherAnnotation)) {
            return false;
        }
        this.javaAnnotationElements.clear();
        this.javaAnnotationElements.putAll(otherAnnotation.getJavaAnnotationElements());
        return true;
    }

    public boolean hasChanges(Annotation otherAnnotation) {
        return !this.javaAnnotationElements.equals(otherAnnotation.getJavaAnnotationElements());
    }

    public IAnnotation getJavaAnnotation() {
        return this.javaAnnotation;
    }

    public IJavaElement getJavaParent() {
        if (this.javaAnnotation == null) {
            return null;
        }
        return this.javaAnnotation.getParent();
    }

    public String getFullyQualifiedName() {
        return this.javaAnnotationName;
    }

    public Map<String, List<String>> getJavaAnnotationElements() {
        return this.javaAnnotationElements;
    }

    public List<String> getValues(String elementName) {
        return this.javaAnnotationElements.get(elementName);
    }

    public String getValue() {
        return this.getValue(VALUE);
    }

    public List<String> getValues() {
        return this.getValues(VALUE);
    }

    public String getValue(String elementName) {
        List<String> values = this.javaAnnotationElements.get(elementName);
        if (values != null) {
            assert (values.size() <= 1);
            if (values.size() == 1) {
                return values.get(0);
            }
        }
        return null;
    }

    public String toString() {
        return "Annotation [" + this.javaAnnotationName + " " + this.javaAnnotationElements + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.javaAnnotation == null ? 0 : this.javaAnnotation.getHandleIdentifier().hashCode());
        result = 31 * result + (this.javaAnnotationElements == null ? 0 : this.javaAnnotationElements.hashCode());
        result = 31 * result + (this.javaAnnotationName == null ? 0 : this.javaAnnotationName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (this.javaAnnotationElements == null ? other.javaAnnotationElements != null : !this.javaAnnotationElements.equals(other.javaAnnotationElements)) {
            return false;
        }
        return !(this.javaAnnotationName == null ? other.javaAnnotationName != null : !this.javaAnnotationName.equals(other.javaAnnotationName));
    }
}

