/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.ws.jaxrs.core.JBossJaxrsCorePlugin;

public final class Logger {
    private static final String INFO = "org.jboss.tools.ws.jaxrs.core/info";
    private static final String DEBUG = "org.jboss.tools.ws.jaxrs.core/debug";
    private static final String DEBUG_INDEXING = "org.jboss.tools.ws.jaxrs.core/debugIndexing";
    private static final String TRACE = "org.jboss.tools.ws.jaxrs.core/trace";
    private static final String TRACE_INDEXING = "org.jboss.tools.ws.jaxrs.core/traceIndexing";
    private static final String TRACE_PERF = "org.jboss.tools.ws.jaxrs.core/tracePerf";
    private static final String TRACE_INDEXING_PERF = "org.jboss.tools.ws.jaxrs.core/traceIndexingPerf";
    private static final ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    private Logger() {
    }

    public static Status error(String message, Throwable t) {
        Status status = new Status(4, "org.jboss.tools.ws.jaxrs.core", message, t);
        if (JBossJaxrsCorePlugin.getDefault() != null) {
            JBossJaxrsCorePlugin.getDefault().getLog().log((IStatus)status);
        } else {
            t.printStackTrace();
        }
        return status;
    }

    public static void error(String message) {
        JBossJaxrsCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.ws.jaxrs.core", message));
    }

    public static void warn(String message, Throwable t) {
        JBossJaxrsCorePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.ws.jaxrs.core", message, t));
    }

    public static void warn(String message) {
        JBossJaxrsCorePlugin.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.ws.jaxrs.core", message));
    }

    public static void info(String message) {
        if (Logger.isOptionEnabled(INFO)) {
            JBossJaxrsCorePlugin.getDefault().getLog().log((IStatus)new Status(1, "org.jboss.tools.ws.jaxrs.core", message));
        }
    }

    public static void debug(String message) {
        Logger.debug(message, null);
    }

    public static void debug(String message, Object ... items) {
        Logger.log(DEBUG, message, items);
    }

    public static void debugIndexing(String message, Object ... items) {
        Logger.log(DEBUG_INDEXING, message, items);
    }

    public static void trace(String message, Object ... items) {
        Logger.log(TRACE, message, items);
    }

    public static void traceIndexing(String message, Object ... items) {
        Logger.log(TRACE_INDEXING, message, items);
    }

    public static void tracePerf(String message, Object ... items) {
        Logger.log(TRACE_PERF, message, items);
    }

    public static void traceIndexingPerf(String message, Object ... items) {
        Logger.log(TRACE_INDEXING_PERF, message, items);
    }

    /*
     * Unable to fully structure code
     */
    private static void log(String level, String message, Object ... items) {
        block3: {
            try {
                if (!Logger.isOptionEnabled(level)) break block3;
                valuedMessage = Logger.getMessage(message, items);
                System.out.println(String.valueOf(Logger.dateFormatter.get().format(new Date())) + " [" + Thread.currentThread().getName() + "] " + Logger.toLevel(level) + " " + valuedMessage);
                break block3;
            }
            catch (RuntimeException v0) {
                System.err.println("Failed to write proper debug message with template:\n " + message + "\n and items:");
                var6_5 = items;
                var5_6 = items.length;
                var4_7 = 0;
                ** while (var4_7 < var5_6)
            }
lbl-1000:
            // 1 sources

            {
                item = var6_5[var4_7];
                System.err.println(" " + item);
                ++var4_7;
                continue;
            }
        }
    }

    public static String getMessage(String message, Object ... items) {
        String valuedMessage = message;
        if (items != null) {
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                valuedMessage = valuedMessage.replaceFirst("\\{\\}", item != null ? item.toString().replaceAll("\\$", ".") : "null");
                ++n2;
            }
        }
        return valuedMessage;
    }

    private static String toLevel(String level) {
        if (level.equals(DEBUG)) {
            return "DEBUG";
        }
        if (level.equals(DEBUG_INDEXING)) {
            return "DEBUG_INDEXING";
        }
        if (level.equals(TRACE)) {
            return "TRACE";
        }
        if (level.equals(TRACE_INDEXING)) {
            return "TRACE_INDEXING";
        }
        if (level.equals(TRACE_PERF)) {
            return "TRACE_PERF";
        }
        return "UNKNOWN_LEVEL";
    }

    private static boolean isOptionEnabled(String level) {
        String debugOption = Platform.getDebugOption((String)level);
        return JBossJaxrsCorePlugin.getDefault() != null && JBossJaxrsCorePlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption);
    }

    public static boolean isDebugEnabled() {
        return Logger.isOptionEnabled(DEBUG);
    }

    public static boolean isDebugIndexingEnabled() {
        return Logger.isOptionEnabled(DEBUG_INDEXING);
    }
}

