/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.utils;

import java.lang.reflect.Field;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;

public class ConstantUtils {
    public static String getStaticFieldName(Class<?> clazz, int value) {
        return ConstantUtils.getStaticFieldName(clazz, value, "");
    }

    public static String getStaticFieldName(Class<?> clazz, int value, String fieldPrefix) {
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Object f = field.get(null);
                if (f instanceof Integer && field.getName().startsWith(fieldPrefix) && (Integer)f == value) {
                    return ConstantUtils.toCamelCase(field.getName().substring(fieldPrefix.length()));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return "**error**";
            }
            catch (IllegalAccessException illegalAccessException) {
                return "**error**";
            }
            ++n2;
        }
        return "** " + value + " **";
    }

    public static int[] splitConstants(Class<?> clazz, int flags, String fieldPrefix) {
        int[] constants = new int[100];
        int size = 0;
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                int value = field.getInt(null);
                if (field.getName().startsWith(fieldPrefix) && (value & flags) != 0) {
                    constants[size] = value;
                    ++size;
                }
            }
            catch (IllegalArgumentException e) {
                Logger.debug("Unable to retrieve fields from value {}: {}", flags, e.getMessage());
            }
            catch (IllegalAccessException e) {
                Logger.debug("Unable to retrieve fields from value {}: {}", flags, e.getMessage());
            }
            ++n2;
        }
        int[] result = new int[size];
        System.arraycopy(constants, 0, result, 0, size);
        return result;
    }

    public static String toCamelCase(String s) {
        String[] parts = s.split("_");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            camelCaseString = String.valueOf(camelCaseString) + ConstantUtils.toProperCase(part);
            ++n2;
        }
        return camelCaseString;
    }

    static String toProperCase(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase();
    }
}

