/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.IndexedObjectType;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.LuceneDocumentFactory;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;

public class JaxrsElementsIndexationDelegate {
    private final JaxrsMetamodel metamodel;
    private final Directory index;
    private final StandardAnalyzer analyzer;
    private final IndexWriterConfig config;
    private IndexWriter indexWriter;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;

    public JaxrsElementsIndexationDelegate(JaxrsMetamodel metamodel) throws CoreException {
        try {
            this.metamodel = metamodel;
            this.analyzer = new StandardAnalyzer(Version.LUCENE_35);
            this.config = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)this.analyzer);
            this.config.setMaxBufferedDeleteTerms(1);
            this.index = new RAMDirectory();
            this.indexWriter = new IndexWriter(this.index, this.config);
            this.indexReader = IndexReader.open((IndexWriter)this.indexWriter, (boolean)true);
            this.indexSearcher = new IndexSearcher(this.indexReader);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.ws.jaxrs.core", "Failed to initialize JAX-RS Elements Indexer", (Throwable)e));
        }
    }

    public void dispose() throws CorruptIndexException, IOException {
        this.index.close();
    }

    public void clear() throws CoreException {
        try {
            this.indexWriter.deleteAll();
            this.indexWriter.commit();
        }
        catch (IOException e) {
            Status message = Logger.error("Failed to delete all documents in the JAX-RS Index", e);
            throw new CoreException((IStatus)message);
        }
    }

    public void indexElement(IJaxrsElement element) {
        block5: {
            long start = System.currentTimeMillis();
            try {
                try {
                    Logger.traceIndexing("Indexing {} after addition...", element.getName());
                    Document doc = LuceneDocumentFactory.createDocument(element);
                    Logger.debugIndexing("Adding JAX-RS Element into index with following fields: {}", doc.getFields());
                    this.indexWriter.addDocument(doc);
                    this.indexWriter.commit();
                }
                catch (IOException e) {
                    Logger.error("Failed to index the JAX-RS Element " + element, e);
                    Logger.traceIndexing(" Done indexing {}.", element.getName());
                    long end = System.currentTimeMillis();
                    Logger.traceIndexingPerf("Element indexed in {}ms", end - start);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Logger.traceIndexing(" Done indexing {}.", element.getName());
                long end = System.currentTimeMillis();
                Logger.traceIndexingPerf("Element indexed in {}ms", end - start);
                throw throwable;
            }
            Logger.traceIndexing(" Done indexing {}.", element.getName());
            long end = System.currentTimeMillis();
            Logger.traceIndexingPerf("Element indexed in {}ms", end - start);
        }
    }

    public void indexElement(IJaxrsEndpoint endpoint) {
        block5: {
            try {
                try {
                    Logger.traceIndexing("Indexing {} after addition...", endpoint);
                    Document doc = LuceneDocumentFactory.createDocument(endpoint);
                    Logger.debugIndexing("Adding JAX-RS Endpoint into index with following fields: {}", doc.getFields());
                    this.indexWriter.addDocument(doc);
                    this.indexWriter.commit();
                }
                catch (IOException e) {
                    Logger.error("Failed to index the JAX-RS Endpoint " + endpoint, e);
                    Logger.traceIndexing(" Done indexing {}.", endpoint);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Logger.traceIndexing(" Done indexing {}.", endpoint);
                throw throwable;
            }
            Logger.traceIndexing(" Done indexing {}.", endpoint);
        }
    }

    public void reindexElement(IJaxrsElement element) {
        block5: {
            try {
                try {
                    Logger.traceIndexing("Re-indexing {} after some internal change...", element.getName());
                    Document doc = LuceneDocumentFactory.createDocument(element);
                    Term identifierTerm = LuceneDocumentFactory.getIdentifierTerm(element);
                    this.indexWriter.updateDocument(identifierTerm, doc);
                    this.indexWriter.commit();
                    Logger.debugIndexing("Updated JAX-RS Element index with following fields: {}. Writer.hasDeletions={}", doc.getFields(), this.indexWriter.hasDeletions());
                }
                catch (IOException e) {
                    Logger.error("Failed to re-index the JAX-RS Element " + element, e);
                    Logger.traceIndexing(" Done re-indexing {}.", element);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Logger.traceIndexing(" Done re-indexing {}.", element);
                throw throwable;
            }
            Logger.traceIndexing(" Done re-indexing {}.", element);
        }
    }

    public void reindexElement(IJaxrsEndpoint endpoint) {
        block5: {
            try {
                try {
                    Logger.traceIndexing("Re-indexing {} after some internal change...", endpoint);
                    Document doc = LuceneDocumentFactory.createDocument(endpoint);
                    Term identifierTerm = LuceneDocumentFactory.getIdentifierTerm(endpoint);
                    this.indexWriter.updateDocument(identifierTerm, doc);
                    this.indexWriter.commit();
                    Logger.debugIndexing("Updated JAX-RS Endpoint index with following fields: {}. Writer.hasDeletions={}", doc.getFields(), this.indexWriter.hasDeletions());
                }
                catch (IOException e) {
                    Logger.error("Failed to re-index the JAX-RS Endpoint " + endpoint, e);
                    Logger.traceIndexing(" Done re-indexing {}.", endpoint);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Logger.traceIndexing(" Done re-indexing {}.", endpoint);
                throw throwable;
            }
            Logger.traceIndexing(" Done re-indexing {}.", endpoint);
        }
    }

    public void unindexElement(IJaxrsElement element) {
        block7: {
            try {
                try {
                    Term identifierTerm = LuceneDocumentFactory.getIdentifierTerm(element);
                    Term markerTypeTerm = LuceneDocumentFactory.getMarkerTypeTerm();
                    if (Logger.isDebugIndexingEnabled()) {
                        Logger.debugIndexing("Unindexing {} after removal...", identifierTerm);
                    }
                    BooleanQuery deleteResourceMarkersQuery = new BooleanQuery();
                    deleteResourceMarkersQuery.add(new BooleanClause((Query)new TermQuery(identifierTerm), BooleanClause.Occur.MUST));
                    deleteResourceMarkersQuery.add(new BooleanClause((Query)new TermQuery(markerTypeTerm), BooleanClause.Occur.MUST_NOT));
                    if (Logger.isDebugIndexingEnabled()) {
                        Logger.debugIndexing("Removing {} documents from index", this.count((Query)deleteResourceMarkersQuery));
                    }
                    this.indexWriter.deleteDocuments((Query)deleteResourceMarkersQuery);
                    this.indexWriter.commit();
                }
                catch (IOException e) {
                    Logger.error("Failed to unindex the JAX-RS Element " + element, e);
                    Logger.traceIndexing("Done unindexing {}.", element.getName());
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Logger.traceIndexing("Done unindexing {}.", element.getName());
                throw throwable;
            }
            Logger.traceIndexing("Done unindexing {}.", element.getName());
        }
    }

    public void unindexEndpoint(IJaxrsEndpoint endpoint) {
        block5: {
            try {
                try {
                    Logger.debugIndexing("Unindexing {} after removal...", endpoint);
                    Term identifierTerm = LuceneDocumentFactory.getIdentifierTerm(endpoint);
                    this.indexWriter.deleteDocuments(identifierTerm);
                    this.indexWriter.commit();
                }
                catch (IOException e) {
                    Logger.error("Failed to unindex the JAX-RS Element " + endpoint, e);
                    Logger.traceIndexing("Done unindexing {}.", endpoint);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Logger.traceIndexing("Done unindexing {}.", endpoint);
                throw throwable;
            }
            Logger.traceIndexing("Done unindexing {}.", endpoint);
        }
    }

    public static BooleanQuery joinTerms(Term ... terms) {
        BooleanQuery query = new BooleanQuery();
        if (terms != null) {
            Term[] termArray = terms;
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                query.add(new BooleanClause((Query)new TermQuery(term), BooleanClause.Occur.MUST));
                ++n2;
            }
        }
        return query;
    }

    public String searchElement(Term ... terms) {
        BooleanQuery query = JaxrsElementsIndexationDelegate.joinTerms(terms);
        return this.searchSingle((Query)query, IndexedObjectType.JAX_RS_ELEMENT);
    }

    private String searchSingle(Query query, IndexedObjectType type) {
        try {
            IndexSearcher searcher = this.getNewIndexSearcherIfNeeded();
            Logger.traceIndexing("Using IndexReader (current={} / hasDeletions={}) containing {} documents", this.indexReader.isCurrent(), this.indexReader.hasDeletions(), this.indexReader.numDocs());
            Logger.traceIndexing("Searching single document matching {}", query.toString());
            TopDocs result = searcher.search(query, 1);
            if (result.totalHits >= 1) {
                int docIndex = result.scoreDocs[0].doc;
                Document doc = searcher.doc(docIndex);
                String docIdentifier = doc.get("elementIdentifier");
                return docIdentifier.substring(type.getPrefix().length());
            }
        }
        catch (IOException e) {
            Logger.error("Failed to search for JAX-RS element in index", e);
        }
        Logger.traceIndexing(" Not document matched the query.", new Object[0]);
        return null;
    }

    public <T> Set<T> searchElements(Term ... terms) {
        try {
            IndexSearcher searcher = this.getNewIndexSearcherIfNeeded();
            Logger.traceIndexing("Using IndexReader (current={} / hasDeletions={}) containing {} documents", this.indexReader.isCurrent(), this.indexReader.hasDeletions(), this.indexReader.numDocs());
            BooleanQuery query = JaxrsElementsIndexationDelegate.joinTerms(terms);
            Logger.traceIndexing("Searching documents matching {}", query.toString());
            JaxrsElementsCollector collector = new JaxrsElementsCollector();
            searcher.search((Query)query, collector);
            Set elements = collector.getResults();
            Logger.traceIndexing(" Found {} matching elements", elements.size());
            return elements;
        }
        catch (IOException e) {
            Logger.error("Failed to search for JAX-RS element in index", e);
            return Collections.emptySet();
        }
    }

    public Set<JaxrsEndpoint> searchEndpoints(Term ... terms) {
        try {
            Logger.debugIndexing("Searching for Endpoints with using: {}", Arrays.asList(terms));
            IndexSearcher searcher = this.getNewIndexSearcherIfNeeded();
            Logger.traceIndexing("Using IndexReader (current={} / hasDeletions={}) containing {} documents", this.indexReader.isCurrent(), this.indexReader.hasDeletions(), this.indexReader.numDocs());
            BooleanQuery query = JaxrsElementsIndexationDelegate.joinTerms(terms);
            Logger.traceIndexing("Searching documents matching {}", query.toString());
            JaxrsEndpointsCollector collector = new JaxrsEndpointsCollector();
            searcher.search((Query)query, (Collector)collector);
            Set<JaxrsEndpoint> endpoints = collector.getResults();
            Logger.traceIndexing(" Found {} matching endpoints", endpoints.size());
            return endpoints;
        }
        catch (IOException e) {
            Logger.error("Failed to search for JAX-RS element in index", e);
            return Collections.emptySet();
        }
    }

    public int count(Query query) {
        try {
            Logger.traceIndexing("Using IndexReader (current={} / hasDeletions={}) containing {} documents", this.indexReader.isCurrent(), this.indexReader.hasDeletions(), this.indexReader.numDocs());
            IndexSearcher searcher = this.getNewIndexSearcherIfNeeded();
            TotalHitCountCollector collector = new TotalHitCountCollector();
            Logger.traceIndexing("Counting documents matching {}...", query.toString());
            searcher.search(query, (Collector)collector);
            int totalHits = collector.getTotalHits();
            Logger.traceIndexing(" Found {} matching documents", totalHits);
            return totalHits;
        }
        catch (IOException e) {
            Logger.error("Failed to search for JAX-RS element in index", e);
            return 0;
        }
    }

    private IndexSearcher getNewIndexSearcherIfNeeded() throws IOException {
        IndexReader newIndexReader = IndexReader.openIfChanged((IndexReader)this.indexReader, (IndexWriter)this.indexWriter, (boolean)true);
        if (newIndexReader != null) {
            this.indexReader = newIndexReader;
            Logger.traceIndexing("Reopening IndexReader (current={} / hasDeletions={}) now containing {} documents", this.indexReader.isCurrent(), this.indexReader.hasDeletions(), this.indexReader.numDocs());
            this.indexSearcher = new IndexSearcher(this.indexReader);
        }
        return this.indexSearcher;
    }

    static abstract class AnyResultsCollector<T>
    extends Collector {
        private IndexReader indexReader;
        final Set<T> results;
        private int docBase;

        public AnyResultsCollector(Set<T> results) {
            this.results = results;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void setNextReader(IndexReader indexReader, int docBase) throws IOException {
            this.setIndexReader(indexReader);
            this.setDocBase(docBase);
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public Set<T> getResults() throws CorruptIndexException, IOException {
            return this.results;
        }

        public IndexReader getIndexReader() {
            return this.indexReader;
        }

        public void setIndexReader(IndexReader indexReader) {
            this.indexReader = indexReader;
        }

        public int getDocBase() {
            return this.docBase;
        }

        public void setDocBase(int docBase) {
            this.docBase = docBase;
        }
    }

    class JaxrsElementsCollector<T>
    extends AnyResultsCollector<T> {
        private final String identifierPrefix;

        public JaxrsElementsCollector() {
            super(new HashSet());
            this.identifierPrefix = IndexedObjectType.JAX_RS_ELEMENT.getPrefix();
        }

        public void collect(int docId) throws IOException {
            Logger.traceIndexing("  Adding doc#{} (deleted={}) to search results", this.getDocBase() + docId, this.getIndexReader().isDeleted(docId));
            Document document = this.getIndexReader().document(docId);
            String docIdentifier = document.get("elementIdentifier");
            String docCategory = document.get("type");
            Logger.traceIndexing("  Retrieved document #{} ({})", docIdentifier, docCategory);
            IJaxrsElement element = JaxrsElementsIndexationDelegate.this.metamodel.getElement(docIdentifier.substring(this.identifierPrefix.length()));
            if (element != null) {
                this.results.add(element);
            }
        }
    }

    class JaxrsEndpointsCollector
    extends AnyResultsCollector<JaxrsEndpoint> {
        private final String identifierPrefix;

        public JaxrsEndpointsCollector() {
            super(new HashSet());
            this.identifierPrefix = IndexedObjectType.JAX_RS_ENDPOINT.getPrefix();
        }

        public void collect(int docId) throws IOException {
            Logger.traceIndexing("  Adding doc#{} (deleted={}) to search results", this.getDocBase() + docId, this.getIndexReader().isDeleted(docId));
            Document document = this.getIndexReader().document(docId);
            String docIdentifier = document.get("elementIdentifier");
            String docCategory = document.get("type");
            Logger.traceIndexing("  Retrieved document #{} ({})", docIdentifier, docCategory);
            JaxrsEndpoint endpoint = JaxrsElementsIndexationDelegate.this.metamodel.getEndpoint(docIdentifier.substring(this.identifierPrefix.length()));
            if (endpoint != null) {
                this.results.add(endpoint);
            }
        }
    }

    class ResourcesCollector
    extends AnyResultsCollector<IResource> {
        public ResourcesCollector() {
            super(new HashSet());
        }

        public void collect(int docId) throws IOException {
            Logger.traceIndexing("  Adding doc#{} (deleted={}) to search results", this.getDocBase() + docId, this.getIndexReader().isDeleted(docId));
            Document document = this.getIndexReader().document(docId);
            String identifier = document.get("elementIdentifier");
            String resourcePath = document.get("resource");
            Logger.traceIndexing("  Retrieved document #{} for resource at {}", identifier, resourcePath);
            IResource resource = JaxrsElementsIndexationDelegate.this.metamodel.getProject().getWorkspace().getRoot().findMember((IPath)new Path(resourcePath));
            if (resource != null) {
                this.results.add(resource);
            }
        }
    }
}

