/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsResourceField
extends JaxrsJavaElement<IField>
implements IJaxrsResourceField {
    private final SourceType fieldType;
    private final JaxrsResource parentResource;

    public static Builder from(IField field, CompilationUnit ast) {
        return new Builder(field, ast);
    }

    private JaxrsResourceField(Builder builder) {
        super(builder.javaField, builder.annotations, builder.metamodel);
        this.fieldType = builder.javaFieldType;
        this.parentResource = builder.parentResource;
        if (this.parentResource != null) {
            this.parentResource.addField(this);
        }
    }

    public JaxrsResource getParentResource() {
        return this.parentResource;
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        if (javaElement == null) {
            this.remove();
        } else {
            switch (javaElement.getElementType()) {
                case 5: {
                    IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
                    if (primaryType == null) break;
                    IField field = primaryType.getField(((IField)this.getJavaElement()).getElementName());
                    this.update((IJavaElement)field, ast);
                    break;
                }
                case 8: {
                    this.update(JaxrsResourceField.from((IField)javaElement, ast).build(false));
                }
            }
        }
    }

    void update(JaxrsResourceField transientField) throws CoreException {
        if (transientField == null) {
            this.remove();
        } else {
            Flags upateAnnotationsFlags = this.updateAnnotations(transientField.getAnnotations());
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, upateAnnotationsFlags);
            if (upateAnnotationsFlags.hasValue(2) && this.isMarkedForRemoval()) {
                this.remove();
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasPathParamAnnotation = this.hasAnnotation("javax.ws.rs.PathParam");
        boolean hasQueryParamAnnotation = this.hasAnnotation("javax.ws.rs.QueryParam");
        boolean hasMatrixParamAnnotation = this.hasAnnotation("javax.ws.rs.MatrixParam");
        return !hasPathParamAnnotation && !hasQueryParamAnnotation && !hasMatrixParamAnnotation;
    }

    @Override
    public void remove() throws CoreException {
        this.getParentResource().removeField(this);
        super.remove();
    }

    public Annotation getPathParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.PathParam");
    }

    public Annotation getQueryParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.QueryParam");
    }

    public Annotation getMatrixParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.MatrixParam");
    }

    public Annotation getDefaultValueAnnotation() {
        return this.getAnnotation("javax.ws.rs.DefaultValue");
    }

    public Annotation getBeanParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.BeanParam");
    }

    @Override
    public SourceType getType() {
        return this.fieldType;
    }

    @Override
    public EnumElementKind getElementKind() {
        if (this.getPathParamAnnotation() != null) {
            return EnumElementKind.PATH_PARAM_FIELD;
        }
        if (this.getQueryParamAnnotation() != null) {
            return EnumElementKind.QUERY_PARAM_FIELD;
        }
        if (this.getMatrixParamAnnotation() != null) {
            return EnumElementKind.MATRIX_PARAM_FIELD;
        }
        if (this.getBeanParamAnnotation() != null) {
            return EnumElementKind.BEAN_PARAM_FIELD;
        }
        return EnumElementKind.UNDEFINED_RESOURCE_FIELD;
    }

    public String toString() {
        return "ResourceField '" + ((IField)this.getJavaElement()).getParent().getElementName() + "." + ((IField)this.getJavaElement()).getElementName() + "' | annotations=" + this.getAnnotations();
    }

    /* synthetic */ JaxrsResourceField(Builder builder, JaxrsResourceField jaxrsResourceField) {
        this(builder);
    }

    public static class Builder {
        private final IField javaField;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsResource parentResource;
        private JaxrsMetamodel metamodel;
        private SourceType javaFieldType;

        private Builder(IField javaField, CompilationUnit ast) {
            this.javaField = javaField;
            this.ast = ast;
        }

        public Builder withParentResource(JaxrsResource parentResource) {
            this.parentResource = parentResource;
            return this;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public Builder withAnnotations(Map<String, Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public JaxrsResourceField build() throws CoreException {
            return this.build(true);
        }

        JaxrsResourceField build(boolean joinMetamodel) throws CoreException {
            long start;
            block9: {
                block8: {
                    block7: {
                        start = System.currentTimeMillis();
                        try {
                            if (this.javaField != null && this.javaField.exists() && this.javaField.isStructureKnown()) break block7;
                        }
                        catch (Throwable throwable) {
                            long end = System.currentTimeMillis();
                            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                            throw throwable;
                        }
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        return null;
                    }
                    this.javaFieldType = JdtUtils.resolveFieldType(this.javaField, this.ast);
                    IType parentType = (IType)this.javaField.getParent();
                    if (this.parentResource != null || this.metamodel == null) break block8;
                    JaxrsJavaElement parentElement = (JaxrsJavaElement)this.metamodel.findElement((IJavaElement)parentType);
                    if (parentElement != null && parentElement.getElementKind().getCategory() == EnumElementCategory.RESOURCE) {
                        this.parentResource = (JaxrsResource)parentElement;
                        break block8;
                    }
                    Logger.trace("Skipping {}.{} because parent Resource does not exist", parentType.getFullyQualifiedName(), this.javaField.getElementName());
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                    return null;
                }
                if (this.annotations == null) {
                    this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaField, this.ast);
                }
                if (!JaxrsParamAnnotations.matchesAtLeastOne(this.annotations.keySet())) break block9;
                JaxrsResourceField field = new JaxrsResourceField(this, null);
                if (joinMetamodel) {
                    field.joinMetamodel();
                }
                JaxrsResourceField jaxrsResourceField = field;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                return jaxrsResourceField;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
            return null;
        }
    }
}

