/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsProvider
extends JaxrsJavaElement<IType>
implements IJaxrsProvider {
    private final Map<EnumElementKind, IType> providedTypes;

    public static Builder from(IJavaElement javaElement) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    private JaxrsProvider(Builder builder) {
        super(builder.javaType, builder.annotations, builder.metamodel);
        this.providedTypes = builder.providedKinds;
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasProviderInterface;
        boolean hasProviderAnnotation = this.hasAnnotation("javax.ws.rs.ext.Provider");
        boolean bl = hasProviderInterface = this.getElementKind() != EnumElementKind.UNDEFINED_PROVIDER;
        return !hasProviderAnnotation && !hasProviderInterface;
    }

    @Override
    public EnumElementKind getElementKind() {
        boolean isMessageBodyReader = this.providedTypes.containsKey((Object)EnumElementKind.MESSAGE_BODY_READER);
        boolean isMessageBodyWriter = this.providedTypes.containsKey((Object)EnumElementKind.MESSAGE_BODY_WRITER);
        boolean isExceptionMapper = this.providedTypes.containsKey((Object)EnumElementKind.EXCEPTION_MAPPER);
        boolean isContextProvider = this.providedTypes.containsKey((Object)EnumElementKind.CONTEXT_RESOLVER);
        boolean isContainerRequestFilter = this.providedTypes.containsKey((Object)EnumElementKind.CONTAINER_REQUEST_FILTER);
        boolean isContainerResponseFilter = this.providedTypes.containsKey((Object)EnumElementKind.CONTAINER_RESPONSE_FILTER);
        boolean isEntityReaderInterceptor = this.providedTypes.containsKey((Object)EnumElementKind.ENTITY_READER_INTERCEPTOR);
        boolean isEntityWriterInterceptor = this.providedTypes.containsKey((Object)EnumElementKind.ENTITY_WRITER_INTERCEPTOR);
        if (isMessageBodyReader && isMessageBodyWriter) {
            return EnumElementKind.ENTITY_MAPPER;
        }
        if (isMessageBodyReader) {
            return EnumElementKind.MESSAGE_BODY_READER;
        }
        if (isMessageBodyWriter) {
            return EnumElementKind.MESSAGE_BODY_WRITER;
        }
        if (isExceptionMapper) {
            return EnumElementKind.EXCEPTION_MAPPER;
        }
        if (isContextProvider) {
            return EnumElementKind.CONTEXT_RESOLVER;
        }
        if (isContainerRequestFilter && isContainerResponseFilter) {
            return EnumElementKind.CONTAINER_FILTER;
        }
        if (isContainerRequestFilter) {
            return EnumElementKind.CONTAINER_REQUEST_FILTER;
        }
        if (isContainerResponseFilter) {
            return EnumElementKind.CONTAINER_RESPONSE_FILTER;
        }
        if (isEntityReaderInterceptor && isEntityWriterInterceptor) {
            return EnumElementKind.ENTITY_INTERCEPTOR;
        }
        if (isEntityReaderInterceptor) {
            return EnumElementKind.ENTITY_READER_INTERCEPTOR;
        }
        if (isEntityWriterInterceptor) {
            return EnumElementKind.ENTITY_WRITER_INTERCEPTOR;
        }
        return EnumElementKind.UNDEFINED_PROVIDER;
    }

    @Override
    public IType getProvidedType(EnumElementKind providerKind) {
        return this.providedTypes.get((Object)providerKind);
    }

    public Map<EnumElementKind, IType> getProvidedTypes() {
        return this.providedTypes;
    }

    public Annotation getConsumesAnnotation() {
        return this.getAnnotation("javax.ws.rs.Consumes");
    }

    @Override
    public List<String> getConsumedMediaTypes() {
        Annotation consumesAnnotation = this.getConsumesAnnotation();
        if (consumesAnnotation != null) {
            return consumesAnnotation.getValues("value");
        }
        return Collections.emptyList();
    }

    public Annotation getProducesAnnotation() {
        return this.getAnnotation("javax.ws.rs.Produces");
    }

    @Override
    public List<String> getProducedMediaTypes() {
        Annotation producesAnnotation = this.getProducesAnnotation();
        if (producesAnnotation != null) {
            return producesAnnotation.getValues("value");
        }
        return Collections.emptyList();
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        JaxrsProvider transientProvider = JaxrsProvider.from(javaElement, ast).build(false);
        if (transientProvider == null) {
            this.getProvidedTypes().clear();
            this.remove();
        } else {
            Flags updateAnnotationsFlags = this.updateAnnotations(transientProvider.getAnnotations());
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
            if (!this.getProvidedTypes().equals(transientProvider.getProvidedTypes())) {
                this.getProvidedTypes().clear();
                this.getProvidedTypes().putAll(transientProvider.getProvidedTypes());
                delta.addFlag(0x200000);
            }
            if (this.isMarkedForRemoval()) {
                this.remove();
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("JaxrsProvider ").append(((IType)this.getJavaElement()).getElementName()).append("[");
        Iterator<Map.Entry<EnumElementKind, IType>> iterator = this.providedTypes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EnumElementKind, IType> entry = iterator.next();
            builder.append(entry.getKey().toString().toLowerCase()).append("->");
            if (entry.getValue() != null && entry.getValue().exists()) {
                builder.append(entry.getValue().getFullyQualifiedName());
            } else {
                builder.append("*unknown*");
            }
            if (iterator.hasNext()) {
                builder.append(", ");
            }
            builder.append("]");
        }
        return builder.toString();
    }

    public boolean collidesWith(JaxrsProvider otherProvider, EnumElementKind elementKind) {
        switch (elementKind) {
            case MESSAGE_BODY_READER: {
                List<String> otherConsumedMediaTypes = otherProvider.getConsumedMediaTypes();
                if (otherConsumedMediaTypes.isEmpty() || this.getConsumedMediaTypes().isEmpty()) {
                    return true;
                }
                return CollectionUtils.hasIntersection(otherConsumedMediaTypes, this.getConsumedMediaTypes());
            }
            case MESSAGE_BODY_WRITER: 
            case EXCEPTION_MAPPER: {
                List<String> otherProducedMediaTypes = otherProvider.getProducedMediaTypes();
                if (otherProducedMediaTypes.isEmpty() || this.getProducedMediaTypes().isEmpty()) {
                    return true;
                }
                return CollectionUtils.hasIntersection(otherProducedMediaTypes, this.getProducedMediaTypes());
            }
        }
        return false;
    }

    /* synthetic */ JaxrsProvider(Builder builder, JaxrsProvider jaxrsProvider) {
        this(builder);
    }

    public static class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private Map<EnumElementKind, IType> providedKinds;
        private JaxrsMetamodel metamodel;

        private Builder(IType javaType, CompilationUnit ast) {
            this.javaType = javaType;
            this.ast = ast;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsProvider build() throws CoreException {
            return this.build(true);
        }

        JaxrsProvider build(boolean joinMetamodel) throws CoreException {
            long start;
            block11: {
                ITypeHierarchy providerTypeHierarchy;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                start = System.currentTimeMillis();
                                try {
                                    if (this.javaType != null && this.javaType.exists() && this.javaType.isStructureKnown()) break block7;
                                }
                                catch (Throwable throwable) {
                                    long end = System.currentTimeMillis();
                                    Logger.tracePerf("Built JAX-RS Provider in {}ms", end - start);
                                    throw throwable;
                                }
                                long end = System.currentTimeMillis();
                                Logger.tracePerf("Built JAX-RS Provider in {}ms", end - start);
                                return null;
                            }
                            if (!JdtUtils.isAbstractType(this.javaType)) break block8;
                            long end = System.currentTimeMillis();
                            Logger.tracePerf("Built JAX-RS Provider in {}ms", end - start);
                            return null;
                        }
                        providerTypeHierarchy = JdtUtils.resolveTypeHierarchy(this.javaType, (IJavaElement)this.javaType.getJavaProject(), false, (IProgressMonitor)new NullProgressMonitor());
                        IType[] subtypes = providerTypeHierarchy.getSubtypes(this.javaType);
                        if (subtypes == null || subtypes.length <= 0) break block9;
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Provider in {}ms", end - start);
                        return null;
                    }
                    IType paramConverterProviderSupertype = JdtUtils.resolveType("javax.ws.rs.ext.ParamConverterProvider", this.javaType.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
                    if (!JdtUtils.isTypeOrSuperType(paramConverterProviderSupertype, this.javaType)) break block10;
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Provider in {}ms", end - start);
                    return null;
                }
                this.providedKinds = Builder.getProvidedKinds(this.javaType, this.ast, providerTypeHierarchy, (IProgressMonitor)new NullProgressMonitor());
                this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                if (this.annotations.get("javax.ws.rs.ext.Provider") == null && this.providedKinds.isEmpty()) break block11;
                JaxrsProvider provider = new JaxrsProvider(this, null);
                if (joinMetamodel) {
                    provider.joinMetamodel();
                }
                JaxrsProvider jaxrsProvider = provider;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Provider in {}ms", end - start);
                return jaxrsProvider;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Provider in {}ms", end - start);
            return null;
        }

        private static Map<EnumElementKind, IType> getProvidedKinds(IType providerType, CompilationUnit compilationUnit, ITypeHierarchy providerTypeHierarchy, IProgressMonitor progressMonitor) throws CoreException, JavaModelException {
            HashMap<EnumElementKind, IType> implementedProviderKinds = new HashMap<EnumElementKind, IType>();
            HashMap<String, EnumElementKind> providerInterfaces = new HashMap<String, EnumElementKind>();
            providerInterfaces.put("javax.ws.rs.ext.MessageBodyReader", EnumElementKind.MESSAGE_BODY_READER);
            providerInterfaces.put("javax.ws.rs.ext.MessageBodyWriter", EnumElementKind.MESSAGE_BODY_WRITER);
            providerInterfaces.put("javax.ws.rs.ext.ExceptionMapper", EnumElementKind.EXCEPTION_MAPPER);
            providerInterfaces.put("javax.ws.rs.ext.ContextResolver", EnumElementKind.CONTEXT_RESOLVER);
            providerInterfaces.put("javax.ws.rs.container.ContainerRequestFilter", EnumElementKind.CONTAINER_REQUEST_FILTER);
            providerInterfaces.put("javax.ws.rs.container.ContainerResponseFilter", EnumElementKind.CONTAINER_RESPONSE_FILTER);
            providerInterfaces.put("javax.ws.rs.ext.ReaderInterceptor", EnumElementKind.ENTITY_READER_INTERCEPTOR);
            providerInterfaces.put("javax.ws.rs.ext.WriterInterceptor", EnumElementKind.ENTITY_WRITER_INTERCEPTOR);
            List<IType> providerTypeSuperInterfaces = Arrays.asList(providerTypeHierarchy.getAllSuperInterfaces(providerType));
            for (Map.Entry entry : providerInterfaces.entrySet()) {
                String interfaceName = (String)entry.getKey();
                EnumElementKind providerKind = (EnumElementKind)((Object)entry.getValue());
                IType matchingGenericType = JdtUtils.resolveType(interfaceName, providerType.getJavaProject(), progressMonitor);
                if (!providerTypeSuperInterfaces.contains(matchingGenericType)) continue;
                List<IType> argumentTypes = JdtUtils.resolveTypeArguments(providerType, compilationUnit, matchingGenericType, providerTypeHierarchy, progressMonitor);
                if (argumentTypes == null || argumentTypes.isEmpty()) {
                    implementedProviderKinds.put(providerKind, null);
                    continue;
                }
                implementedProviderKinds.put(providerKind, argumentTypes.get(0));
            }
            return implementedProviderKinds;
        }
    }
}

