/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsParameterAggregatorProperty
extends JaxrsJavaElement<IMethod>
implements IJaxrsParameterAggregatorProperty {
    private final SourceType methodParameterType;
    private JaxrsParameterAggregator parentParameterAggregator;

    public static Builder from(IMethod javaMethod, CompilationUnit ast) {
        return new Builder(javaMethod, ast);
    }

    private JaxrsParameterAggregatorProperty(Builder builder) {
        super(builder.javaMethod, builder.annotations, builder.metamodel);
        this.methodParameterType = builder.javaMethodParameterType;
        this.parentParameterAggregator = builder.parentParameterAggregator;
        if (this.parentParameterAggregator != null) {
            this.parentParameterAggregator.addElement(this);
        }
    }

    public JaxrsParameterAggregator getParentParameterAggregator() {
        return this.parentParameterAggregator;
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        if (javaElement == null) {
            this.remove();
        } else {
            switch (javaElement.getElementType()) {
                case 5: {
                    IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
                    if (primaryType == null) break;
                    IMethod method = primaryType.getMethod(((IMethod)this.getJavaElement()).getElementName(), ((IMethod)this.getJavaElement()).getParameterTypes());
                    this.update((IJavaElement)method, ast);
                    break;
                }
                case 9: {
                    this.update(JaxrsParameterAggregatorProperty.from((IMethod)javaElement, ast).buildTransient());
                }
            }
        }
    }

    void update(JaxrsParameterAggregatorProperty transientProperty) throws CoreException {
        if (transientProperty == null) {
            this.remove();
        } else {
            Flags upateAnnotationsFlags = this.updateAnnotations(transientProperty.getAnnotations());
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, upateAnnotationsFlags);
            if (upateAnnotationsFlags.hasValue(2) && this.isMarkedForRemoval()) {
                this.remove();
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasPathParamAnnotation = this.hasAnnotation("javax.ws.rs.PathParam");
        boolean hasQueryParamAnnotation = this.hasAnnotation("javax.ws.rs.QueryParam");
        boolean hasMatrixParamAnnotation = this.hasAnnotation("javax.ws.rs.MatrixParam");
        return !hasPathParamAnnotation && !hasQueryParamAnnotation && !hasMatrixParamAnnotation;
    }

    @Override
    public void remove() throws CoreException {
        this.getParentParameterAggregator().removeProperty(this);
        super.remove();
    }

    public Annotation getPathParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.PathParam");
    }

    public Annotation getQueryParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.QueryParam");
    }

    public Annotation getMatrixParamAnnotation() {
        return this.getAnnotation("javax.ws.rs.MatrixParam");
    }

    public Annotation getDefaultValueAnnotation() {
        return this.getAnnotation("javax.ws.rs.DefaultValue");
    }

    @Override
    public SourceType getType() {
        return this.methodParameterType;
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.PARAMETER_AGGREGATOR_PROPERTY;
    }

    public String toString() {
        return "ResourceField '" + ((IMethod)this.getJavaElement()).getParent().getElementName() + "." + ((IMethod)this.getJavaElement()).getElementName() + "' | annotations=" + this.getAnnotations();
    }

    /* synthetic */ JaxrsParameterAggregatorProperty(Builder builder, JaxrsParameterAggregatorProperty jaxrsParameterAggregatorProperty) {
        this(builder);
    }

    public static class Builder {
        private final IMethod javaMethod;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsParameterAggregator parentParameterAggregator;
        private JaxrsMetamodel metamodel;
        private SourceType javaMethodParameterType;

        private Builder(IMethod javaMethod, CompilationUnit ast) {
            this.javaMethod = javaMethod;
            this.ast = ast;
        }

        public JaxrsParameterAggregatorProperty buildTransient() throws CoreException {
            return this.buildInParentAggregator(null);
        }

        public Builder withAnnotations(Map<String, Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public JaxrsParameterAggregatorProperty buildInParentAggregator(JaxrsParameterAggregator parentParameterAggregator) throws CoreException {
            long start;
            block8: {
                block7: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaMethod != null && this.javaMethod.exists() && this.javaMethod.isStructureKnown()) break block7;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                    return null;
                }
                this.parentParameterAggregator = parentParameterAggregator;
                if (this.parentParameterAggregator != null) {
                    this.metamodel = this.parentParameterAggregator.getMetamodel();
                }
                JavaMethodSignature methodSignature = JdtUtils.resolveMethodSignature(this.javaMethod, this.ast);
                this.javaMethodParameterType = JdtUtils.getPropertyType(methodSignature);
                IType parentType = (IType)this.javaMethod.getParent();
                if (parentParameterAggregator == null && this.metamodel != null) {
                    Logger.trace("Skipping {}.{} because parent Parameter Aggregator does not exist", parentType.getFullyQualifiedName(), this.javaMethod.getElementName());
                }
                if (this.annotations == null) {
                    this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaMethod, this.ast);
                }
                if (!JaxrsParamAnnotations.matchesAtLeastOne(this.annotations.keySet())) break block8;
                JaxrsParameterAggregatorProperty field = new JaxrsParameterAggregatorProperty(this, null);
                if (this.metamodel != null) {
                    field.joinMetamodel();
                }
                JaxrsParameterAggregatorProperty jaxrsParameterAggregatorProperty = field;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                return jaxrsParameterAggregatorProperty;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
            return null;
        }
    }
}

