/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsParameterAggregatorField;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsParameterAggregatorField
extends JaxrsJavaElement<IField>
implements IJaxrsParameterAggregatorField {
    private SourceType fieldType;
    private final JaxrsParameterAggregator parentParameterAggregator;

    public static Builder from(IField field, CompilationUnit ast) {
        return new Builder(field, ast);
    }

    private JaxrsParameterAggregatorField(Builder builder) {
        super(builder.javaField, builder.annotations, builder.metamodel);
        this.fieldType = builder.javaFieldType;
        this.parentParameterAggregator = builder.parentParameterAggregator;
        if (this.parentParameterAggregator != null) {
            this.parentParameterAggregator.addElement(this);
        }
    }

    public JaxrsParameterAggregator getParentParameterAggregator() {
        return this.parentParameterAggregator;
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        if (javaElement == null) {
            this.remove();
        } else {
            switch (javaElement.getElementType()) {
                case 5: {
                    IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
                    if (primaryType == null) break;
                    IField field = primaryType.getField(((IField)this.getJavaElement()).getElementName());
                    this.update((IJavaElement)field, ast);
                    break;
                }
                case 8: {
                    this.update(JaxrsParameterAggregatorField.from((IField)javaElement, ast).buildTransient());
                }
            }
        }
    }

    void update(JaxrsParameterAggregatorField transientField) throws CoreException {
        if (transientField == null) {
            this.remove();
        } else {
            Flags updateAnnotationsFlags = this.updateAnnotations(transientField.getAnnotations());
            updateAnnotationsFlags.addFlags(this.updateType(transientField.getType()));
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
            if (updateAnnotationsFlags.hasValue(2) && this.isMarkedForRemoval()) {
                this.remove();
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    private Flags updateType(SourceType fieldType) {
        if (this.fieldType.equals(fieldType)) {
            return Flags.NONE;
        }
        this.fieldType = fieldType;
        return new Flags(4);
    }

    @Override
    boolean isMarkedForRemoval() {
        for (String annotationName : JaxrsParamAnnotations.PARAM_ANNOTATIONS) {
            if (!this.hasAnnotation(annotationName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() throws CoreException {
        this.getParentParameterAggregator().removeField(this);
        super.remove();
    }

    @Override
    public SourceType getType() {
        return this.fieldType;
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.PARAMETER_AGGREGATOR_FIELD;
    }

    public String toString() {
        return "ResourceField '" + ((IField)this.getJavaElement()).getParent().getElementName() + "." + ((IField)this.getJavaElement()).getElementName() + "' (" + this.getType().getDisplayableTypeName() + ") | annotations=" + this.getAnnotations();
    }

    /* synthetic */ JaxrsParameterAggregatorField(Builder builder, JaxrsParameterAggregatorField jaxrsParameterAggregatorField) {
        this(builder);
    }

    public static class Builder {
        private final IField javaField;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsParameterAggregator parentParameterAggregator;
        private JaxrsMetamodel metamodel;
        private SourceType javaFieldType;

        private Builder(IField javaField, CompilationUnit ast) {
            this.javaField = javaField;
            this.ast = ast;
        }

        public Builder withAnnotations(Map<String, Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public JaxrsParameterAggregatorField buildTransient() throws CoreException {
            return this.buildInParentAggregator(null);
        }

        JaxrsParameterAggregatorField buildInParentAggregator(JaxrsParameterAggregator parentParameterAggregator) throws CoreException {
            long start;
            block8: {
                block7: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaField != null && this.javaField.exists() && this.javaField.isStructureKnown()) break block7;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                    return null;
                }
                this.parentParameterAggregator = parentParameterAggregator;
                if (this.parentParameterAggregator != null) {
                    this.metamodel = this.parentParameterAggregator.getMetamodel();
                }
                this.javaFieldType = JdtUtils.resolveFieldType(this.javaField, this.ast);
                IType parentType = (IType)this.javaField.getParent();
                if (parentParameterAggregator == null && this.metamodel != null) {
                    Logger.trace("Skipping {}.{} because parent Parameter Aggregator does not exist", parentType.getFullyQualifiedName(), this.javaField.getElementName());
                }
                if (this.annotations == null) {
                    this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaField, this.ast);
                }
                if (!JaxrsParamAnnotations.matchesAtLeastOne(this.annotations.keySet())) break block8;
                JaxrsParameterAggregatorField field = new JaxrsParameterAggregatorField(this, null);
                if (this.metamodel != null) {
                    field.joinMetamodel();
                }
                JaxrsParameterAggregatorField jaxrsParameterAggregatorField = field;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                return jaxrsParameterAggregatorField;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
            return null;
        }
    }
}

