/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsParamConverterProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsParamConverterProvider
extends JaxrsJavaElement<IType>
implements IJaxrsParamConverterProvider {
    private boolean isParamConvertProviderImpl = false;

    public static Builder from(IJavaElement javaElement) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    private JaxrsParamConverterProvider(Builder builder) {
        super(builder.javaType, builder.annotations, builder.metamodel);
        this.isParamConvertProviderImpl = builder.isParamConvertProviderImpl;
    }

    public boolean isParamConvertProviderImpl() {
        return this.isParamConvertProviderImpl;
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.PARAM_CONVERTER_PROVIDER;
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        JaxrsParamConverterProvider transientProvider = JaxrsParamConverterProvider.from(javaElement, ast).build(false);
        if (transientProvider == null) {
            this.remove();
        } else {
            Flags updateAnnotationsFlags = this.updateAnnotations(transientProvider.getAnnotations());
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
            if (this.isParamConvertProviderImpl() != transientProvider.isParamConvertProviderImpl()) {
                this.isParamConvertProviderImpl = transientProvider.isParamConvertProviderImpl();
                delta.addFlag(0x800000);
            }
            if (this.isMarkedForRemoval()) {
                this.remove();
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        return !this.isParamConvertProviderImpl;
    }

    /* synthetic */ JaxrsParamConverterProvider(Builder builder, JaxrsParamConverterProvider jaxrsParamConverterProvider) {
        this(builder);
    }

    public static class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private JaxrsMetamodel metamodel = null;
        private Map<String, Annotation> annotations;
        private boolean isParamConvertProviderImpl = false;

        private Builder(IType javaType, CompilationUnit ast) {
            this.javaType = javaType;
            this.ast = ast;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsParamConverterProvider build() throws CoreException {
            return this.build(true);
        }

        JaxrsParamConverterProvider build(boolean joinMetamodel) throws CoreException {
            long start;
            block5: {
                block4: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaType != null && this.javaType.exists() && this.javaType.isStructureKnown()) break block4;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS JaxrsParamConverterProvider in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS JaxrsParamConverterProvider in {}ms", end - start);
                    return null;
                }
                IType paramConverterProviderSupertype = JdtUtils.resolveType("javax.ws.rs.ext.ParamConverterProvider", this.javaType.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
                this.isParamConvertProviderImpl = JdtUtils.isTypeOrSuperType(paramConverterProviderSupertype, this.javaType);
                this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                if (!this.isParamConvertProviderImpl) break block5;
                JaxrsParamConverterProvider paramConverterProvider = new JaxrsParamConverterProvider(this, null);
                if (joinMetamodel) {
                    paramConverterProvider.joinMetamodel();
                }
                JaxrsParamConverterProvider jaxrsParamConverterProvider = paramConverterProvider;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS JaxrsParamConverterProvider in {}ms", end - start);
                return jaxrsParamConverterProvider;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS JaxrsParamConverterProvider in {}ms", end - start);
            return null;
        }
    }
}

