/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsNameBinding
extends JaxrsJavaElement<IType>
implements IJaxrsNameBinding {
    public static Builder from(IJavaElement javaElement) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    private JaxrsNameBinding(Builder builder) {
        this(builder.javaType, (Map<String, Annotation>)builder.annotations, builder.metamodel);
    }

    protected JaxrsNameBinding(IType javaType, Map<String, Annotation> annotations, JaxrsMetamodel metamodel) {
        super(javaType, annotations, metamodel);
    }

    public boolean isBuiltIn() {
        return false;
    }

    @Override
    boolean isMarkedForRemoval() {
        return this.getNameBindingAnnotation() == null;
    }

    public Annotation getNameBindingAnnotation() {
        return this.getAnnotation("javax.ws.rs.NameBinding");
    }

    public Annotation getRetentionAnnotation() {
        return this.getAnnotation(Retention.class.getName());
    }

    public Annotation getTargetAnnotation() {
        return this.getAnnotation(Target.class.getName());
    }

    @Override
    public String getJavaClassName() {
        return ((IType)this.getJavaElement()).getFullyQualifiedName();
    }

    public String toString() {
        return "NameBinding [@" + this.getJavaClassName() + ":" + this.getNameBindingAnnotation() + "]";
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.NAME_BINDING;
    }

    @Override
    public void update(IJavaElement element, CompilationUnit ast) throws CoreException {
        JaxrsNameBinding transientNameBinding = JaxrsNameBinding.from(element, ast).build(false);
        if (transientNameBinding == null) {
            this.remove();
        } else {
            Flags flags = this.updateAnnotations(transientNameBinding.getAnnotations());
            if (this.isMarkedForRemoval()) {
                this.remove();
            } else if (this.hasMetamodel()) {
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, flags);
                this.getMetamodel().update(delta);
            }
        }
    }

    /* synthetic */ JaxrsNameBinding(Builder builder, JaxrsNameBinding jaxrsNameBinding) {
        this(builder);
    }

    public static class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private JaxrsMetamodel metamodel = null;
        private Map<String, Annotation> annotations;

        private Builder(IType javaType, CompilationUnit ast) {
            this.javaType = javaType;
            this.ast = ast;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsNameBinding build() throws CoreException {
            return this.build(true);
        }

        JaxrsNameBinding build(boolean joinMetamodel) throws CoreException {
            long start;
            block6: {
                block5: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaType != null && this.javaType.exists() && this.javaType.isStructureKnown()) break block5;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Name Binding in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Name Binding in {}ms", end - start);
                    return null;
                }
                this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                if (this.annotations != null && !this.annotations.isEmpty() && this.annotations.containsKey("javax.ws.rs.NameBinding")) break block6;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Name Binding in {}ms", end - start);
                return null;
            }
            JaxrsNameBinding nameBinding = new JaxrsNameBinding(this, null);
            if (joinMetamodel) {
                nameBinding.joinMetamodel();
            }
            JaxrsNameBinding jaxrsNameBinding = nameBinding;
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Name Binding in {}ms", end - start);
            return jaxrsNameBinding;
        }
    }
}

