/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsNameBinding;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public abstract class JaxrsJavaElement<T extends IMember>
extends JaxrsBaseElement
implements IJaxrsJavaElement {
    protected final T javaElement;
    private final Map<String, Annotation> annotations = new HashMap<String, Annotation>();

    public JaxrsJavaElement(T element, Map<String, Annotation> annotations, JaxrsMetamodel metamodel) {
        super(metamodel);
        this.javaElement = element;
        if (annotations != null) {
            this.annotations.putAll(annotations);
        }
    }

    static Map<String, Annotation> singleToMap(Annotation annotation) {
        if (annotation != null) {
            return CollectionUtils.toMap(annotation.getFullyQualifiedName(), annotation);
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isBinary() {
        if (this.javaElement == null) {
            return true;
        }
        return this.javaElement.isBinary();
    }

    public Annotation getAnnotation(String className) {
        return this.annotations.get(className);
    }

    public boolean hasAnnotation(String className) {
        return this.annotations.get(className) != null;
    }

    public final T getJavaElement() {
        return this.javaElement;
    }

    @Override
    public String getIdentifier() {
        return this.javaElement.getHandleIdentifier();
    }

    @Override
    public String getName() {
        return this.javaElement != null ? this.javaElement.getElementName() : "*unknown java element*";
    }

    public Map<String, Annotation> getAnnotations() {
        return this.annotations;
    }

    public void addOrUpdateAnnotation(Annotation annotation) throws CoreException {
        if (annotation != null) {
            boolean changed = false;
            EnumElementKind previousKind = this.getElementKind();
            String annotationName = annotation.getFullyQualifiedName();
            if (this.annotations.containsKey(annotationName)) {
                changed = this.annotations.get(annotationName).update(annotation);
            } else {
                this.annotations.put(annotationName, annotation);
                changed = true;
            }
            if (changed) {
                int flags = this.qualifyChange(annotationName, previousKind);
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, flags);
                this.getMetamodel().update(delta);
            }
        }
    }

    public void addAnnotation(Annotation annotation) throws CoreException {
        JaxrsElementDelta delta = new JaxrsElementDelta(this, 4);
        int addAnnotationFlags = this.internalAddAnnotation(annotation);
        delta.addFlag(addAnnotationFlags);
        if (this.hasMetamodel()) {
            this.getMetamodel().update(delta);
        }
    }

    public int updateAnnotation(Annotation annotation) throws CoreException {
        int flags = this.internalUpdateAnnotation(annotation);
        if (flags != 0) {
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, flags);
            this.getMetamodel().update(delta);
        }
        return flags;
    }

    private int internalAddAnnotation(Annotation annotation) {
        if (annotation == null) {
            return 0;
        }
        EnumElementKind previousKind = this.getElementKind();
        String annotationName = annotation.getFullyQualifiedName();
        this.annotations.put(annotationName, annotation);
        int flags = this.qualifyChange(annotationName, previousKind);
        return flags;
    }

    private int internalUpdateAnnotation(Annotation annotation) {
        if (annotation == null || !this.hasAnnotation(annotation.getFullyQualifiedName())) {
            return 0;
        }
        EnumElementKind previousKind = this.getElementKind();
        String annotationName = annotation.getFullyQualifiedName();
        if (this.annotations.get(annotationName).update(annotation)) {
            return this.qualifyChange(annotationName, previousKind);
        }
        return 0;
    }

    Flags updateAnnotations(Map<String, Annotation> otherAnnotations) {
        Flags flags = new Flags();
        CollectionUtils.MapComparison<String, Annotation> annotationsComparison = CollectionUtils.compare(this.annotations, otherAnnotations);
        Map<String, Annotation> addedAnnotations = annotationsComparison.getAddedItems();
        Map<String, Annotation> removedAnnotations = annotationsComparison.getRemovedItems();
        Map<String, Annotation> changedAnnotations = annotationsComparison.getChangedItems();
        for (Map.Entry<String, Annotation> entry : addedAnnotations.entrySet()) {
            flags.addFlags(this.internalAddAnnotation(entry.getValue()));
        }
        for (Map.Entry<String, Annotation> entry : changedAnnotations.entrySet()) {
            flags.addFlags(this.internalUpdateAnnotation(entry.getValue()));
        }
        for (Map.Entry<String, Annotation> entry : removedAnnotations.entrySet()) {
            flags.addFlags(this.internalRemoveAnnotation(entry.getValue().getJavaAnnotation()));
        }
        return flags;
    }

    private int qualifyChange(String annotationName, EnumElementKind previousKind) {
        EnumElementKind currentKind = this.getElementKind();
        int flag = this.computeChangeAnnotationFlag(annotationName);
        if (currentKind != previousKind) {
            flag += 2;
        }
        return flag;
    }

    private int computeChangeAnnotationFlag(String annotationName) {
        if (annotationName.equals("javax.ws.rs.Path")) {
            return 8;
        }
        if (annotationName.equals("javax.ws.rs.ApplicationPath")) {
            return 16;
        }
        if (annotationName.equals("javax.ws.rs.HttpMethod")) {
            return 256;
        }
        if (annotationName.equals("javax.ws.rs.NameBinding")) {
            return 0x400000;
        }
        if (annotationName.equals("java.lang.annotation.Target")) {
            return 131072;
        }
        if (annotationName.equals("java.lang.annotation.Retention")) {
            return 262144;
        }
        if (annotationName.equals("javax.ws.rs.ext.Provider")) {
            return 524288;
        }
        if (annotationName.equals("javax.ws.rs.PathParam")) {
            return 512;
        }
        if (annotationName.equals("javax.ws.rs.QueryParam")) {
            return 1024;
        }
        if (annotationName.equals("javax.ws.rs.MatrixParam")) {
            return 2048;
        }
        if (annotationName.equals("javax.ws.rs.DefaultValue")) {
            return 4096;
        }
        if (annotationName.equals("javax.ws.rs.Encoded")) {
            return 0x100000;
        }
        if (annotationName.equals("javax.ws.rs.Consumes")) {
            return 8192;
        }
        if (annotationName.equals("javax.ws.rs.Produces")) {
            return 16384;
        }
        for (IJaxrsHttpMethod httpMethod : this.getMetamodel().findAllHttpMethods()) {
            if (!httpMethod.getJavaClassName().equals(annotationName)) continue;
            return 256;
        }
        for (IJaxrsNameBinding nameBinding : this.getMetamodel().findAllNameBindings()) {
            if (!nameBinding.getJavaClassName().equals(annotationName)) continue;
            return 0x400000;
        }
        return 0;
    }

    public void removeAnnotation(IAnnotation annotation) throws CoreException {
        if (annotation != null) {
            int flags = this.internalRemoveAnnotation(annotation);
            if (this.isMarkedForRemoval()) {
                this.remove();
            } else {
                JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, flags);
                this.getMetamodel().update(delta);
            }
        }
    }

    private int internalRemoveAnnotation(IAnnotation annotation) {
        int flags = 0;
        String annotationName = null;
        if (annotation != null) {
            EnumElementKind previousKind = this.getElementKind();
            Iterator<Map.Entry<String, Annotation>> iterator = this.annotations.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Annotation> entry = iterator.next();
                if (!entry.getValue().getJavaAnnotation().getHandleIdentifier().equals(annotation.getHandleIdentifier())) continue;
                annotationName = entry.getKey();
                iterator.remove();
                break;
            }
            if (annotationName != null) {
                flags = this.qualifyChange(annotationName, previousKind);
            }
        }
        return flags;
    }

    @Override
    public IResource getResource() {
        return this.javaElement.getResource();
    }

    public Map<String, Annotation> getNameBindingAnnotations() {
        Collection<Annotation> annotations = this.getAnnotations().values();
        HashMap<String, Annotation> nameBindingAnnotations = new HashMap<String, Annotation>();
        for (Annotation annotation : annotations) {
            String annotationClassName = annotation.getFullyQualifiedName();
            if (this.getMetamodel().findNameBinding(annotationClassName) == null) continue;
            nameBindingAnnotations.put(annotation.getFullyQualifiedName(), annotation);
        }
        return nameBindingAnnotations;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.javaElement == null ? 0 : this.javaElement.getHandleIdentifier().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JaxrsJavaElement other = (JaxrsJavaElement)obj;
        return !(this.javaElement == null ? other.javaElement != null : !this.javaElement.getHandleIdentifier().equals(((IMember)other.javaElement).getHandleIdentifier()));
    }

    public abstract void update(IJavaElement var1, CompilationUnit var2) throws CoreException;

    public IJavaElement getJavaProject() {
        if (this.javaElement != null) {
            return this.javaElement.getJavaProject();
        }
        return null;
    }
}

