/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsWebxmlApplication;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsJavaApplication
extends JaxrsJavaElement<IType>
implements IJaxrsJavaApplication {
    private boolean isApplicationSubclass = false;
    private String applicationPathOverride = null;

    public static Builder from(IJavaElement javaElement) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    public JaxrsJavaApplication(Builder builder) {
        super(builder.javaType, builder.annotations, builder.metamodel);
        JaxrsWebxmlApplication webxmlApplication;
        this.isApplicationSubclass = builder.isApplicationSubclass;
        if (this.hasMetamodel() && (webxmlApplication = this.getMetamodel().findWebxmlApplicationByClassName(this.getJavaClassName())) != null) {
            this.applicationPathOverride = webxmlApplication.getApplicationPath();
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        return !this.isApplicationSubclass && this.getApplicationPathAnnotation() == null;
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.APPLICATION_JAVA;
    }

    @Override
    public boolean isWebXmlApplication() {
        return false;
    }

    @Override
    public boolean isJavaApplication() {
        return true;
    }

    public boolean isJaxrsCoreApplicationSubclass() {
        return this.isApplicationSubclass;
    }

    public void setJaxrsCoreApplicationSubclass(boolean isApplicationSubclass) {
        this.isApplicationSubclass = isApplicationSubclass;
    }

    @Override
    public String getJavaClassName() {
        return ((IType)this.getJavaElement()).getFullyQualifiedName();
    }

    public void setApplicationPathOverride(String applicationPathOverride) throws CoreException {
        Logger.debug("Override @ApplicationPath value with '{}'", applicationPathOverride);
        this.applicationPathOverride = applicationPathOverride;
        if (this.hasMetamodel()) {
            this.getMetamodel().update(new JaxrsElementDelta((IJaxrsElement)this, 4, 64));
        }
    }

    public void unsetApplicationPathOverride() throws CoreException {
        Logger.debug("Unoverriding @ApplicationPath value");
        this.applicationPathOverride = null;
        if (this.hasMetamodel()) {
            this.getMetamodel().update(new JaxrsElementDelta((IJaxrsElement)this, 4, 64));
        }
    }

    @Override
    public String getApplicationPath() {
        if (this.applicationPathOverride != null) {
            return this.applicationPathOverride;
        }
        Annotation applicationPathAnnotation = this.getApplicationPathAnnotation();
        if (applicationPathAnnotation != null) {
            return applicationPathAnnotation.getValue();
        }
        return null;
    }

    public Annotation getApplicationPathAnnotation() {
        return this.getAnnotation("javax.ws.rs.ApplicationPath");
    }

    public boolean isOverriden() {
        if (this.getMetamodel() != null) {
            return this.getMetamodel().findWebxmlApplicationByClassName(this.getJavaClassName()) != null;
        }
        return false;
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        JaxrsJavaApplication transientApplication = JaxrsJavaApplication.from(javaElement, ast).build(false);
        if (transientApplication == null) {
            this.remove();
        } else {
            Flags updateAnnotationsFlag = this.updateAnnotations(transientApplication.getAnnotations());
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlag);
            if (this.isJaxrsCoreApplicationSubclass() != transientApplication.isJaxrsCoreApplicationSubclass()) {
                this.isApplicationSubclass = transientApplication.isJaxrsCoreApplicationSubclass();
                delta.addFlag(128);
            }
            if (this.isMarkedForRemoval()) {
                this.remove();
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    public String toString() {
        return "JavaApplication '" + ((IType)this.getJavaElement()).getElementName() + "': path=" + this.getApplicationPath();
    }

    public static class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private Map<String, Annotation> annotations;
        private JaxrsMetamodel metamodel = null;
        private boolean isApplicationSubclass = false;

        private Builder(IType javaType, CompilationUnit ast) {
            this.javaType = javaType;
            this.ast = ast;
        }

        public Builder withMetamodel(JaxrsMetamodel metamodel) {
            this.metamodel = metamodel;
            return this;
        }

        public JaxrsJavaApplication build() throws CoreException {
            return this.build(true);
        }

        JaxrsJavaApplication build(boolean joinMetamodel) throws CoreException {
            long start;
            block5: {
                block4: {
                    start = System.currentTimeMillis();
                    try {
                        if (this.javaType != null && this.javaType.exists() && this.javaType.isStructureKnown()) break block4;
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
                    return null;
                }
                IType applicationSupertype = JdtUtils.resolveType("javax.ws.rs.core.Application", this.javaType.getJavaProject(), (IProgressMonitor)new NullProgressMonitor());
                this.isApplicationSubclass = JdtUtils.isTypeOrSuperType(applicationSupertype, this.javaType);
                this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                Annotation applicationPathAnnotation = this.annotations.get("javax.ws.rs.ApplicationPath");
                if (!this.isApplicationSubclass && applicationPathAnnotation == null) break block5;
                JaxrsJavaApplication application = new JaxrsJavaApplication(this);
                if (joinMetamodel) {
                    application.joinMetamodel();
                }
                JaxrsJavaApplication jaxrsJavaApplication = application;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
                return jaxrsJavaApplication;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS JavaApplication in {}ms", end - start);
            return null;
        }
    }
}

