/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.builder.Flags;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ObjectUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IAnnotatedSourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;

public class JaxrsEndpoint
implements IJaxrsEndpoint {
    private final String identifier = UUID.randomUUID().toString();
    private final JaxrsMetamodel metamodel;
    private final LinkedList<JaxrsResourceMethod> resourceMethods;
    private IJaxrsHttpMethod httpMethod;
    private IJaxrsApplication application = null;
    private String uriPathTemplate = null;
    private List<String> consumedMediaTypes = null;
    private List<String> producedMediaTypes = null;

    public JaxrsEndpoint(JaxrsMetamodel metamodel, IJaxrsHttpMethod httpMethod, LinkedList<JaxrsResourceMethod> resourceMethods) {
        this.metamodel = metamodel;
        this.application = metamodel != null ? metamodel.findApplication() : null;
        this.httpMethod = httpMethod;
        this.resourceMethods = resourceMethods;
        this.refreshUriPathTemplate();
        this.refreshConsumedMediaTypes();
        this.refreshProducedMediaTypes();
    }

    public void joinMetamodel() {
        if (this.metamodel != null) {
            this.metamodel.add(this);
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public EnumElementCategory getElementCategory() {
        return EnumElementCategory.ENDPOINT;
    }

    public String toString() {
        IMethod javaMethod = (IMethod)this.resourceMethods.getLast().getJavaElement();
        return String.valueOf(this.httpMethod != null ? this.httpMethod.getHttpVerb() : null) + " " + this.uriPathTemplate + " | consumes:" + this.consumedMediaTypes + " | produces=" + this.producedMediaTypes + " in method " + javaMethod.getParent().getElementName() + "." + javaMethod.getElementName() + "(...)";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JaxrsEndpoint other = (JaxrsEndpoint)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    public boolean update(IJaxrsHttpMethod httpMethod) {
        this.metamodel.update(this);
        return true;
    }

    public boolean update(IJaxrsApplication application) {
        if (application.equals(this.metamodel.findApplication())) {
            this.application = application;
            this.refreshUriPathTemplate();
            this.metamodel.update(this);
            return true;
        }
        return false;
    }

    public boolean remove(IJaxrsApplication application) {
        if (this.application.equals(application)) {
            this.application = this.metamodel.findApplication();
            this.refreshUriPathTemplate();
            this.metamodel.update(this);
            return true;
        }
        return false;
    }

    public void update(Flags flags) throws CoreException {
        boolean changed = false;
        if (flags.hasValue(256)) {
            boolean bl = changed = changed || this.refreshHttpMethod();
        }
        if (flags.hasValue(8, 512, 1024, 2048, 0x1000000, 4096, 32768)) {
            boolean bl = changed = changed || this.refreshUriPathTemplate();
        }
        if (flags.hasValue(8192)) {
            boolean bl = changed = changed || this.refreshConsumedMediaTypes();
        }
        if (flags.hasValue(16384)) {
            boolean bl = changed = changed || this.refreshProducedMediaTypes();
        }
        if (changed) {
            this.metamodel.update(this);
        }
    }

    private boolean refreshHttpMethod() throws CoreException {
        IJaxrsResourceMethod resourceMethod = this.resourceMethods.getLast();
        String httpMethodClassName = resourceMethod.getHttpMethodClassName();
        if (httpMethodClassName != null) {
            return this.setHttpMethod(this.metamodel.findHttpMethodByTypeName(httpMethodClassName));
        }
        return false;
    }

    private boolean setHttpMethod(JaxrsHttpMethod newHttpMethod) {
        if (!ObjectUtils.nullSafeEquals(this.httpMethod, newHttpMethod)) {
            this.httpMethod = newHttpMethod;
            return true;
        }
        return false;
    }

    private boolean refreshProducedMediaTypes() {
        JaxrsResourceMethod resourceMethod = this.resourceMethods.getLast();
        JaxrsResource resource = resourceMethod.getParentResource();
        if (CollectionUtils.notNullNorEmpty(resourceMethod.getProducedMediaTypes())) {
            return this.setProducedMediaTypes(resourceMethod.getProducedMediaTypes());
        }
        if (CollectionUtils.notNullNorEmpty(resourceMethod.getParentResource().getProducedMediaTypes())) {
            return this.setProducedMediaTypes(resource.getProducedMediaTypes());
        }
        return this.setProducedMediaTypes(Arrays.asList("*/*"));
    }

    private boolean setProducedMediaTypes(List<String> newProducedMediaTypes) {
        if (!ObjectUtils.nullSafeEquals(this.producedMediaTypes, newProducedMediaTypes)) {
            this.producedMediaTypes = newProducedMediaTypes;
            return true;
        }
        return false;
    }

    private boolean refreshConsumedMediaTypes() {
        IJaxrsResourceMethod resourceMethod = this.resourceMethods.getLast();
        IJaxrsResource resource = resourceMethod.getParentResource();
        if (CollectionUtils.notNullNorEmpty(resourceMethod.getConsumedMediaTypes())) {
            return this.setConsumedMediaTypes(resourceMethod.getConsumedMediaTypes());
        }
        if (CollectionUtils.notNullNorEmpty(resourceMethod.getParentResource().getConsumedMediaTypes())) {
            return this.setConsumedMediaTypes(resource.getConsumedMediaTypes());
        }
        return this.setConsumedMediaTypes(Arrays.asList("*/*"));
    }

    private boolean setConsumedMediaTypes(List<String> newConsumedMediaTypes) {
        if (!ObjectUtils.nullSafeEquals(this.consumedMediaTypes, newConsumedMediaTypes)) {
            this.consumedMediaTypes = newConsumedMediaTypes;
            return true;
        }
        return false;
    }

    private boolean refreshUriPathTemplate() {
        JaxrsResourceMethod firstResourceMethod;
        String displayableResourcePathTemplate;
        StringBuilder uriPathTemplateBuilder = new StringBuilder();
        ArrayList<String> queryParams = new ArrayList<String>();
        if (this.application != null && this.application.getApplicationPath() != null) {
            uriPathTemplateBuilder.append(this.application.getApplicationPath());
        }
        if (!(displayableResourcePathTemplate = JaxrsEndpoint.getDisplayablePathTemplate((firstResourceMethod = this.resourceMethods.get(0)).getParentResource(), firstResourceMethod)).isEmpty()) {
            uriPathTemplateBuilder.append(displayableResourcePathTemplate);
        }
        for (JaxrsResourceMethod resourceMethod : this.resourceMethods) {
            String displayableResourceMethodPathTemplate = this.getDisplayablePathTemplate(resourceMethod);
            if (!displayableResourceMethodPathTemplate.isEmpty()) {
                uriPathTemplateBuilder.append(displayableResourceMethodPathTemplate);
            }
            List<String> displayableResourceMethodQueryParameters = this.getDisplayableQueryParameters(resourceMethod);
            queryParams.addAll(displayableResourceMethodQueryParameters);
        }
        if (!queryParams.isEmpty()) {
            uriPathTemplateBuilder.append('?');
            Iterator iterator = queryParams.iterator();
            while (iterator.hasNext()) {
                uriPathTemplateBuilder.append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                uriPathTemplateBuilder.append('&');
            }
        }
        String template = uriPathTemplateBuilder.toString();
        while (template.indexOf("//") > -1) {
            template = template.replace("//", "/");
        }
        return this.setUriPathTemplate(template);
    }

    private static String getDisplayablePathTemplate(JaxrsResource resource, JaxrsResourceMethod resourceMethod) {
        if (!AnnotationUtils.isValidAnnotationValue(resource.getPathTemplate())) {
            return "";
        }
        StringBuilder pathTemplateBuilder = new StringBuilder();
        int index = 0;
        if (resource.getPathTemplate() != null) {
            while (index < resource.getPathTemplate().length()) {
                if (!resource.getPathTemplate().startsWith("/")) {
                    pathTemplateBuilder.append('/');
                }
                int beginIndex = resource.getPathTemplate().indexOf(123, index);
                int endIndex = resource.getPathTemplate().indexOf(125, beginIndex + 1);
                if (beginIndex > index) {
                    pathTemplateBuilder.append(resource.getPathTemplate().substring(index, beginIndex));
                } else if (beginIndex == -1) {
                    pathTemplateBuilder.append(resource.getPathTemplate().substring(index));
                    break;
                }
                String pathArg = resource.getPathTemplate().substring(beginIndex + 1, endIndex).replace(" ", "");
                if (pathArg.contains(":")) {
                    pathTemplateBuilder.append('{').append(pathArg).append('}');
                } else {
                    IAnnotatedSourceType parameterType = resourceMethod.getRelatedTypeAnnotatedWith("javax.ws.rs.PathParam", pathArg);
                    if (parameterType != null) {
                        pathTemplateBuilder.append('{').append(pathArg);
                        if (parameterType.getType() != null) {
                            pathTemplateBuilder.append(":").append(parameterType.getType().getDisplayableTypeName());
                        }
                        pathTemplateBuilder.append('}');
                    } else {
                        pathTemplateBuilder.append('{').append(pathArg).append(":.*").append('}');
                    }
                }
                index = endIndex + 1;
            }
        }
        return pathTemplateBuilder.toString();
    }

    private String getDisplayablePathTemplate(JaxrsResourceMethod resourceMethod) {
        if (!AnnotationUtils.isValidAnnotationValue(resourceMethod.getPathTemplate())) {
            return "";
        }
        StringBuilder pathTemplateBuilder = new StringBuilder();
        int index = 0;
        if (resourceMethod.getPathTemplate() != null) {
            if (!resourceMethod.getPathTemplate().startsWith("/")) {
                pathTemplateBuilder.append('/');
            }
            while (index < resourceMethod.getPathTemplate().length()) {
                int beginIndex = resourceMethod.getPathTemplate().indexOf(123, index);
                int endIndex = resourceMethod.getPathTemplate().indexOf(125, beginIndex + 1);
                if (beginIndex > index) {
                    pathTemplateBuilder.append(resourceMethod.getPathTemplate().substring(index, beginIndex));
                } else {
                    if (beginIndex == -1) {
                        pathTemplateBuilder.append(resourceMethod.getPathTemplate().substring(index));
                        break;
                    }
                    if (beginIndex != -1 && endIndex == -1) break;
                }
                String pathArg = resourceMethod.getPathTemplate().substring(beginIndex + 1, endIndex).replace(" ", "");
                if (pathArg.contains(":")) {
                    pathTemplateBuilder.append('{').append(pathArg).append('}');
                } else {
                    IAnnotatedSourceType parameterType = resourceMethod.getRelatedTypeAnnotatedWith("javax.ws.rs.PathParam", pathArg);
                    if (parameterType != null) {
                        pathTemplateBuilder.append('{').append(pathArg);
                        if (parameterType.getType() != null) {
                            pathTemplateBuilder.append(":").append(parameterType.getType().getDisplayableTypeName());
                        }
                        pathTemplateBuilder.append('}');
                    } else {
                        pathTemplateBuilder.append('{').append(pathArg).append(":.*").append('}');
                    }
                }
                index = endIndex + 1;
            }
        }
        ArrayList<String> matrixParamFieldAnnotationValues = new ArrayList<String>();
        List<IAnnotatedSourceType> matrixParams = resourceMethod.getRelatedTypesAnnotatedWith("javax.ws.rs.MatrixParam");
        for (IAnnotatedSourceType matrixParam : matrixParams) {
            pathTemplateBuilder.append(';');
            String matrixParamFieldAnnotationValue = matrixParam.getAnnotation("javax.ws.rs.MatrixParam").getValue();
            matrixParamFieldAnnotationValues.add(matrixParamFieldAnnotationValue);
            pathTemplateBuilder.append(matrixParamFieldAnnotationValue).append("={").append(matrixParam.getType().getDisplayableTypeName());
            if (matrixParam.hasAnnotation("javax.ws.rs.DefaultValue")) {
                pathTemplateBuilder.append(':').append('\"').append(matrixParam.getAnnotation("javax.ws.rs.DefaultValue").getValue()).append('\"');
            }
            pathTemplateBuilder.append('}');
        }
        return pathTemplateBuilder.toString();
    }

    private List<String> getDisplayableQueryParameters(JaxrsResourceMethod resourceMethod) {
        HashSet<String> queryParams = new HashSet<String>();
        ArrayList<String> displayableQueryParams = new ArrayList<String>();
        List<IAnnotatedSourceType> queryParamTypes = resourceMethod.getRelatedTypesAnnotatedWith("javax.ws.rs.QueryParam");
        for (IAnnotatedSourceType annotatedSourceType : queryParamTypes) {
            String annotationValue = annotatedSourceType.getAnnotation("javax.ws.rs.QueryParam").getValue();
            String annotationDisplayableValue = this.createDisplayableQueryParam(annotatedSourceType.getType(), annotatedSourceType.getAnnotations());
            if (queryParams.contains(annotationValue)) continue;
            queryParams.add(annotationValue);
            displayableQueryParams.add(annotationDisplayableValue);
        }
        return displayableQueryParams;
    }

    public String createDisplayableQueryParam(SourceType type, Map<String, Annotation> annotations) {
        StringBuilder queryParamBuilder = new StringBuilder();
        String queryParamAnnotationValue = annotations.get("javax.ws.rs.QueryParam").getValue();
        queryParamBuilder.append(queryParamAnnotationValue).append("={");
        if (type != null) {
            queryParamBuilder.append(type.getDisplayableTypeName());
        } else {
            queryParamBuilder.append("unknown");
        }
        if (annotations.containsKey("javax.ws.rs.DefaultValue")) {
            queryParamBuilder.append(':').append('\"').append(annotations.get("javax.ws.rs.DefaultValue").getValue()).append('\"');
        }
        String queryParam = queryParamBuilder.append('}').toString();
        return queryParam;
    }

    private boolean setUriPathTemplate(String template) {
        if (!ObjectUtils.nullSafeEquals(this.uriPathTemplate, template)) {
            this.uriPathTemplate = template;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(IJaxrsEndpoint other) {
        int uriPathTemplateComparison = this.uriPathTemplate.compareTo(other.getUriPathTemplate());
        if (uriPathTemplateComparison != 0) {
            return uriPathTemplateComparison;
        }
        return this.httpMethod.compareTo(other.getHttpMethod());
    }

    @Override
    public IJaxrsHttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public IJaxrsApplication getApplication() {
        return this.application;
    }

    @Override
    public LinkedList<IJaxrsResourceMethod> getResourceMethods() {
        return new LinkedList<IJaxrsResourceMethod>(this.resourceMethods);
    }

    @Override
    public String getUriPathTemplate() {
        return this.uriPathTemplate;
    }

    @Override
    public List<String> getConsumedMediaTypes() {
        return this.consumedMediaTypes;
    }

    @Override
    public List<String> getProducedMediaTypes() {
        return this.producedMediaTypes;
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.metamodel.getJavaProject();
    }

    @Override
    public IProject getProject() {
        return this.metamodel.getProject();
    }

    @Override
    public int getProblemLevel() {
        int level = 0;
        for (IJaxrsResourceMethod resourceMethod : this.getResourceMethods()) {
            level = Math.max(level, resourceMethod.getMarkerSeverity());
        }
        return level;
    }

    public void remove() {
        this.metamodel.remove(this);
    }
}

