/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;

public abstract class JaxrsBaseElement
implements IJaxrsElement {
    private final JaxrsMetamodel metamodel;
    private int markerSeverity;
    public boolean exist = true;

    public JaxrsBaseElement(JaxrsMetamodel metamodel) {
        this.metamodel = metamodel;
    }

    public boolean exists() {
        return this.exist;
    }

    public void resetProblemLevel() {
        this.markerSeverity = 0;
    }

    public void registerMarker(IMarker marker) {
        this.markerSeverity = Math.max(this.markerSeverity, marker.getAttribute("severity", 0));
    }

    @Override
    public final int getMarkerSeverity() {
        return this.markerSeverity;
    }

    @Override
    public final JaxrsMetamodel getMetamodel() {
        return this.metamodel;
    }

    protected void joinMetamodel() throws CoreException {
        if (this.metamodel != null) {
            this.metamodel.add(this);
        }
    }

    public void remove() throws CoreException {
        this.exist = false;
        if (this.getMetamodel().containsElement(this)) {
            this.getMetamodel().remove(this);
        } else {
            Logger.debug("Element {} was already removed from the metamodel", this.getName());
        }
    }

    abstract boolean isMarkedForRemoval();

    protected boolean hasMetamodel() {
        return this.getMetamodel() != null;
    }
}

